/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CreateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.DeleteSessionTemplateRequest;
import com.google.cloud.dataproc.v1.GetSessionTemplateRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesRequest;
import com.google.cloud.dataproc.v1.ListSessionTemplatesResponse;
import com.google.cloud.dataproc.v1.SessionTemplate;
import com.google.cloud.dataproc.v1.SessionTemplateControllerClient;
import com.google.cloud.dataproc.v1.UpdateSessionTemplateRequest;
import com.google.cloud.dataproc.v1.stub.GrpcSessionTemplateControllerStub;
import com.google.cloud.dataproc.v1.stub.HttpJsonSessionTemplateControllerStub;
import com.google.cloud.dataproc.v1.stub.SessionTemplateControllerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class SessionTemplateControllerStubSettings
extends StubSettings<SessionTemplateControllerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateSettings;
    private final UnaryCallSettings<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateSettings;
    private final UnaryCallSettings<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateSettings;
    private final PagedCallSettings<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesSettings;
    private final UnaryCallSettings<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate> LIST_SESSION_TEMPLATES_PAGE_STR_DESC = new PagedListDescriptor<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate>(){

        public String emptyToken() {
            return "";
        }

        public ListSessionTemplatesRequest injectToken(ListSessionTemplatesRequest payload, String token) {
            return ListSessionTemplatesRequest.newBuilder((ListSessionTemplatesRequest)payload).setPageToken(token).build();
        }

        public ListSessionTemplatesRequest injectPageSize(ListSessionTemplatesRequest payload, int pageSize) {
            return ListSessionTemplatesRequest.newBuilder((ListSessionTemplatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSessionTemplatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSessionTemplatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SessionTemplate> extractResources(ListSessionTemplatesResponse payload) {
            return payload.getSessionTemplatesList() == null ? ImmutableList.of() : payload.getSessionTemplatesList();
        }
    };
    private static final PagedListResponseFactory<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> LIST_SESSION_TEMPLATES_PAGE_STR_FACT = new PagedListResponseFactory<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse>(){

        public ApiFuture<SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSessionTemplatesRequest, ListSessionTemplatesResponse> callable, ListSessionTemplatesRequest request, ApiCallContext context, ApiFuture<ListSessionTemplatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SESSION_TEMPLATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SessionTemplateControllerClient.ListSessionTemplatesPagedResponse.createAsync((PageContext<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplate>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateSettings() {
        return this.createSessionTemplateSettings;
    }

    public UnaryCallSettings<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateSettings() {
        return this.updateSessionTemplateSettings;
    }

    public UnaryCallSettings<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateSettings() {
        return this.getSessionTemplateSettings;
    }

    public PagedCallSettings<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesSettings() {
        return this.listSessionTemplatesSettings;
    }

    public UnaryCallSettings<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateSettings() {
        return this.deleteSessionTemplateSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public SessionTemplateControllerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSessionTemplateControllerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSessionTemplateControllerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dataproc";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dataproc.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataproc.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SessionTemplateControllerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionTemplateControllerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SessionTemplateControllerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SessionTemplateControllerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SessionTemplateControllerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSessionTemplateSettings = settingsBuilder.createSessionTemplateSettings().build();
        this.updateSessionTemplateSettings = settingsBuilder.updateSessionTemplateSettings().build();
        this.getSessionTemplateSettings = settingsBuilder.getSessionTemplateSettings().build();
        this.listSessionTemplatesSettings = settingsBuilder.listSessionTemplatesSettings().build();
        this.deleteSessionTemplateSettings = settingsBuilder.deleteSessionTemplateSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SessionTemplateControllerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateSettings;
        private final UnaryCallSettings.Builder<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateSettings;
        private final UnaryCallSettings.Builder<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateSettings;
        private final PagedCallSettings.Builder<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesSettings;
        private final UnaryCallSettings.Builder<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSessionTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSessionTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSessionTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSessionTemplatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SESSION_TEMPLATES_PAGE_STR_FACT);
            this.deleteSessionTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionTemplateSettings, this.updateSessionTemplateSettings, this.getSessionTemplateSettings, this.listSessionTemplatesSettings, this.deleteSessionTemplateSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SessionTemplateControllerStubSettings settings) {
            super((StubSettings)settings);
            this.createSessionTemplateSettings = settings.createSessionTemplateSettings.toBuilder();
            this.updateSessionTemplateSettings = settings.updateSessionTemplateSettings.toBuilder();
            this.getSessionTemplateSettings = settings.getSessionTemplateSettings.toBuilder();
            this.listSessionTemplatesSettings = settings.listSessionTemplatesSettings.toBuilder();
            this.deleteSessionTemplateSettings = settings.deleteSessionTemplateSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSessionTemplateSettings, this.updateSessionTemplateSettings, this.getSessionTemplateSettings, this.listSessionTemplatesSettings, this.deleteSessionTemplateSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SessionTemplateControllerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SessionTemplateControllerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionTemplateControllerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SessionTemplateControllerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SessionTemplateControllerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SessionTemplateControllerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SessionTemplateControllerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SessionTemplateControllerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSessionTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateSessionTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getSessionTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listSessionTemplatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSessionTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSessionTemplateRequest, SessionTemplate> createSessionTemplateSettings() {
            return this.createSessionTemplateSettings;
        }

        public UnaryCallSettings.Builder<UpdateSessionTemplateRequest, SessionTemplate> updateSessionTemplateSettings() {
            return this.updateSessionTemplateSettings;
        }

        public UnaryCallSettings.Builder<GetSessionTemplateRequest, SessionTemplate> getSessionTemplateSettings() {
            return this.getSessionTemplateSettings;
        }

        public PagedCallSettings.Builder<ListSessionTemplatesRequest, ListSessionTemplatesResponse, SessionTemplateControllerClient.ListSessionTemplatesPagedResponse> listSessionTemplatesSettings() {
            return this.listSessionTemplatesSettings;
        }

        public UnaryCallSettings.Builder<DeleteSessionTemplateRequest, Empty> deleteSessionTemplateSettings() {
            return this.deleteSessionTemplateSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public SessionTemplateControllerStubSettings build() throws IOException {
            return new SessionTemplateControllerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

