/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Cluster;
import com.google.cloud.dataproc.v1.ClusterControllerClient;
import com.google.cloud.dataproc.v1.ClusterOperationMetadata;
import com.google.cloud.dataproc.v1.CreateClusterRequest;
import com.google.cloud.dataproc.v1.DeleteClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterResults;
import com.google.cloud.dataproc.v1.GetClusterRequest;
import com.google.cloud.dataproc.v1.ListClustersRequest;
import com.google.cloud.dataproc.v1.ListClustersResponse;
import com.google.cloud.dataproc.v1.StartClusterRequest;
import com.google.cloud.dataproc.v1.StopClusterRequest;
import com.google.cloud.dataproc.v1.UpdateClusterRequest;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStub;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStubSettings;
import com.google.cloud.dataproc.v1.stub.HttpJsonClusterControllerCallableFactory;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonClusterControllerStub
extends ClusterControllerStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(ClusterOperationMetadata.getDescriptor()).add(Empty.getDescriptor()).add(Cluster.getDescriptor()).add(DiagnoseClusterResults.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateClusterRequest, Operation> createClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/CreateCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "actionOnFailedPrimaryWorkers", (Object)request.getActionOnFailedPrimaryWorkers());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cluster", (Message)request.getCluster())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateClusterRequest, Operation> updateClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/UpdateCluster").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "clusterName", (Object)request.getClusterName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "gracefulDecommissionTimeout", (Object)request.getGracefulDecommissionTimeout());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("cluster", (Message)request.getCluster())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StopClusterRequest, Operation> stopClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/StopCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:stop", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "clusterName", (Object)request.getClusterName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearClusterName().clearProjectId().clearRegion().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<StartClusterRequest, Operation> startClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/StartCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:start", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "clusterName", (Object)request.getClusterName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearClusterName().clearProjectId().clearRegion().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteClusterRequest, Operation> deleteClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/DeleteCluster").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "clusterName", (Object)request.getClusterName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "clusterUuid", (Object)request.getClusterUuid());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetClusterRequest, Cluster> getClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/GetCluster").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "clusterName", (Object)request.getClusterName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Cluster.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListClustersRequest, ListClustersResponse> listClustersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/ListClusters").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListClustersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DiagnoseClusterRequest, Operation> diagnoseClusterMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataproc.v1.ClusterController/DiagnoseCluster").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:diagnose", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "clusterName", (Object)request.getClusterName());
        serializer.putPathParam(fields, "projectId", (Object)request.getProjectId());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearClusterName().clearProjectId().clearRegion().build())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable;
    private final OperationCallable<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationCallable;
    private final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable;
    private final OperationCallable<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationCallable;
    private final UnaryCallable<StopClusterRequest, Operation> stopClusterCallable;
    private final OperationCallable<StopClusterRequest, Cluster, ClusterOperationMetadata> stopClusterOperationCallable;
    private final UnaryCallable<StartClusterRequest, Operation> startClusterCallable;
    private final OperationCallable<StartClusterRequest, Cluster, ClusterOperationMetadata> startClusterOperationCallable;
    private final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable;
    private final OperationCallable<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationCallable;
    private final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable;
    private final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable;
    private final UnaryCallable<ListClustersRequest, ClusterControllerClient.ListClustersPagedResponse> listClustersPagedCallable;
    private final UnaryCallable<DiagnoseClusterRequest, Operation> diagnoseClusterCallable;
    private final OperationCallable<DiagnoseClusterRequest, DiagnoseClusterResults, ClusterOperationMetadata> diagnoseClusterOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonClusterControllerStub create(ClusterControllerStubSettings settings) throws IOException {
        return new HttpJsonClusterControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonClusterControllerStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonClusterControllerStub(ClusterControllerStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonClusterControllerStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonClusterControllerStub(ClusterControllerStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonClusterControllerStub(ClusterControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonClusterControllerCallableFactory());
    }

    protected HttpJsonClusterControllerStub(ClusterControllerStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry);
        HttpJsonCallSettings createClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createClusterMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateClusterMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings stopClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(stopClusterMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings startClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startClusterMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteClusterMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getClusterMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listClustersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listClustersMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings diagnoseClusterTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(diagnoseClusterMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.createClusterCallable = callableFactory.createUnaryCallable(createClusterTransportSettings, settings.createClusterSettings(), clientContext);
        this.createClusterOperationCallable = callableFactory.createOperationCallable(createClusterTransportSettings, settings.createClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateClusterCallable = callableFactory.createUnaryCallable(updateClusterTransportSettings, settings.updateClusterSettings(), clientContext);
        this.updateClusterOperationCallable = callableFactory.createOperationCallable(updateClusterTransportSettings, settings.updateClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.stopClusterCallable = callableFactory.createUnaryCallable(stopClusterTransportSettings, settings.stopClusterSettings(), clientContext);
        this.stopClusterOperationCallable = callableFactory.createOperationCallable(stopClusterTransportSettings, settings.stopClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.startClusterCallable = callableFactory.createUnaryCallable(startClusterTransportSettings, settings.startClusterSettings(), clientContext);
        this.startClusterOperationCallable = callableFactory.createOperationCallable(startClusterTransportSettings, settings.startClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteClusterCallable = callableFactory.createUnaryCallable(deleteClusterTransportSettings, settings.deleteClusterSettings(), clientContext);
        this.deleteClusterOperationCallable = callableFactory.createOperationCallable(deleteClusterTransportSettings, settings.deleteClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getClusterCallable = callableFactory.createUnaryCallable(getClusterTransportSettings, settings.getClusterSettings(), clientContext);
        this.listClustersCallable = callableFactory.createUnaryCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.listClustersPagedCallable = callableFactory.createPagedCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.diagnoseClusterCallable = callableFactory.createUnaryCallable(diagnoseClusterTransportSettings, settings.diagnoseClusterSettings(), clientContext);
        this.diagnoseClusterOperationCallable = callableFactory.createOperationCallable(diagnoseClusterTransportSettings, settings.diagnoseClusterOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createClusterMethodDescriptor);
        methodDescriptors.add(updateClusterMethodDescriptor);
        methodDescriptors.add(stopClusterMethodDescriptor);
        methodDescriptors.add(startClusterMethodDescriptor);
        methodDescriptors.add(deleteClusterMethodDescriptor);
        methodDescriptors.add(getClusterMethodDescriptor);
        methodDescriptors.add(listClustersMethodDescriptor);
        methodDescriptors.add(diagnoseClusterMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.createClusterCallable;
    }

    @Override
    public OperationCallable<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationCallable() {
        return this.createClusterOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.updateClusterCallable;
    }

    @Override
    public OperationCallable<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationCallable() {
        return this.updateClusterOperationCallable;
    }

    @Override
    public UnaryCallable<StopClusterRequest, Operation> stopClusterCallable() {
        return this.stopClusterCallable;
    }

    @Override
    public OperationCallable<StopClusterRequest, Cluster, ClusterOperationMetadata> stopClusterOperationCallable() {
        return this.stopClusterOperationCallable;
    }

    @Override
    public UnaryCallable<StartClusterRequest, Operation> startClusterCallable() {
        return this.startClusterCallable;
    }

    @Override
    public OperationCallable<StartClusterRequest, Cluster, ClusterOperationMetadata> startClusterOperationCallable() {
        return this.startClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.deleteClusterCallable;
    }

    @Override
    public OperationCallable<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationCallable() {
        return this.deleteClusterOperationCallable;
    }

    @Override
    public UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.getClusterCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.listClustersCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ClusterControllerClient.ListClustersPagedResponse> listClustersPagedCallable() {
        return this.listClustersPagedCallable;
    }

    @Override
    public UnaryCallable<DiagnoseClusterRequest, Operation> diagnoseClusterCallable() {
        return this.diagnoseClusterCallable;
    }

    @Override
    public OperationCallable<DiagnoseClusterRequest, DiagnoseClusterResults, ClusterOperationMetadata> diagnoseClusterOperationCallable() {
        return this.diagnoseClusterOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

