/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Cluster;
import com.google.cloud.dataproc.v1.ClusterControllerSettings;
import com.google.cloud.dataproc.v1.ClusterOperationMetadata;
import com.google.cloud.dataproc.v1.CreateClusterRequest;
import com.google.cloud.dataproc.v1.DeleteClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterResults;
import com.google.cloud.dataproc.v1.GetClusterRequest;
import com.google.cloud.dataproc.v1.ListClustersRequest;
import com.google.cloud.dataproc.v1.ListClustersResponse;
import com.google.cloud.dataproc.v1.UpdateClusterRequest;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStub;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ClusterControllerClient
implements BackgroundResource {
    private final ClusterControllerSettings settings;
    private final ClusterControllerStub stub;
    private final OperationsClient operationsClient;

    public static final ClusterControllerClient create() throws IOException {
        return ClusterControllerClient.create(ClusterControllerSettings.newBuilder().build());
    }

    public static final ClusterControllerClient create(ClusterControllerSettings settings) throws IOException {
        return new ClusterControllerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ClusterControllerClient create(ClusterControllerStub stub) {
        return new ClusterControllerClient(stub);
    }

    protected ClusterControllerClient(ClusterControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ClusterControllerStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ClusterControllerClient(ClusterControllerStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final ClusterControllerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ClusterControllerStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Cluster, ClusterOperationMetadata> createClusterAsync(String projectId, String region, Cluster cluster) {
        CreateClusterRequest request = CreateClusterRequest.newBuilder().setProjectId(projectId).setRegion(region).setCluster(cluster).build();
        return this.createClusterAsync(request);
    }

    public final OperationFuture<Cluster, ClusterOperationMetadata> createClusterAsync(CreateClusterRequest request) {
        return this.createClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationCallable() {
        return this.stub.createClusterOperationCallable();
    }

    public final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.stub.createClusterCallable();
    }

    public final OperationFuture<Cluster, ClusterOperationMetadata> updateClusterAsync(String projectId, String region, String clusterName, Cluster cluster, FieldMask updateMask) {
        UpdateClusterRequest request = UpdateClusterRequest.newBuilder().setProjectId(projectId).setRegion(region).setClusterName(clusterName).setCluster(cluster).setUpdateMask(updateMask).build();
        return this.updateClusterAsync(request);
    }

    public final OperationFuture<Cluster, ClusterOperationMetadata> updateClusterAsync(UpdateClusterRequest request) {
        return this.updateClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationCallable() {
        return this.stub.updateClusterOperationCallable();
    }

    public final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.stub.updateClusterCallable();
    }

    public final OperationFuture<Empty, ClusterOperationMetadata> deleteClusterAsync(String projectId, String region, String clusterName) {
        DeleteClusterRequest request = DeleteClusterRequest.newBuilder().setProjectId(projectId).setRegion(region).setClusterName(clusterName).build();
        return this.deleteClusterAsync(request);
    }

    public final OperationFuture<Empty, ClusterOperationMetadata> deleteClusterAsync(DeleteClusterRequest request) {
        return this.deleteClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationCallable() {
        return this.stub.deleteClusterOperationCallable();
    }

    public final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.stub.deleteClusterCallable();
    }

    public final Cluster getCluster(String projectId, String region, String clusterName) {
        GetClusterRequest request = GetClusterRequest.newBuilder().setProjectId(projectId).setRegion(region).setClusterName(clusterName).build();
        return this.getCluster(request);
    }

    public final Cluster getCluster(GetClusterRequest request) {
        return (Cluster)this.getClusterCallable().call((Object)request);
    }

    public final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.stub.getClusterCallable();
    }

    public final ListClustersPagedResponse listClusters(String projectId, String region) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setProjectId(projectId).setRegion(region).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(String projectId, String region, String filter) {
        ListClustersRequest request = ListClustersRequest.newBuilder().setProjectId(projectId).setRegion(region).setFilter(filter).build();
        return this.listClusters(request);
    }

    public final ListClustersPagedResponse listClusters(ListClustersRequest request) {
        return (ListClustersPagedResponse)((Object)this.listClustersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListClustersRequest, ListClustersPagedResponse> listClustersPagedCallable() {
        return this.stub.listClustersPagedCallable();
    }

    public final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.stub.listClustersCallable();
    }

    public final OperationFuture<DiagnoseClusterResults, ClusterOperationMetadata> diagnoseClusterAsync(String projectId, String region, String clusterName) {
        DiagnoseClusterRequest request = DiagnoseClusterRequest.newBuilder().setProjectId(projectId).setRegion(region).setClusterName(clusterName).build();
        return this.diagnoseClusterAsync(request);
    }

    public final OperationFuture<DiagnoseClusterResults, ClusterOperationMetadata> diagnoseClusterAsync(DiagnoseClusterRequest request) {
        return this.diagnoseClusterOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DiagnoseClusterRequest, DiagnoseClusterResults, ClusterOperationMetadata> diagnoseClusterOperationCallable() {
        return this.stub.diagnoseClusterOperationCallable();
    }

    public final UnaryCallable<DiagnoseClusterRequest, Operation> diagnoseClusterCallable() {
        return this.stub.diagnoseClusterCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListClustersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        private ListClustersFixedSizeCollection(List<ListClustersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListClustersFixedSizeCollection createEmptyCollection() {
            return new ListClustersFixedSizeCollection(null, 0);
        }

        protected ListClustersFixedSizeCollection createCollection(List<ListClustersPage> pages, int collectionSize) {
            return new ListClustersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListClustersPage
    extends AbstractPage<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage> {
        private ListClustersPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            super(context, (Object)response);
        }

        private static ListClustersPage createEmptyPage() {
            return new ListClustersPage(null, null);
        }

        protected ListClustersPage createPage(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ListClustersResponse response) {
            return new ListClustersPage(context, response);
        }

        public ApiFuture<ListClustersPage> createPageAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListClustersPagedResponse
    extends AbstractPagedListResponse<ListClustersRequest, ListClustersResponse, Cluster, ListClustersPage, ListClustersFixedSizeCollection> {
        public static ApiFuture<ListClustersPagedResponse> createAsync(PageContext<ListClustersRequest, ListClustersResponse, Cluster> context, ApiFuture<ListClustersResponse> futureResponse) {
            ApiFuture<ListClustersPage> futurePage = ListClustersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListClustersPage, ListClustersPagedResponse>(){

                public ListClustersPagedResponse apply(ListClustersPage input) {
                    return new ListClustersPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListClustersPagedResponse(ListClustersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListClustersFixedSizeCollection.createEmptyCollection());
        }
    }
}

