/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CancelJobRequest;
import com.google.cloud.dataproc.v1.DeleteJobRequest;
import com.google.cloud.dataproc.v1.GetJobRequest;
import com.google.cloud.dataproc.v1.Job;
import com.google.cloud.dataproc.v1.ListJobsRequest;
import com.google.cloud.dataproc.v1.ListJobsResponse;
import com.google.cloud.dataproc.v1.PagedResponseWrappers;
import com.google.cloud.dataproc.v1.SubmitJobRequest;
import com.google.cloud.dataproc.v1.UpdateJobRequest;
import com.google.cloud.dataproc.v1.stub.JobControllerStub;
import com.google.cloud.dataproc.v1.stub.JobControllerStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class GrpcJobControllerStub
extends JobControllerStub {
    private static final MethodDescriptor<SubmitJobRequest, Job> submitJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/SubmitJob").setRequestMarshaller(ProtoUtils.marshaller((Message)SubmitJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<GetJobRequest, Job> getJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/GetJob").setRequestMarshaller(ProtoUtils.marshaller((Message)GetJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<ListJobsRequest, ListJobsResponse> listJobsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/ListJobs").setRequestMarshaller(ProtoUtils.marshaller((Message)ListJobsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListJobsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateJobRequest, Job> updateJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/UpdateJob").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<CancelJobRequest, Job> cancelJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/CancelJob").setRequestMarshaller(ProtoUtils.marshaller((Message)CancelJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Job.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteJobRequest, Empty> deleteJobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.JobController/DeleteJob").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteJobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<SubmitJobRequest, Job> submitJobCallable;
    private final UnaryCallable<GetJobRequest, Job> getJobCallable;
    private final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable;
    private final UnaryCallable<ListJobsRequest, PagedResponseWrappers.ListJobsPagedResponse> listJobsPagedCallable;
    private final UnaryCallable<UpdateJobRequest, Job> updateJobCallable;
    private final UnaryCallable<CancelJobRequest, Job> cancelJobCallable;
    private final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable;

    public static final GrpcJobControllerStub create(JobControllerStubSettings settings) throws IOException {
        return new GrpcJobControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcJobControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcJobControllerStub(JobControllerStubSettings.newBuilder().build(), clientContext);
    }

    protected GrpcJobControllerStub(JobControllerStubSettings settings, ClientContext clientContext) throws IOException {
        GrpcCallSettings submitJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(submitJobMethodDescriptor).build();
        GrpcCallSettings getJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getJobMethodDescriptor).build();
        GrpcCallSettings listJobsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listJobsMethodDescriptor).build();
        GrpcCallSettings updateJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateJobMethodDescriptor).build();
        GrpcCallSettings cancelJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(cancelJobMethodDescriptor).build();
        GrpcCallSettings deleteJobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteJobMethodDescriptor).build();
        this.submitJobCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)submitJobTransportSettings, settings.submitJobSettings(), (ClientContext)clientContext);
        this.getJobCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)getJobTransportSettings, settings.getJobSettings(), (ClientContext)clientContext);
        this.listJobsCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)listJobsTransportSettings, settings.listJobsSettings(), (ClientContext)clientContext);
        this.listJobsPagedCallable = GrpcCallableFactory.createPagedCallable((GrpcCallSettings)listJobsTransportSettings, settings.listJobsSettings(), (ClientContext)clientContext);
        this.updateJobCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)updateJobTransportSettings, settings.updateJobSettings(), (ClientContext)clientContext);
        this.cancelJobCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)cancelJobTransportSettings, settings.cancelJobSettings(), (ClientContext)clientContext);
        this.deleteJobCallable = GrpcCallableFactory.createUnaryCallable((GrpcCallSettings)deleteJobTransportSettings, settings.deleteJobSettings(), (ClientContext)clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<SubmitJobRequest, Job> submitJobCallable() {
        return this.submitJobCallable;
    }

    @Override
    public UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.getJobCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, PagedResponseWrappers.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.listJobsPagedCallable;
    }

    @Override
    public UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.listJobsCallable;
    }

    @Override
    public UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.updateJobCallable;
    }

    @Override
    public UnaryCallable<CancelJobRequest, Job> cancelJobCallable() {
        return this.cancelJobCallable;
    }

    @Override
    public UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.deleteJobCallable;
    }

    public final void close() throws Exception {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

