/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.CancelJobRequest;
import com.google.cloud.dataproc.v1.DeleteJobRequest;
import com.google.cloud.dataproc.v1.GetJobRequest;
import com.google.cloud.dataproc.v1.Job;
import com.google.cloud.dataproc.v1.JobControllerSettings;
import com.google.cloud.dataproc.v1.ListJobsRequest;
import com.google.cloud.dataproc.v1.ListJobsResponse;
import com.google.cloud.dataproc.v1.PagedResponseWrappers;
import com.google.cloud.dataproc.v1.SubmitJobRequest;
import com.google.cloud.dataproc.v1.UpdateJobRequest;
import com.google.cloud.dataproc.v1.stub.JobControllerStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class JobControllerClient
implements BackgroundResource {
    private final JobControllerSettings settings;
    private final JobControllerStub stub;

    public static final JobControllerClient create() throws IOException {
        return JobControllerClient.create(JobControllerSettings.newBuilder().build());
    }

    public static final JobControllerClient create(JobControllerSettings settings) throws IOException {
        return new JobControllerClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final JobControllerClient create(JobControllerStub stub) {
        return new JobControllerClient(stub);
    }

    protected JobControllerClient(JobControllerSettings settings) throws IOException {
        this.settings = settings;
        this.stub = settings.createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected JobControllerClient(JobControllerStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final JobControllerSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public JobControllerStub getStub() {
        return this.stub;
    }

    public final Job submitJob(String projectId, String region, Job job) {
        SubmitJobRequest request = SubmitJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJob(job).build();
        return this.submitJob(request);
    }

    public final Job submitJob(SubmitJobRequest request) {
        return (Job)this.submitJobCallable().call((Object)request);
    }

    public final UnaryCallable<SubmitJobRequest, Job> submitJobCallable() {
        return this.stub.submitJobCallable();
    }

    public final Job getJob(String projectId, String region, String jobId) {
        GetJobRequest request = GetJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJobId(jobId).build();
        return this.getJob(request);
    }

    public final Job getJob(GetJobRequest request) {
        return (Job)this.getJobCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRequest, Job> getJobCallable() {
        return this.stub.getJobCallable();
    }

    public final PagedResponseWrappers.ListJobsPagedResponse listJobs(String projectId, String region) {
        ListJobsRequest request = ListJobsRequest.newBuilder().setProjectId(projectId).setRegion(region).build();
        return this.listJobs(request);
    }

    public final PagedResponseWrappers.ListJobsPagedResponse listJobs(ListJobsRequest request) {
        return (PagedResponseWrappers.ListJobsPagedResponse)((Object)this.listJobsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobsRequest, PagedResponseWrappers.ListJobsPagedResponse> listJobsPagedCallable() {
        return this.stub.listJobsPagedCallable();
    }

    public final UnaryCallable<ListJobsRequest, ListJobsResponse> listJobsCallable() {
        return this.stub.listJobsCallable();
    }

    public final Job updateJob(UpdateJobRequest request) {
        return (Job)this.updateJobCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateJobRequest, Job> updateJobCallable() {
        return this.stub.updateJobCallable();
    }

    public final Job cancelJob(String projectId, String region, String jobId) {
        CancelJobRequest request = CancelJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJobId(jobId).build();
        return this.cancelJob(request);
    }

    public final Job cancelJob(CancelJobRequest request) {
        return (Job)this.cancelJobCallable().call((Object)request);
    }

    public final UnaryCallable<CancelJobRequest, Job> cancelJobCallable() {
        return this.stub.cancelJobCallable();
    }

    public final void deleteJob(String projectId, String region, String jobId) {
        DeleteJobRequest request = DeleteJobRequest.newBuilder().setProjectId(projectId).setRegion(region).setJobId(jobId).build();
        this.deleteJob(request);
    }

    public final void deleteJob(DeleteJobRequest request) {
        this.deleteJobCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteJobRequest, Empty> deleteJobCallable() {
        return this.stub.deleteJobCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

