/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1beta;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.metastore.v1beta.Backup;
import com.google.cloud.metastore.v1beta.BackupName;
import com.google.cloud.metastore.v1beta.CreateBackupRequest;
import com.google.cloud.metastore.v1beta.CreateMetadataImportRequest;
import com.google.cloud.metastore.v1beta.CreateServiceRequest;
import com.google.cloud.metastore.v1beta.DataprocMetastoreSettings;
import com.google.cloud.metastore.v1beta.DeleteBackupRequest;
import com.google.cloud.metastore.v1beta.DeleteServiceRequest;
import com.google.cloud.metastore.v1beta.ExportMetadataRequest;
import com.google.cloud.metastore.v1beta.GetBackupRequest;
import com.google.cloud.metastore.v1beta.GetMetadataImportRequest;
import com.google.cloud.metastore.v1beta.GetServiceRequest;
import com.google.cloud.metastore.v1beta.ListBackupsRequest;
import com.google.cloud.metastore.v1beta.ListBackupsResponse;
import com.google.cloud.metastore.v1beta.ListMetadataImportsRequest;
import com.google.cloud.metastore.v1beta.ListMetadataImportsResponse;
import com.google.cloud.metastore.v1beta.ListServicesRequest;
import com.google.cloud.metastore.v1beta.ListServicesResponse;
import com.google.cloud.metastore.v1beta.LocationName;
import com.google.cloud.metastore.v1beta.MetadataExport;
import com.google.cloud.metastore.v1beta.MetadataImport;
import com.google.cloud.metastore.v1beta.MetadataImportName;
import com.google.cloud.metastore.v1beta.OperationMetadata;
import com.google.cloud.metastore.v1beta.Restore;
import com.google.cloud.metastore.v1beta.RestoreServiceRequest;
import com.google.cloud.metastore.v1beta.Service;
import com.google.cloud.metastore.v1beta.ServiceName;
import com.google.cloud.metastore.v1beta.UpdateMetadataImportRequest;
import com.google.cloud.metastore.v1beta.UpdateServiceRequest;
import com.google.cloud.metastore.v1beta.stub.DataprocMetastoreStub;
import com.google.cloud.metastore.v1beta.stub.DataprocMetastoreStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataprocMetastoreClient
implements BackgroundResource {
    private final DataprocMetastoreSettings settings;
    private final DataprocMetastoreStub stub;
    private final OperationsClient operationsClient;

    public static final DataprocMetastoreClient create() throws IOException {
        return DataprocMetastoreClient.create(DataprocMetastoreSettings.newBuilder().build());
    }

    public static final DataprocMetastoreClient create(DataprocMetastoreSettings settings) throws IOException {
        return new DataprocMetastoreClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DataprocMetastoreClient create(DataprocMetastoreStub stub) {
        return new DataprocMetastoreClient(stub);
    }

    protected DataprocMetastoreClient(DataprocMetastoreSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataprocMetastoreStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DataprocMetastoreClient(DataprocMetastoreStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final DataprocMetastoreSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DataprocMetastoreStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListServicesPagedResponse listServices(LocationName parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(String parent) {
        ListServicesRequest request = ListServicesRequest.newBuilder().setParent(parent).build();
        return this.listServices(request);
    }

    public final ListServicesPagedResponse listServices(ListServicesRequest request) {
        return (ListServicesPagedResponse)((Object)this.listServicesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListServicesRequest, ListServicesPagedResponse> listServicesPagedCallable() {
        return this.stub.listServicesPagedCallable();
    }

    public final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.stub.listServicesCallable();
    }

    public final Service getService(ServiceName name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getService(request);
    }

    public final Service getService(String name) {
        GetServiceRequest request = GetServiceRequest.newBuilder().setName(name).build();
        return this.getService(request);
    }

    public final Service getService(GetServiceRequest request) {
        return (Service)this.getServiceCallable().call((Object)request);
    }

    public final UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.stub.getServiceCallable();
    }

    public final OperationFuture<Service, OperationMetadata> createServiceAsync(LocationName parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setService(service).setServiceId(serviceId).build();
        return this.createServiceAsync(request);
    }

    public final OperationFuture<Service, OperationMetadata> createServiceAsync(String parent, Service service, String serviceId) {
        CreateServiceRequest request = CreateServiceRequest.newBuilder().setParent(parent).setService(service).setServiceId(serviceId).build();
        return this.createServiceAsync(request);
    }

    public final OperationFuture<Service, OperationMetadata> createServiceAsync(CreateServiceRequest request) {
        return this.createServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateServiceRequest, Service, OperationMetadata> createServiceOperationCallable() {
        return this.stub.createServiceOperationCallable();
    }

    public final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.stub.createServiceCallable();
    }

    public final OperationFuture<Service, OperationMetadata> updateServiceAsync(Service service, FieldMask updateMask) {
        UpdateServiceRequest request = UpdateServiceRequest.newBuilder().setService(service).setUpdateMask(updateMask).build();
        return this.updateServiceAsync(request);
    }

    public final OperationFuture<Service, OperationMetadata> updateServiceAsync(UpdateServiceRequest request) {
        return this.updateServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationCallable() {
        return this.stub.updateServiceOperationCallable();
    }

    public final UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable() {
        return this.stub.updateServiceCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(ServiceName name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteServiceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(String name) {
        DeleteServiceRequest request = DeleteServiceRequest.newBuilder().setName(name).build();
        return this.deleteServiceAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteServiceAsync(DeleteServiceRequest request) {
        return this.deleteServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable() {
        return this.stub.deleteServiceOperationCallable();
    }

    public final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.stub.deleteServiceCallable();
    }

    public final ListMetadataImportsPagedResponse listMetadataImports(ServiceName parent) {
        ListMetadataImportsRequest request = ListMetadataImportsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMetadataImports(request);
    }

    public final ListMetadataImportsPagedResponse listMetadataImports(String parent) {
        ListMetadataImportsRequest request = ListMetadataImportsRequest.newBuilder().setParent(parent).build();
        return this.listMetadataImports(request);
    }

    public final ListMetadataImportsPagedResponse listMetadataImports(ListMetadataImportsRequest request) {
        return (ListMetadataImportsPagedResponse)((Object)this.listMetadataImportsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMetadataImportsRequest, ListMetadataImportsPagedResponse> listMetadataImportsPagedCallable() {
        return this.stub.listMetadataImportsPagedCallable();
    }

    public final UnaryCallable<ListMetadataImportsRequest, ListMetadataImportsResponse> listMetadataImportsCallable() {
        return this.stub.listMetadataImportsCallable();
    }

    public final MetadataImport getMetadataImport(MetadataImportName name) {
        GetMetadataImportRequest request = GetMetadataImportRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMetadataImport(request);
    }

    public final MetadataImport getMetadataImport(String name) {
        GetMetadataImportRequest request = GetMetadataImportRequest.newBuilder().setName(name).build();
        return this.getMetadataImport(request);
    }

    public final MetadataImport getMetadataImport(GetMetadataImportRequest request) {
        return (MetadataImport)this.getMetadataImportCallable().call((Object)request);
    }

    public final UnaryCallable<GetMetadataImportRequest, MetadataImport> getMetadataImportCallable() {
        return this.stub.getMetadataImportCallable();
    }

    public final OperationFuture<MetadataImport, OperationMetadata> createMetadataImportAsync(ServiceName parent, MetadataImport metadataImport, String metadataImportId) {
        CreateMetadataImportRequest request = CreateMetadataImportRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMetadataImport(metadataImport).setMetadataImportId(metadataImportId).build();
        return this.createMetadataImportAsync(request);
    }

    public final OperationFuture<MetadataImport, OperationMetadata> createMetadataImportAsync(String parent, MetadataImport metadataImport, String metadataImportId) {
        CreateMetadataImportRequest request = CreateMetadataImportRequest.newBuilder().setParent(parent).setMetadataImport(metadataImport).setMetadataImportId(metadataImportId).build();
        return this.createMetadataImportAsync(request);
    }

    public final OperationFuture<MetadataImport, OperationMetadata> createMetadataImportAsync(CreateMetadataImportRequest request) {
        return this.createMetadataImportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationCallable() {
        return this.stub.createMetadataImportOperationCallable();
    }

    public final UnaryCallable<CreateMetadataImportRequest, Operation> createMetadataImportCallable() {
        return this.stub.createMetadataImportCallable();
    }

    public final OperationFuture<MetadataImport, OperationMetadata> updateMetadataImportAsync(MetadataImport metadataImport, FieldMask updateMask) {
        UpdateMetadataImportRequest request = UpdateMetadataImportRequest.newBuilder().setMetadataImport(metadataImport).setUpdateMask(updateMask).build();
        return this.updateMetadataImportAsync(request);
    }

    public final OperationFuture<MetadataImport, OperationMetadata> updateMetadataImportAsync(UpdateMetadataImportRequest request) {
        return this.updateMetadataImportOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationCallable() {
        return this.stub.updateMetadataImportOperationCallable();
    }

    public final UnaryCallable<UpdateMetadataImportRequest, Operation> updateMetadataImportCallable() {
        return this.stub.updateMetadataImportCallable();
    }

    public final OperationFuture<MetadataExport, OperationMetadata> exportMetadataAsync(ExportMetadataRequest request) {
        return this.exportMetadataOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationCallable() {
        return this.stub.exportMetadataOperationCallable();
    }

    public final UnaryCallable<ExportMetadataRequest, Operation> exportMetadataCallable() {
        return this.stub.exportMetadataCallable();
    }

    public final OperationFuture<Restore, OperationMetadata> restoreServiceAsync(ServiceName service, BackupName backup) {
        RestoreServiceRequest request = RestoreServiceRequest.newBuilder().setService(service == null ? null : service.toString()).setBackup(backup == null ? null : backup.toString()).build();
        return this.restoreServiceAsync(request);
    }

    public final OperationFuture<Restore, OperationMetadata> restoreServiceAsync(ServiceName service, String backup) {
        RestoreServiceRequest request = RestoreServiceRequest.newBuilder().setService(service == null ? null : service.toString()).setBackup(backup).build();
        return this.restoreServiceAsync(request);
    }

    public final OperationFuture<Restore, OperationMetadata> restoreServiceAsync(String service, BackupName backup) {
        RestoreServiceRequest request = RestoreServiceRequest.newBuilder().setService(service).setBackup(backup == null ? null : backup.toString()).build();
        return this.restoreServiceAsync(request);
    }

    public final OperationFuture<Restore, OperationMetadata> restoreServiceAsync(String service, String backup) {
        RestoreServiceRequest request = RestoreServiceRequest.newBuilder().setService(service).setBackup(backup).build();
        return this.restoreServiceAsync(request);
    }

    public final OperationFuture<Restore, OperationMetadata> restoreServiceAsync(RestoreServiceRequest request) {
        return this.restoreServiceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreServiceRequest, Restore, OperationMetadata> restoreServiceOperationCallable() {
        return this.stub.restoreServiceOperationCallable();
    }

    public final UnaryCallable<RestoreServiceRequest, Operation> restoreServiceCallable() {
        return this.stub.restoreServiceCallable();
    }

    public final ListBackupsPagedResponse listBackups(ServiceName parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(String parent) {
        ListBackupsRequest request = ListBackupsRequest.newBuilder().setParent(parent).build();
        return this.listBackups(request);
    }

    public final ListBackupsPagedResponse listBackups(ListBackupsRequest request) {
        return (ListBackupsPagedResponse)((Object)this.listBackupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsPagedResponse> listBackupsPagedCallable() {
        return this.stub.listBackupsPagedCallable();
    }

    public final UnaryCallable<ListBackupsRequest, ListBackupsResponse> listBackupsCallable() {
        return this.stub.listBackupsCallable();
    }

    public final Backup getBackup(BackupName name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(String name) {
        GetBackupRequest request = GetBackupRequest.newBuilder().setName(name).build();
        return this.getBackup(request);
    }

    public final Backup getBackup(GetBackupRequest request) {
        return (Backup)this.getBackupCallable().call((Object)request);
    }

    public final UnaryCallable<GetBackupRequest, Backup> getBackupCallable() {
        return this.stub.getBackupCallable();
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(ServiceName parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(String parent, Backup backup, String backupId) {
        CreateBackupRequest request = CreateBackupRequest.newBuilder().setParent(parent).setBackup(backup).setBackupId(backupId).build();
        return this.createBackupAsync(request);
    }

    public final OperationFuture<Backup, OperationMetadata> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBackupRequest, Backup, OperationMetadata> createBackupOperationCallable() {
        return this.stub.createBackupOperationCallable();
    }

    public final UnaryCallable<CreateBackupRequest, Operation> createBackupCallable() {
        return this.stub.createBackupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(BackupName name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(String name) {
        DeleteBackupRequest request = DeleteBackupRequest.newBuilder().setName(name).build();
        return this.deleteBackupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteBackupRequest, Empty, OperationMetadata> deleteBackupOperationCallable() {
        return this.stub.deleteBackupOperationCallable();
    }

    public final UnaryCallable<DeleteBackupRequest, Operation> deleteBackupCallable() {
        return this.stub.deleteBackupCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListBackupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        private ListBackupsFixedSizeCollection(List<ListBackupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBackupsFixedSizeCollection createEmptyCollection() {
            return new ListBackupsFixedSizeCollection(null, 0);
        }

        protected ListBackupsFixedSizeCollection createCollection(List<ListBackupsPage> pages, int collectionSize) {
            return new ListBackupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBackupsPage
    extends AbstractPage<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage> {
        private ListBackupsPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            super(context, (Object)response);
        }

        private static ListBackupsPage createEmptyPage() {
            return new ListBackupsPage(null, null);
        }

        protected ListBackupsPage createPage(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ListBackupsResponse response) {
            return new ListBackupsPage(context, response);
        }

        public ApiFuture<ListBackupsPage> createPageAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBackupsPagedResponse
    extends AbstractPagedListResponse<ListBackupsRequest, ListBackupsResponse, Backup, ListBackupsPage, ListBackupsFixedSizeCollection> {
        public static ApiFuture<ListBackupsPagedResponse> createAsync(PageContext<ListBackupsRequest, ListBackupsResponse, Backup> context, ApiFuture<ListBackupsResponse> futureResponse) {
            ApiFuture<ListBackupsPage> futurePage = ListBackupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBackupsPagedResponse((ListBackupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBackupsPagedResponse(ListBackupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBackupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMetadataImportsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport, ListMetadataImportsPage, ListMetadataImportsFixedSizeCollection> {
        private ListMetadataImportsFixedSizeCollection(List<ListMetadataImportsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMetadataImportsFixedSizeCollection createEmptyCollection() {
            return new ListMetadataImportsFixedSizeCollection(null, 0);
        }

        protected ListMetadataImportsFixedSizeCollection createCollection(List<ListMetadataImportsPage> pages, int collectionSize) {
            return new ListMetadataImportsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMetadataImportsPage
    extends AbstractPage<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport, ListMetadataImportsPage> {
        private ListMetadataImportsPage(PageContext<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport> context, ListMetadataImportsResponse response) {
            super(context, (Object)response);
        }

        private static ListMetadataImportsPage createEmptyPage() {
            return new ListMetadataImportsPage(null, null);
        }

        protected ListMetadataImportsPage createPage(PageContext<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport> context, ListMetadataImportsResponse response) {
            return new ListMetadataImportsPage(context, response);
        }

        public ApiFuture<ListMetadataImportsPage> createPageAsync(PageContext<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport> context, ApiFuture<ListMetadataImportsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMetadataImportsPagedResponse
    extends AbstractPagedListResponse<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport, ListMetadataImportsPage, ListMetadataImportsFixedSizeCollection> {
        public static ApiFuture<ListMetadataImportsPagedResponse> createAsync(PageContext<ListMetadataImportsRequest, ListMetadataImportsResponse, MetadataImport> context, ApiFuture<ListMetadataImportsResponse> futureResponse) {
            ApiFuture<ListMetadataImportsPage> futurePage = ListMetadataImportsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMetadataImportsPagedResponse((ListMetadataImportsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMetadataImportsPagedResponse(ListMetadataImportsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMetadataImportsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListServicesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        private ListServicesFixedSizeCollection(List<ListServicesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListServicesFixedSizeCollection createEmptyCollection() {
            return new ListServicesFixedSizeCollection(null, 0);
        }

        protected ListServicesFixedSizeCollection createCollection(List<ListServicesPage> pages, int collectionSize) {
            return new ListServicesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListServicesPage
    extends AbstractPage<ListServicesRequest, ListServicesResponse, Service, ListServicesPage> {
        private ListServicesPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            super(context, (Object)response);
        }

        private static ListServicesPage createEmptyPage() {
            return new ListServicesPage(null, null);
        }

        protected ListServicesPage createPage(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ListServicesResponse response) {
            return new ListServicesPage(context, response);
        }

        public ApiFuture<ListServicesPage> createPageAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListServicesPagedResponse
    extends AbstractPagedListResponse<ListServicesRequest, ListServicesResponse, Service, ListServicesPage, ListServicesFixedSizeCollection> {
        public static ApiFuture<ListServicesPagedResponse> createAsync(PageContext<ListServicesRequest, ListServicesResponse, Service> context, ApiFuture<ListServicesResponse> futureResponse) {
            ApiFuture<ListServicesPage> futurePage = ListServicesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListServicesPagedResponse((ListServicesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListServicesPagedResponse(ListServicesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListServicesFixedSizeCollection.createEmptyCollection());
        }
    }
}

