/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.metastore.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.metastore.v1.CreateMetadataImportRequest;
import com.google.cloud.metastore.v1.CreateServiceRequest;
import com.google.cloud.metastore.v1.DataprocMetastoreClient;
import com.google.cloud.metastore.v1.DeleteServiceRequest;
import com.google.cloud.metastore.v1.ExportMetadataRequest;
import com.google.cloud.metastore.v1.GetMetadataImportRequest;
import com.google.cloud.metastore.v1.GetServiceRequest;
import com.google.cloud.metastore.v1.ListMetadataImportsRequest;
import com.google.cloud.metastore.v1.ListMetadataImportsResponse;
import com.google.cloud.metastore.v1.ListServicesRequest;
import com.google.cloud.metastore.v1.ListServicesResponse;
import com.google.cloud.metastore.v1.MetadataExport;
import com.google.cloud.metastore.v1.MetadataImport;
import com.google.cloud.metastore.v1.OperationMetadata;
import com.google.cloud.metastore.v1.Service;
import com.google.cloud.metastore.v1.UpdateMetadataImportRequest;
import com.google.cloud.metastore.v1.UpdateServiceRequest;
import com.google.cloud.metastore.v1.stub.DataprocMetastoreStub;
import com.google.cloud.metastore.v1.stub.DataprocMetastoreStubSettings;
import com.google.cloud.metastore.v1.stub.GrpcDataprocMetastoreCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcDataprocMetastoreStub
extends DataprocMetastoreStub {
    private static final MethodDescriptor<ListServicesRequest, ListServicesResponse> listServicesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/ListServices").setRequestMarshaller(ProtoUtils.marshaller((Message)ListServicesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListServicesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetServiceRequest, Service> getServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/GetService").setRequestMarshaller(ProtoUtils.marshaller((Message)GetServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Service.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateServiceRequest, Operation> createServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/CreateService").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateServiceRequest, Operation> updateServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/UpdateService").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteServiceRequest, Operation> deleteServiceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/DeleteService").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteServiceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListMetadataImportsRequest, ListMetadataImportsResponse> listMetadataImportsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/ListMetadataImports").setRequestMarshaller(ProtoUtils.marshaller((Message)ListMetadataImportsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListMetadataImportsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetMetadataImportRequest, MetadataImport> getMetadataImportMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/GetMetadataImport").setRequestMarshaller(ProtoUtils.marshaller((Message)GetMetadataImportRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)MetadataImport.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateMetadataImportRequest, Operation> createMetadataImportMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/CreateMetadataImport").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateMetadataImportRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateMetadataImportRequest, Operation> updateMetadataImportMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/UpdateMetadataImport").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateMetadataImportRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ExportMetadataRequest, Operation> exportMetadataMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.metastore.v1.DataprocMetastore/ExportMetadata").setRequestMarshaller(ProtoUtils.marshaller((Message)ExportMetadataRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable;
    private final UnaryCallable<ListServicesRequest, DataprocMetastoreClient.ListServicesPagedResponse> listServicesPagedCallable;
    private final UnaryCallable<GetServiceRequest, Service> getServiceCallable;
    private final UnaryCallable<CreateServiceRequest, Operation> createServiceCallable;
    private final OperationCallable<CreateServiceRequest, Service, OperationMetadata> createServiceOperationCallable;
    private final UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable;
    private final OperationCallable<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationCallable;
    private final UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable;
    private final OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable;
    private final UnaryCallable<ListMetadataImportsRequest, ListMetadataImportsResponse> listMetadataImportsCallable;
    private final UnaryCallable<ListMetadataImportsRequest, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsPagedCallable;
    private final UnaryCallable<GetMetadataImportRequest, MetadataImport> getMetadataImportCallable;
    private final UnaryCallable<CreateMetadataImportRequest, Operation> createMetadataImportCallable;
    private final OperationCallable<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationCallable;
    private final UnaryCallable<UpdateMetadataImportRequest, Operation> updateMetadataImportCallable;
    private final OperationCallable<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationCallable;
    private final UnaryCallable<ExportMetadataRequest, Operation> exportMetadataCallable;
    private final OperationCallable<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataprocMetastoreStub create(DataprocMetastoreStubSettings settings) throws IOException {
        return new GrpcDataprocMetastoreStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataprocMetastoreStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataprocMetastoreStub(DataprocMetastoreStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataprocMetastoreStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataprocMetastoreStub(DataprocMetastoreStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataprocMetastoreStub(DataprocMetastoreStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataprocMetastoreCallableFactory());
    }

    protected GrpcDataprocMetastoreStub(DataprocMetastoreStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listServicesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listServicesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListServicesRequest>(){

            public Map<String, String> extract(ListServicesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getServiceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetServiceRequest>(){

            public Map<String, String> extract(GetServiceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createServiceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateServiceRequest>(){

            public Map<String, String> extract(CreateServiceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateServiceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateServiceRequest>(){

            public Map<String, String> extract(UpdateServiceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"service.name", (Object)String.valueOf(request.getService().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteServiceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteServiceMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteServiceRequest>(){

            public Map<String, String> extract(DeleteServiceRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listMetadataImportsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMetadataImportsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListMetadataImportsRequest>(){

            public Map<String, String> extract(ListMetadataImportsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getMetadataImportTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getMetadataImportMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetMetadataImportRequest>(){

            public Map<String, String> extract(GetMetadataImportRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings createMetadataImportTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createMetadataImportMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateMetadataImportRequest>(){

            public Map<String, String> extract(CreateMetadataImportRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateMetadataImportTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateMetadataImportMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateMetadataImportRequest>(){

            public Map<String, String> extract(UpdateMetadataImportRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"metadata_import.name", (Object)String.valueOf(request.getMetadataImport().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings exportMetadataTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(exportMetadataMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ExportMetadataRequest>(){

            public Map<String, String> extract(ExportMetadataRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"service", (Object)String.valueOf(request.getService()));
                return params.build();
            }
        }).build();
        this.listServicesCallable = callableFactory.createUnaryCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.listServicesPagedCallable = callableFactory.createPagedCallable(listServicesTransportSettings, settings.listServicesSettings(), clientContext);
        this.getServiceCallable = callableFactory.createUnaryCallable(getServiceTransportSettings, settings.getServiceSettings(), clientContext);
        this.createServiceCallable = callableFactory.createUnaryCallable(createServiceTransportSettings, settings.createServiceSettings(), clientContext);
        this.createServiceOperationCallable = callableFactory.createOperationCallable(createServiceTransportSettings, settings.createServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateServiceCallable = callableFactory.createUnaryCallable(updateServiceTransportSettings, settings.updateServiceSettings(), clientContext);
        this.updateServiceOperationCallable = callableFactory.createOperationCallable(updateServiceTransportSettings, settings.updateServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteServiceCallable = callableFactory.createUnaryCallable(deleteServiceTransportSettings, settings.deleteServiceSettings(), clientContext);
        this.deleteServiceOperationCallable = callableFactory.createOperationCallable(deleteServiceTransportSettings, settings.deleteServiceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listMetadataImportsCallable = callableFactory.createUnaryCallable(listMetadataImportsTransportSettings, settings.listMetadataImportsSettings(), clientContext);
        this.listMetadataImportsPagedCallable = callableFactory.createPagedCallable(listMetadataImportsTransportSettings, settings.listMetadataImportsSettings(), clientContext);
        this.getMetadataImportCallable = callableFactory.createUnaryCallable(getMetadataImportTransportSettings, settings.getMetadataImportSettings(), clientContext);
        this.createMetadataImportCallable = callableFactory.createUnaryCallable(createMetadataImportTransportSettings, settings.createMetadataImportSettings(), clientContext);
        this.createMetadataImportOperationCallable = callableFactory.createOperationCallable(createMetadataImportTransportSettings, settings.createMetadataImportOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateMetadataImportCallable = callableFactory.createUnaryCallable(updateMetadataImportTransportSettings, settings.updateMetadataImportSettings(), clientContext);
        this.updateMetadataImportOperationCallable = callableFactory.createOperationCallable(updateMetadataImportTransportSettings, settings.updateMetadataImportOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.exportMetadataCallable = callableFactory.createUnaryCallable(exportMetadataTransportSettings, settings.exportMetadataSettings(), clientContext);
        this.exportMetadataOperationCallable = callableFactory.createOperationCallable(exportMetadataTransportSettings, settings.exportMetadataOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListServicesRequest, ListServicesResponse> listServicesCallable() {
        return this.listServicesCallable;
    }

    @Override
    public UnaryCallable<ListServicesRequest, DataprocMetastoreClient.ListServicesPagedResponse> listServicesPagedCallable() {
        return this.listServicesPagedCallable;
    }

    @Override
    public UnaryCallable<GetServiceRequest, Service> getServiceCallable() {
        return this.getServiceCallable;
    }

    @Override
    public UnaryCallable<CreateServiceRequest, Operation> createServiceCallable() {
        return this.createServiceCallable;
    }

    @Override
    public OperationCallable<CreateServiceRequest, Service, OperationMetadata> createServiceOperationCallable() {
        return this.createServiceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateServiceRequest, Operation> updateServiceCallable() {
        return this.updateServiceCallable;
    }

    @Override
    public OperationCallable<UpdateServiceRequest, Service, OperationMetadata> updateServiceOperationCallable() {
        return this.updateServiceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteServiceRequest, Operation> deleteServiceCallable() {
        return this.deleteServiceCallable;
    }

    @Override
    public OperationCallable<DeleteServiceRequest, Empty, OperationMetadata> deleteServiceOperationCallable() {
        return this.deleteServiceOperationCallable;
    }

    @Override
    public UnaryCallable<ListMetadataImportsRequest, ListMetadataImportsResponse> listMetadataImportsCallable() {
        return this.listMetadataImportsCallable;
    }

    @Override
    public UnaryCallable<ListMetadataImportsRequest, DataprocMetastoreClient.ListMetadataImportsPagedResponse> listMetadataImportsPagedCallable() {
        return this.listMetadataImportsPagedCallable;
    }

    @Override
    public UnaryCallable<GetMetadataImportRequest, MetadataImport> getMetadataImportCallable() {
        return this.getMetadataImportCallable;
    }

    @Override
    public UnaryCallable<CreateMetadataImportRequest, Operation> createMetadataImportCallable() {
        return this.createMetadataImportCallable;
    }

    @Override
    public OperationCallable<CreateMetadataImportRequest, MetadataImport, OperationMetadata> createMetadataImportOperationCallable() {
        return this.createMetadataImportOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateMetadataImportRequest, Operation> updateMetadataImportCallable() {
        return this.updateMetadataImportCallable;
    }

    @Override
    public OperationCallable<UpdateMetadataImportRequest, MetadataImport, OperationMetadata> updateMetadataImportOperationCallable() {
        return this.updateMetadataImportOperationCallable;
    }

    @Override
    public UnaryCallable<ExportMetadataRequest, Operation> exportMetadataCallable() {
        return this.exportMetadataCallable;
    }

    @Override
    public OperationCallable<ExportMetadataRequest, MetadataExport, OperationMetadata> exportMetadataOperationCallable() {
        return this.exportMetadataOperationCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

