/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.CmekServiceClient;
import com.google.cloud.dataplex.v1.CreateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.DeleteEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.EncryptionConfig;
import com.google.cloud.dataplex.v1.GetEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsRequest;
import com.google.cloud.dataplex.v1.ListEncryptionConfigsResponse;
import com.google.cloud.dataplex.v1.OperationMetadata;
import com.google.cloud.dataplex.v1.UpdateEncryptionConfigRequest;
import com.google.cloud.dataplex.v1.stub.CmekServiceStub;
import com.google.cloud.dataplex.v1.stub.CmekServiceStubSettings;
import com.google.cloud.dataplex.v1.stub.HttpJsonCmekServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonCmekServiceStub
extends CmekServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(EncryptionConfig.getDescriptor()).add(OperationMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateEncryptionConfigRequest, Operation> createEncryptionConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.CmekService/CreateEncryptionConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/encryptionConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "encryptionConfigId", (Object)request.getEncryptionConfigId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("encryptionConfig", (Message)request.getEncryptionConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.CmekService/UpdateEncryptionConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{encryptionConfig.name=organizations/*/locations/*/encryptionConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "encryptionConfig.name", (Object)request.getEncryptionConfig().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("encryptionConfig", (Message)request.getEncryptionConfig(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.CmekService/DeleteEncryptionConfig").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/encryptionConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "etag", (Object)request.getEtag());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> listEncryptionConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.CmekService/ListEncryptionConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=organizations/*/locations/*}/encryptionConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListEncryptionConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dataplex.v1.CmekService/GetEncryptionConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=organizations/*/locations/*/encryptionConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)EncryptionConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateEncryptionConfigRequest, Operation> createEncryptionConfigCallable;
    private final OperationCallable<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationCallable;
    private final UnaryCallable<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigCallable;
    private final OperationCallable<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationCallable;
    private final UnaryCallable<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigCallable;
    private final OperationCallable<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationCallable;
    private final UnaryCallable<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> listEncryptionConfigsCallable;
    private final UnaryCallable<ListEncryptionConfigsRequest, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsPagedCallable;
    private final UnaryCallable<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, CmekServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonCmekServiceStub create(CmekServiceStubSettings settings) throws IOException {
        return new HttpJsonCmekServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonCmekServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonCmekServiceStub(CmekServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonCmekServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonCmekServiceStub(CmekServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonCmekServiceStub(CmekServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonCmekServiceCallableFactory());
    }

    protected HttpJsonCmekServiceStub(CmekServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v1/{name=organizations/*/locations/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setDelete("/v1/{name=organizations/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=organizations/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v1/{name=organizations/*/locations/*/operations/*}").build()).build()).build());
        HttpJsonCallSettings createEncryptionConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createEncryptionConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateEncryptionConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateEncryptionConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("encryption_config.name", String.valueOf(request.getEncryptionConfig().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteEncryptionConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteEncryptionConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listEncryptionConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listEncryptionConfigsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getEncryptionConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getEncryptionConfigMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createEncryptionConfigCallable = callableFactory.createUnaryCallable(createEncryptionConfigTransportSettings, settings.createEncryptionConfigSettings(), clientContext);
        this.createEncryptionConfigOperationCallable = callableFactory.createOperationCallable(createEncryptionConfigTransportSettings, settings.createEncryptionConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateEncryptionConfigCallable = callableFactory.createUnaryCallable(updateEncryptionConfigTransportSettings, settings.updateEncryptionConfigSettings(), clientContext);
        this.updateEncryptionConfigOperationCallable = callableFactory.createOperationCallable(updateEncryptionConfigTransportSettings, settings.updateEncryptionConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.deleteEncryptionConfigCallable = callableFactory.createUnaryCallable(deleteEncryptionConfigTransportSettings, settings.deleteEncryptionConfigSettings(), clientContext);
        this.deleteEncryptionConfigOperationCallable = callableFactory.createOperationCallable(deleteEncryptionConfigTransportSettings, settings.deleteEncryptionConfigOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.listEncryptionConfigsCallable = callableFactory.createUnaryCallable(listEncryptionConfigsTransportSettings, settings.listEncryptionConfigsSettings(), clientContext);
        this.listEncryptionConfigsPagedCallable = callableFactory.createPagedCallable(listEncryptionConfigsTransportSettings, settings.listEncryptionConfigsSettings(), clientContext);
        this.getEncryptionConfigCallable = callableFactory.createUnaryCallable(getEncryptionConfigTransportSettings, settings.getEncryptionConfigSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createEncryptionConfigMethodDescriptor);
        methodDescriptors.add(updateEncryptionConfigMethodDescriptor);
        methodDescriptors.add(deleteEncryptionConfigMethodDescriptor);
        methodDescriptors.add(listEncryptionConfigsMethodDescriptor);
        methodDescriptors.add(getEncryptionConfigMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateEncryptionConfigRequest, Operation> createEncryptionConfigCallable() {
        return this.createEncryptionConfigCallable;
    }

    @Override
    public OperationCallable<CreateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> createEncryptionConfigOperationCallable() {
        return this.createEncryptionConfigOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateEncryptionConfigRequest, Operation> updateEncryptionConfigCallable() {
        return this.updateEncryptionConfigCallable;
    }

    @Override
    public OperationCallable<UpdateEncryptionConfigRequest, EncryptionConfig, OperationMetadata> updateEncryptionConfigOperationCallable() {
        return this.updateEncryptionConfigOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteEncryptionConfigRequest, Operation> deleteEncryptionConfigCallable() {
        return this.deleteEncryptionConfigCallable;
    }

    @Override
    public OperationCallable<DeleteEncryptionConfigRequest, Empty, OperationMetadata> deleteEncryptionConfigOperationCallable() {
        return this.deleteEncryptionConfigOperationCallable;
    }

    @Override
    public UnaryCallable<ListEncryptionConfigsRequest, ListEncryptionConfigsResponse> listEncryptionConfigsCallable() {
        return this.listEncryptionConfigsCallable;
    }

    @Override
    public UnaryCallable<ListEncryptionConfigsRequest, CmekServiceClient.ListEncryptionConfigsPagedResponse> listEncryptionConfigsPagedCallable() {
        return this.listEncryptionConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<GetEncryptionConfigRequest, EncryptionConfig> getEncryptionConfigCallable() {
        return this.getEncryptionConfigCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, CmekServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

