/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataplex.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataplex.v1.Content;
import com.google.cloud.dataplex.v1.ContentServiceClient;
import com.google.cloud.dataplex.v1.CreateContentRequest;
import com.google.cloud.dataplex.v1.DeleteContentRequest;
import com.google.cloud.dataplex.v1.GetContentRequest;
import com.google.cloud.dataplex.v1.ListContentRequest;
import com.google.cloud.dataplex.v1.ListContentResponse;
import com.google.cloud.dataplex.v1.UpdateContentRequest;
import com.google.cloud.dataplex.v1.stub.ContentServiceStub;
import com.google.cloud.dataplex.v1.stub.GrpcContentServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ContentServiceStubSettings
extends StubSettings<ContentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateContentRequest, Content> createContentSettings;
    private final UnaryCallSettings<UpdateContentRequest, Content> updateContentSettings;
    private final UnaryCallSettings<DeleteContentRequest, Empty> deleteContentSettings;
    private final UnaryCallSettings<GetContentRequest, Content> getContentSettings;
    private final PagedCallSettings<ListContentRequest, ListContentResponse, ContentServiceClient.ListContentPagedResponse> listContentSettings;
    private static final PagedListDescriptor<ListContentRequest, ListContentResponse, Content> LIST_CONTENT_PAGE_STR_DESC = new PagedListDescriptor<ListContentRequest, ListContentResponse, Content>(){

        public String emptyToken() {
            return "";
        }

        public ListContentRequest injectToken(ListContentRequest payload, String token) {
            return ListContentRequest.newBuilder((ListContentRequest)payload).setPageToken(token).build();
        }

        public ListContentRequest injectPageSize(ListContentRequest payload, int pageSize) {
            return ListContentRequest.newBuilder((ListContentRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListContentRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListContentResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Content> extractResources(ListContentResponse payload) {
            return payload.getContentList() == null ? ImmutableList.of() : payload.getContentList();
        }
    };
    private static final PagedListResponseFactory<ListContentRequest, ListContentResponse, ContentServiceClient.ListContentPagedResponse> LIST_CONTENT_PAGE_STR_FACT = new PagedListResponseFactory<ListContentRequest, ListContentResponse, ContentServiceClient.ListContentPagedResponse>(){

        public ApiFuture<ContentServiceClient.ListContentPagedResponse> getFuturePagedResponse(UnaryCallable<ListContentRequest, ListContentResponse> callable, ListContentRequest request, ApiCallContext context, ApiFuture<ListContentResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONTENT_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ContentServiceClient.ListContentPagedResponse.createAsync((PageContext<ListContentRequest, ListContentResponse, Content>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateContentRequest, Content> createContentSettings() {
        return this.createContentSettings;
    }

    public UnaryCallSettings<UpdateContentRequest, Content> updateContentSettings() {
        return this.updateContentSettings;
    }

    public UnaryCallSettings<DeleteContentRequest, Empty> deleteContentSettings() {
        return this.deleteContentSettings;
    }

    public UnaryCallSettings<GetContentRequest, Content> getContentSettings() {
        return this.getContentSettings;
    }

    public PagedCallSettings<ListContentRequest, ListContentResponse, ContentServiceClient.ListContentPagedResponse> listContentSettings() {
        return this.listContentSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ContentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcContentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dataplex.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dataplex.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ContentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ContentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ContentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createContentSettings = settingsBuilder.createContentSettings().build();
        this.updateContentSettings = settingsBuilder.updateContentSettings().build();
        this.deleteContentSettings = settingsBuilder.deleteContentSettings().build();
        this.getContentSettings = settingsBuilder.getContentSettings().build();
        this.listContentSettings = settingsBuilder.listContentSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ContentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateContentRequest, Content> createContentSettings;
        private final UnaryCallSettings.Builder<UpdateContentRequest, Content> updateContentSettings;
        private final UnaryCallSettings.Builder<DeleteContentRequest, Empty> deleteContentSettings;
        private final UnaryCallSettings.Builder<GetContentRequest, Content> getContentSettings;
        private final PagedCallSettings.Builder<ListContentRequest, ListContentResponse, ContentServiceClient.ListContentPagedResponse> listContentSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getContentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listContentSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONTENT_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createContentSettings, this.updateContentSettings, this.deleteContentSettings, this.getContentSettings, this.listContentSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ContentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createContentSettings = settings.createContentSettings.toBuilder();
            this.updateContentSettings = settings.updateContentSettings.toBuilder();
            this.deleteContentSettings = settings.deleteContentSettings.toBuilder();
            this.getContentSettings = settings.getContentSettings.toBuilder();
            this.listContentSettings = settings.listContentSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createContentSettings, this.updateContentSettings, this.deleteContentSettings, this.getContentSettings, this.listContentSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ContentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ContentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ContentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ContentServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ContentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateContentRequest, Content> createContentSettings() {
            return this.createContentSettings;
        }

        public UnaryCallSettings.Builder<UpdateContentRequest, Content> updateContentSettings() {
            return this.updateContentSettings;
        }

        public UnaryCallSettings.Builder<DeleteContentRequest, Empty> deleteContentSettings() {
            return this.deleteContentSettings;
        }

        public UnaryCallSettings.Builder<GetContentRequest, Content> getContentSettings() {
            return this.getContentSettings;
        }

        public PagedCallSettings.Builder<ListContentRequest, ListContentResponse, ContentServiceClient.ListContentPagedResponse> listContentSettings() {
            return this.listContentSettings;
        }

        public ContentServiceStubSettings build() throws IOException {
            return new ContentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

