/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datafusion.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.datafusion.v1.CreateInstanceRequest;
import com.google.cloud.datafusion.v1.DataFusionClient;
import com.google.cloud.datafusion.v1.DeleteInstanceRequest;
import com.google.cloud.datafusion.v1.GetInstanceRequest;
import com.google.cloud.datafusion.v1.Instance;
import com.google.cloud.datafusion.v1.ListAvailableVersionsRequest;
import com.google.cloud.datafusion.v1.ListAvailableVersionsResponse;
import com.google.cloud.datafusion.v1.ListInstancesRequest;
import com.google.cloud.datafusion.v1.ListInstancesResponse;
import com.google.cloud.datafusion.v1.OperationMetadata;
import com.google.cloud.datafusion.v1.RestartInstanceRequest;
import com.google.cloud.datafusion.v1.UpdateInstanceRequest;
import com.google.cloud.datafusion.v1.stub.DataFusionStub;
import com.google.cloud.datafusion.v1.stub.DataFusionStubSettings;
import com.google.cloud.datafusion.v1.stub.GrpcDataFusionCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDataFusionStub
extends DataFusionStub {
    private static final MethodDescriptor<ListAvailableVersionsRequest, ListAvailableVersionsResponse> listAvailableVersionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1.DataFusion/ListAvailableVersions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAvailableVersionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAvailableVersionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListInstancesRequest, ListInstancesResponse> listInstancesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1.DataFusion/ListInstances").setRequestMarshaller(ProtoUtils.marshaller((Message)ListInstancesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListInstancesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetInstanceRequest, Instance> getInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1.DataFusion/GetInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)GetInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Instance.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateInstanceRequest, Operation> createInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1.DataFusion/CreateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteInstanceRequest, Operation> deleteInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1.DataFusion/DeleteInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateInstanceRequest, Operation> updateInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1.DataFusion/UpdateInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<RestartInstanceRequest, Operation> restartInstanceMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.datafusion.v1.DataFusion/RestartInstance").setRequestMarshaller(ProtoUtils.marshaller((Message)RestartInstanceRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ListAvailableVersionsRequest, ListAvailableVersionsResponse> listAvailableVersionsCallable;
    private final UnaryCallable<ListAvailableVersionsRequest, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsPagedCallable;
    private final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable;
    private final UnaryCallable<ListInstancesRequest, DataFusionClient.ListInstancesPagedResponse> listInstancesPagedCallable;
    private final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable;
    private final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable;
    private final OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable;
    private final UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable;
    private final OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable;
    private final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable;
    private final OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable;
    private final UnaryCallable<RestartInstanceRequest, Operation> restartInstanceCallable;
    private final OperationCallable<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataFusionStub create(DataFusionStubSettings settings) throws IOException {
        return new GrpcDataFusionStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataFusionStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataFusionStub(DataFusionStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataFusionStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataFusionStub(DataFusionStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataFusionStub(DataFusionStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataFusionCallableFactory());
    }

    protected GrpcDataFusionStub(DataFusionStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listAvailableVersionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAvailableVersionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listInstancesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listInstancesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("instance.name", String.valueOf(request.getInstance().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings restartInstanceTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(restartInstanceMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listAvailableVersionsCallable = callableFactory.createUnaryCallable(listAvailableVersionsTransportSettings, settings.listAvailableVersionsSettings(), clientContext);
        this.listAvailableVersionsPagedCallable = callableFactory.createPagedCallable(listAvailableVersionsTransportSettings, settings.listAvailableVersionsSettings(), clientContext);
        this.listInstancesCallable = callableFactory.createUnaryCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.listInstancesPagedCallable = callableFactory.createPagedCallable(listInstancesTransportSettings, settings.listInstancesSettings(), clientContext);
        this.getInstanceCallable = callableFactory.createUnaryCallable(getInstanceTransportSettings, settings.getInstanceSettings(), clientContext);
        this.createInstanceCallable = callableFactory.createUnaryCallable(createInstanceTransportSettings, settings.createInstanceSettings(), clientContext);
        this.createInstanceOperationCallable = callableFactory.createOperationCallable(createInstanceTransportSettings, settings.createInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteInstanceCallable = callableFactory.createUnaryCallable(deleteInstanceTransportSettings, settings.deleteInstanceSettings(), clientContext);
        this.deleteInstanceOperationCallable = callableFactory.createOperationCallable(deleteInstanceTransportSettings, settings.deleteInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateInstanceCallable = callableFactory.createUnaryCallable(updateInstanceTransportSettings, settings.updateInstanceSettings(), clientContext);
        this.updateInstanceOperationCallable = callableFactory.createOperationCallable(updateInstanceTransportSettings, settings.updateInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.restartInstanceCallable = callableFactory.createUnaryCallable(restartInstanceTransportSettings, settings.restartInstanceSettings(), clientContext);
        this.restartInstanceOperationCallable = callableFactory.createOperationCallable(restartInstanceTransportSettings, settings.restartInstanceOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListAvailableVersionsRequest, ListAvailableVersionsResponse> listAvailableVersionsCallable() {
        return this.listAvailableVersionsCallable;
    }

    @Override
    public UnaryCallable<ListAvailableVersionsRequest, DataFusionClient.ListAvailableVersionsPagedResponse> listAvailableVersionsPagedCallable() {
        return this.listAvailableVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.listInstancesCallable;
    }

    @Override
    public UnaryCallable<ListInstancesRequest, DataFusionClient.ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.listInstancesPagedCallable;
    }

    @Override
    public UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.getInstanceCallable;
    }

    @Override
    public UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.createInstanceCallable;
    }

    @Override
    public OperationCallable<CreateInstanceRequest, Instance, OperationMetadata> createInstanceOperationCallable() {
        return this.createInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteInstanceRequest, Operation> deleteInstanceCallable() {
        return this.deleteInstanceCallable;
    }

    @Override
    public OperationCallable<DeleteInstanceRequest, Empty, OperationMetadata> deleteInstanceOperationCallable() {
        return this.deleteInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.updateInstanceCallable;
    }

    @Override
    public OperationCallable<UpdateInstanceRequest, Instance, OperationMetadata> updateInstanceOperationCallable() {
        return this.updateInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<RestartInstanceRequest, Operation> restartInstanceCallable() {
        return this.restartInstanceCallable;
    }

    @Override
    public OperationCallable<RestartInstanceRequest, Instance, OperationMetadata> restartInstanceOperationCallable() {
        return this.restartInstanceOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

