/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.GetSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsResponse;
import com.google.cloud.contentwarehouse.v1.SynonymSet;
import com.google.cloud.contentwarehouse.v1.SynonymSetServiceClient;
import com.google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.GrpcSynonymSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonSynonymSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.SynonymSetServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class SynonymSetServiceStubSettings
extends StubSettings<SynonymSetServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateSynonymSetRequest, SynonymSet> createSynonymSetSettings;
    private final UnaryCallSettings<GetSynonymSetRequest, SynonymSet> getSynonymSetSettings;
    private final UnaryCallSettings<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetSettings;
    private final UnaryCallSettings<DeleteSynonymSetRequest, Empty> deleteSynonymSetSettings;
    private final PagedCallSettings<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsSettings;
    private static final PagedListDescriptor<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet> LIST_SYNONYM_SETS_PAGE_STR_DESC = new PagedListDescriptor<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet>(){

        public String emptyToken() {
            return "";
        }

        public ListSynonymSetsRequest injectToken(ListSynonymSetsRequest payload, String token) {
            return ListSynonymSetsRequest.newBuilder((ListSynonymSetsRequest)payload).setPageToken(token).build();
        }

        public ListSynonymSetsRequest injectPageSize(ListSynonymSetsRequest payload, int pageSize) {
            return ListSynonymSetsRequest.newBuilder((ListSynonymSetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSynonymSetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSynonymSetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SynonymSet> extractResources(ListSynonymSetsResponse payload) {
            return payload.getSynonymSetsList() == null ? ImmutableList.of() : payload.getSynonymSetsList();
        }
    };
    private static final PagedListResponseFactory<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSetServiceClient.ListSynonymSetsPagedResponse> LIST_SYNONYM_SETS_PAGE_STR_FACT = new PagedListResponseFactory<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSetServiceClient.ListSynonymSetsPagedResponse>(){

        public ApiFuture<SynonymSetServiceClient.ListSynonymSetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSynonymSetsRequest, ListSynonymSetsResponse> callable, ListSynonymSetsRequest request, ApiCallContext context, ApiFuture<ListSynonymSetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SYNONYM_SETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SynonymSetServiceClient.ListSynonymSetsPagedResponse.createAsync((PageContext<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSet>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateSynonymSetRequest, SynonymSet> createSynonymSetSettings() {
        return this.createSynonymSetSettings;
    }

    public UnaryCallSettings<GetSynonymSetRequest, SynonymSet> getSynonymSetSettings() {
        return this.getSynonymSetSettings;
    }

    public UnaryCallSettings<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetSettings() {
        return this.updateSynonymSetSettings;
    }

    public UnaryCallSettings<DeleteSynonymSetRequest, Empty> deleteSynonymSetSettings() {
        return this.deleteSynonymSetSettings;
    }

    public PagedCallSettings<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsSettings() {
        return this.listSynonymSetsSettings;
    }

    public SynonymSetServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSynonymSetServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSynonymSetServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return SynonymSetServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "contentwarehouse";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "contentwarehouse.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "contentwarehouse.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SynonymSetServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SynonymSetServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SynonymSetServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SynonymSetServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SynonymSetServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createSynonymSetSettings = settingsBuilder.createSynonymSetSettings().build();
        this.getSynonymSetSettings = settingsBuilder.getSynonymSetSettings().build();
        this.updateSynonymSetSettings = settingsBuilder.updateSynonymSetSettings().build();
        this.deleteSynonymSetSettings = settingsBuilder.deleteSynonymSetSettings().build();
        this.listSynonymSetsSettings = settingsBuilder.listSynonymSetsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SynonymSetServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateSynonymSetRequest, SynonymSet> createSynonymSetSettings;
        private final UnaryCallSettings.Builder<GetSynonymSetRequest, SynonymSet> getSynonymSetSettings;
        private final UnaryCallSettings.Builder<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetSettings;
        private final UnaryCallSettings.Builder<DeleteSynonymSetRequest, Empty> deleteSynonymSetSettings;
        private final PagedCallSettings.Builder<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createSynonymSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSynonymSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSynonymSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSynonymSetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSynonymSetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SYNONYM_SETS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSynonymSetSettings, this.getSynonymSetSettings, this.updateSynonymSetSettings, this.deleteSynonymSetSettings, this.listSynonymSetsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SynonymSetServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createSynonymSetSettings = settings.createSynonymSetSettings.toBuilder();
            this.getSynonymSetSettings = settings.getSynonymSetSettings.toBuilder();
            this.updateSynonymSetSettings = settings.updateSynonymSetSettings.toBuilder();
            this.deleteSynonymSetSettings = settings.deleteSynonymSetSettings.toBuilder();
            this.listSynonymSetsSettings = settings.listSynonymSetsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createSynonymSetSettings, this.getSynonymSetSettings, this.updateSynonymSetSettings, this.deleteSynonymSetSettings, this.listSynonymSetsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SynonymSetServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SynonymSetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SynonymSetServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SynonymSetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SynonymSetServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SynonymSetServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SynonymSetServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SynonymSetServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createSynonymSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSynonymSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateSynonymSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSynonymSetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSynonymSetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateSynonymSetRequest, SynonymSet> createSynonymSetSettings() {
            return this.createSynonymSetSettings;
        }

        public UnaryCallSettings.Builder<GetSynonymSetRequest, SynonymSet> getSynonymSetSettings() {
            return this.getSynonymSetSettings;
        }

        public UnaryCallSettings.Builder<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetSettings() {
            return this.updateSynonymSetSettings;
        }

        public UnaryCallSettings.Builder<DeleteSynonymSetRequest, Empty> deleteSynonymSetSettings() {
            return this.deleteSynonymSetSettings;
        }

        public PagedCallSettings.Builder<ListSynonymSetsRequest, ListSynonymSetsResponse, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsSettings() {
            return this.listSynonymSetsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return SynonymSetServiceStubSettings.getDefaultEndpoint();
        }

        public SynonymSetServiceStubSettings build() throws IOException {
            return new SynonymSetServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

