/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.GetRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListRuleSetsResponse;
import com.google.cloud.contentwarehouse.v1.RuleSet;
import com.google.cloud.contentwarehouse.v1.RuleSetServiceClient;
import com.google.cloud.contentwarehouse.v1.UpdateRuleSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.GrpcRuleSetServiceCallableFactory;
import com.google.cloud.contentwarehouse.v1.stub.RuleSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.RuleSetServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcRuleSetServiceStub
extends RuleSetServiceStub {
    private static final MethodDescriptor<CreateRuleSetRequest, RuleSet> createRuleSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/CreateRuleSet").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateRuleSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RuleSet.getDefaultInstance())).build();
    private static final MethodDescriptor<GetRuleSetRequest, RuleSet> getRuleSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/GetRuleSet").setRequestMarshaller(ProtoUtils.marshaller((Message)GetRuleSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RuleSet.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateRuleSetRequest, RuleSet> updateRuleSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/UpdateRuleSet").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateRuleSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)RuleSet.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteRuleSetRequest, Empty> deleteRuleSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/DeleteRuleSet").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteRuleSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListRuleSetsRequest, ListRuleSetsResponse> listRuleSetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.RuleSetService/ListRuleSets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListRuleSetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListRuleSetsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateRuleSetRequest, RuleSet> createRuleSetCallable;
    private final UnaryCallable<GetRuleSetRequest, RuleSet> getRuleSetCallable;
    private final UnaryCallable<UpdateRuleSetRequest, RuleSet> updateRuleSetCallable;
    private final UnaryCallable<DeleteRuleSetRequest, Empty> deleteRuleSetCallable;
    private final UnaryCallable<ListRuleSetsRequest, ListRuleSetsResponse> listRuleSetsCallable;
    private final UnaryCallable<ListRuleSetsRequest, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcRuleSetServiceStub create(RuleSetServiceStubSettings settings) throws IOException {
        return new GrpcRuleSetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcRuleSetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcRuleSetServiceStub(RuleSetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcRuleSetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcRuleSetServiceStub(RuleSetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcRuleSetServiceStub(RuleSetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcRuleSetServiceCallableFactory());
    }

    protected GrpcRuleSetServiceStub(RuleSetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createRuleSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createRuleSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getRuleSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getRuleSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateRuleSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateRuleSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteRuleSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteRuleSetMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listRuleSetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listRuleSetsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createRuleSetCallable = callableFactory.createUnaryCallable(createRuleSetTransportSettings, settings.createRuleSetSettings(), clientContext);
        this.getRuleSetCallable = callableFactory.createUnaryCallable(getRuleSetTransportSettings, settings.getRuleSetSettings(), clientContext);
        this.updateRuleSetCallable = callableFactory.createUnaryCallable(updateRuleSetTransportSettings, settings.updateRuleSetSettings(), clientContext);
        this.deleteRuleSetCallable = callableFactory.createUnaryCallable(deleteRuleSetTransportSettings, settings.deleteRuleSetSettings(), clientContext);
        this.listRuleSetsCallable = callableFactory.createUnaryCallable(listRuleSetsTransportSettings, settings.listRuleSetsSettings(), clientContext);
        this.listRuleSetsPagedCallable = callableFactory.createPagedCallable(listRuleSetsTransportSettings, settings.listRuleSetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateRuleSetRequest, RuleSet> createRuleSetCallable() {
        return this.createRuleSetCallable;
    }

    @Override
    public UnaryCallable<GetRuleSetRequest, RuleSet> getRuleSetCallable() {
        return this.getRuleSetCallable;
    }

    @Override
    public UnaryCallable<UpdateRuleSetRequest, RuleSet> updateRuleSetCallable() {
        return this.updateRuleSetCallable;
    }

    @Override
    public UnaryCallable<DeleteRuleSetRequest, Empty> deleteRuleSetCallable() {
        return this.deleteRuleSetCallable;
    }

    @Override
    public UnaryCallable<ListRuleSetsRequest, ListRuleSetsResponse> listRuleSetsCallable() {
        return this.listRuleSetsCallable;
    }

    @Override
    public UnaryCallable<ListRuleSetsRequest, RuleSetServiceClient.ListRuleSetsPagedResponse> listRuleSetsPagedCallable() {
        return this.listRuleSetsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

