/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.GetSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsResponse;
import com.google.cloud.contentwarehouse.v1.SynonymSet;
import com.google.cloud.contentwarehouse.v1.SynonymSetServiceClient;
import com.google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.HttpJsonSynonymSetServiceCallableFactory;
import com.google.cloud.contentwarehouse.v1.stub.SynonymSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.SynonymSetServiceStubSettings;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonSynonymSetServiceStub
extends SynonymSetServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateSynonymSetRequest, SynonymSet> createSynonymSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/CreateSynonymSet").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/synonymSets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("synonymSet", (Message)request.getSynonymSet(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SynonymSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSynonymSetRequest, SynonymSet> getSynonymSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/GetSynonymSet").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/synonymSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SynonymSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/UpdateSynonymSet").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/synonymSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("synonymSet", (Message)request.getSynonymSet(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SynonymSet.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSynonymSetRequest, Empty> deleteSynonymSetMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/DeleteSynonymSet").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/synonymSets/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSynonymSetsRequest, ListSynonymSetsResponse> listSynonymSetsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/ListSynonymSets").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/synonymSets", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListSynonymSetsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateSynonymSetRequest, SynonymSet> createSynonymSetCallable;
    private final UnaryCallable<GetSynonymSetRequest, SynonymSet> getSynonymSetCallable;
    private final UnaryCallable<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetCallable;
    private final UnaryCallable<DeleteSynonymSetRequest, Empty> deleteSynonymSetCallable;
    private final UnaryCallable<ListSynonymSetsRequest, ListSynonymSetsResponse> listSynonymSetsCallable;
    private final UnaryCallable<ListSynonymSetsRequest, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonSynonymSetServiceStub create(SynonymSetServiceStubSettings settings) throws IOException {
        return new HttpJsonSynonymSetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonSynonymSetServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonSynonymSetServiceStub(SynonymSetServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonSynonymSetServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonSynonymSetServiceStub(SynonymSetServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonSynonymSetServiceStub(SynonymSetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonSynonymSetServiceCallableFactory());
    }

    protected HttpJsonSynonymSetServiceStub(SynonymSetServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createSynonymSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSynonymSetMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSynonymSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSynonymSetMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSynonymSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSynonymSetMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteSynonymSetTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSynonymSetMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSynonymSetsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSynonymSetsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createSynonymSetCallable = callableFactory.createUnaryCallable(createSynonymSetTransportSettings, settings.createSynonymSetSettings(), clientContext);
        this.getSynonymSetCallable = callableFactory.createUnaryCallable(getSynonymSetTransportSettings, settings.getSynonymSetSettings(), clientContext);
        this.updateSynonymSetCallable = callableFactory.createUnaryCallable(updateSynonymSetTransportSettings, settings.updateSynonymSetSettings(), clientContext);
        this.deleteSynonymSetCallable = callableFactory.createUnaryCallable(deleteSynonymSetTransportSettings, settings.deleteSynonymSetSettings(), clientContext);
        this.listSynonymSetsCallable = callableFactory.createUnaryCallable(listSynonymSetsTransportSettings, settings.listSynonymSetsSettings(), clientContext);
        this.listSynonymSetsPagedCallable = callableFactory.createPagedCallable(listSynonymSetsTransportSettings, settings.listSynonymSetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createSynonymSetMethodDescriptor);
        methodDescriptors.add(getSynonymSetMethodDescriptor);
        methodDescriptors.add(updateSynonymSetMethodDescriptor);
        methodDescriptors.add(deleteSynonymSetMethodDescriptor);
        methodDescriptors.add(listSynonymSetsMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateSynonymSetRequest, SynonymSet> createSynonymSetCallable() {
        return this.createSynonymSetCallable;
    }

    @Override
    public UnaryCallable<GetSynonymSetRequest, SynonymSet> getSynonymSetCallable() {
        return this.getSynonymSetCallable;
    }

    @Override
    public UnaryCallable<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetCallable() {
        return this.updateSynonymSetCallable;
    }

    @Override
    public UnaryCallable<DeleteSynonymSetRequest, Empty> deleteSynonymSetCallable() {
        return this.deleteSynonymSetCallable;
    }

    @Override
    public UnaryCallable<ListSynonymSetsRequest, ListSynonymSetsResponse> listSynonymSetsCallable() {
        return this.listSynonymSetsCallable;
    }

    @Override
    public UnaryCallable<ListSynonymSetsRequest, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsPagedCallable() {
        return this.listSynonymSetsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

