/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.contentwarehouse.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.contentwarehouse.v1.CreateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.GetSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsRequest;
import com.google.cloud.contentwarehouse.v1.ListSynonymSetsResponse;
import com.google.cloud.contentwarehouse.v1.SynonymSet;
import com.google.cloud.contentwarehouse.v1.SynonymSetServiceClient;
import com.google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest;
import com.google.cloud.contentwarehouse.v1.stub.GrpcSynonymSetServiceCallableFactory;
import com.google.cloud.contentwarehouse.v1.stub.SynonymSetServiceStub;
import com.google.cloud.contentwarehouse.v1.stub.SynonymSetServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcSynonymSetServiceStub
extends SynonymSetServiceStub {
    private static final MethodDescriptor<CreateSynonymSetRequest, SynonymSet> createSynonymSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/CreateSynonymSet").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSynonymSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SynonymSet.getDefaultInstance())).build();
    private static final MethodDescriptor<GetSynonymSetRequest, SynonymSet> getSynonymSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/GetSynonymSet").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSynonymSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SynonymSet.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/UpdateSynonymSet").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSynonymSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SynonymSet.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteSynonymSetRequest, Empty> deleteSynonymSetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/DeleteSynonymSet").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSynonymSetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListSynonymSetsRequest, ListSynonymSetsResponse> listSynonymSetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.contentwarehouse.v1.SynonymSetService/ListSynonymSets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSynonymSetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSynonymSetsResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateSynonymSetRequest, SynonymSet> createSynonymSetCallable;
    private final UnaryCallable<GetSynonymSetRequest, SynonymSet> getSynonymSetCallable;
    private final UnaryCallable<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetCallable;
    private final UnaryCallable<DeleteSynonymSetRequest, Empty> deleteSynonymSetCallable;
    private final UnaryCallable<ListSynonymSetsRequest, ListSynonymSetsResponse> listSynonymSetsCallable;
    private final UnaryCallable<ListSynonymSetsRequest, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSynonymSetServiceStub create(SynonymSetServiceStubSettings settings) throws IOException {
        return new GrpcSynonymSetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSynonymSetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSynonymSetServiceStub(SynonymSetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSynonymSetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSynonymSetServiceStub(SynonymSetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSynonymSetServiceStub(SynonymSetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSynonymSetServiceCallableFactory());
    }

    protected GrpcSynonymSetServiceStub(SynonymSetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSynonymSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSynonymSetMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getSynonymSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSynonymSetMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings updateSynonymSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSynonymSetMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteSynonymSetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSynonymSetMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings listSynonymSetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSynonymSetsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        this.createSynonymSetCallable = callableFactory.createUnaryCallable(createSynonymSetTransportSettings, settings.createSynonymSetSettings(), clientContext);
        this.getSynonymSetCallable = callableFactory.createUnaryCallable(getSynonymSetTransportSettings, settings.getSynonymSetSettings(), clientContext);
        this.updateSynonymSetCallable = callableFactory.createUnaryCallable(updateSynonymSetTransportSettings, settings.updateSynonymSetSettings(), clientContext);
        this.deleteSynonymSetCallable = callableFactory.createUnaryCallable(deleteSynonymSetTransportSettings, settings.deleteSynonymSetSettings(), clientContext);
        this.listSynonymSetsCallable = callableFactory.createUnaryCallable(listSynonymSetsTransportSettings, settings.listSynonymSetsSettings(), clientContext);
        this.listSynonymSetsPagedCallable = callableFactory.createPagedCallable(listSynonymSetsTransportSettings, settings.listSynonymSetsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSynonymSetRequest, SynonymSet> createSynonymSetCallable() {
        return this.createSynonymSetCallable;
    }

    @Override
    public UnaryCallable<GetSynonymSetRequest, SynonymSet> getSynonymSetCallable() {
        return this.getSynonymSetCallable;
    }

    @Override
    public UnaryCallable<UpdateSynonymSetRequest, SynonymSet> updateSynonymSetCallable() {
        return this.updateSynonymSetCallable;
    }

    @Override
    public UnaryCallable<DeleteSynonymSetRequest, Empty> deleteSynonymSetCallable() {
        return this.deleteSynonymSetCallable;
    }

    @Override
    public UnaryCallable<ListSynonymSetsRequest, ListSynonymSetsResponse> listSynonymSetsCallable() {
        return this.listSynonymSetsCallable;
    }

    @Override
    public UnaryCallable<ListSynonymSetsRequest, SynonymSetServiceClient.ListSynonymSetsPagedResponse> listSynonymSetsPagedCallable() {
        return this.listSynonymSetsPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

