/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkeconnect.gateway.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkeconnect.gateway.v1.GatewayControlSettings;
import com.google.cloud.gkeconnect.gateway.v1.GenerateCredentialsRequest;
import com.google.cloud.gkeconnect.gateway.v1.GenerateCredentialsResponse;
import com.google.cloud.gkeconnect.gateway.v1.stub.GatewayControlStub;
import com.google.cloud.gkeconnect.gateway.v1.stub.GatewayControlStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GatewayControlClient
implements BackgroundResource {
    private final GatewayControlSettings settings;
    private final GatewayControlStub stub;

    public static final GatewayControlClient create() throws IOException {
        return GatewayControlClient.create(GatewayControlSettings.newBuilder().build());
    }

    public static final GatewayControlClient create(GatewayControlSettings settings) throws IOException {
        return new GatewayControlClient(settings);
    }

    public static final GatewayControlClient create(GatewayControlStub stub) {
        return new GatewayControlClient(stub);
    }

    protected GatewayControlClient(GatewayControlSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GatewayControlStubSettings)settings.getStubSettings()).createStub();
    }

    protected GatewayControlClient(GatewayControlStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GatewayControlSettings getSettings() {
        return this.settings;
    }

    public GatewayControlStub getStub() {
        return this.stub;
    }

    public final GenerateCredentialsResponse generateCredentials(GenerateCredentialsRequest request) {
        return (GenerateCredentialsResponse)this.generateCredentialsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateCredentialsRequest, GenerateCredentialsResponse> generateCredentialsCallable() {
        return this.stub.generateCredentialsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

