/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.configdelivery.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.configdelivery.v1beta.AbortRolloutRequest;
import com.google.cloud.configdelivery.v1beta.ConfigDeliveryClient;
import com.google.cloud.configdelivery.v1beta.CreateFleetPackageRequest;
import com.google.cloud.configdelivery.v1beta.CreateReleaseRequest;
import com.google.cloud.configdelivery.v1beta.CreateResourceBundleRequest;
import com.google.cloud.configdelivery.v1beta.CreateVariantRequest;
import com.google.cloud.configdelivery.v1beta.DeleteFleetPackageRequest;
import com.google.cloud.configdelivery.v1beta.DeleteReleaseRequest;
import com.google.cloud.configdelivery.v1beta.DeleteResourceBundleRequest;
import com.google.cloud.configdelivery.v1beta.DeleteVariantRequest;
import com.google.cloud.configdelivery.v1beta.FleetPackage;
import com.google.cloud.configdelivery.v1beta.GetFleetPackageRequest;
import com.google.cloud.configdelivery.v1beta.GetReleaseRequest;
import com.google.cloud.configdelivery.v1beta.GetResourceBundleRequest;
import com.google.cloud.configdelivery.v1beta.GetRolloutRequest;
import com.google.cloud.configdelivery.v1beta.GetVariantRequest;
import com.google.cloud.configdelivery.v1beta.ListFleetPackagesRequest;
import com.google.cloud.configdelivery.v1beta.ListFleetPackagesResponse;
import com.google.cloud.configdelivery.v1beta.ListReleasesRequest;
import com.google.cloud.configdelivery.v1beta.ListReleasesResponse;
import com.google.cloud.configdelivery.v1beta.ListResourceBundlesRequest;
import com.google.cloud.configdelivery.v1beta.ListResourceBundlesResponse;
import com.google.cloud.configdelivery.v1beta.ListRolloutsRequest;
import com.google.cloud.configdelivery.v1beta.ListRolloutsResponse;
import com.google.cloud.configdelivery.v1beta.ListVariantsRequest;
import com.google.cloud.configdelivery.v1beta.ListVariantsResponse;
import com.google.cloud.configdelivery.v1beta.OperationMetadata;
import com.google.cloud.configdelivery.v1beta.Release;
import com.google.cloud.configdelivery.v1beta.ResourceBundle;
import com.google.cloud.configdelivery.v1beta.ResumeRolloutRequest;
import com.google.cloud.configdelivery.v1beta.Rollout;
import com.google.cloud.configdelivery.v1beta.SuspendRolloutRequest;
import com.google.cloud.configdelivery.v1beta.UpdateFleetPackageRequest;
import com.google.cloud.configdelivery.v1beta.UpdateReleaseRequest;
import com.google.cloud.configdelivery.v1beta.UpdateResourceBundleRequest;
import com.google.cloud.configdelivery.v1beta.UpdateVariantRequest;
import com.google.cloud.configdelivery.v1beta.Variant;
import com.google.cloud.configdelivery.v1beta.stub.ConfigDeliveryStub;
import com.google.cloud.configdelivery.v1beta.stub.GrpcConfigDeliveryStub;
import com.google.cloud.configdelivery.v1beta.stub.HttpJsonConfigDeliveryStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class ConfigDeliveryStubSettings
extends StubSettings<ConfigDeliveryStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListResourceBundlesRequest, ListResourceBundlesResponse, ConfigDeliveryClient.ListResourceBundlesPagedResponse> listResourceBundlesSettings;
    private final UnaryCallSettings<GetResourceBundleRequest, ResourceBundle> getResourceBundleSettings;
    private final UnaryCallSettings<CreateResourceBundleRequest, Operation> createResourceBundleSettings;
    private final OperationCallSettings<CreateResourceBundleRequest, ResourceBundle, OperationMetadata> createResourceBundleOperationSettings;
    private final UnaryCallSettings<UpdateResourceBundleRequest, Operation> updateResourceBundleSettings;
    private final OperationCallSettings<UpdateResourceBundleRequest, ResourceBundle, OperationMetadata> updateResourceBundleOperationSettings;
    private final UnaryCallSettings<DeleteResourceBundleRequest, Operation> deleteResourceBundleSettings;
    private final OperationCallSettings<DeleteResourceBundleRequest, Empty, OperationMetadata> deleteResourceBundleOperationSettings;
    private final PagedCallSettings<ListFleetPackagesRequest, ListFleetPackagesResponse, ConfigDeliveryClient.ListFleetPackagesPagedResponse> listFleetPackagesSettings;
    private final UnaryCallSettings<GetFleetPackageRequest, FleetPackage> getFleetPackageSettings;
    private final UnaryCallSettings<CreateFleetPackageRequest, Operation> createFleetPackageSettings;
    private final OperationCallSettings<CreateFleetPackageRequest, FleetPackage, OperationMetadata> createFleetPackageOperationSettings;
    private final UnaryCallSettings<UpdateFleetPackageRequest, Operation> updateFleetPackageSettings;
    private final OperationCallSettings<UpdateFleetPackageRequest, FleetPackage, OperationMetadata> updateFleetPackageOperationSettings;
    private final UnaryCallSettings<DeleteFleetPackageRequest, Operation> deleteFleetPackageSettings;
    private final OperationCallSettings<DeleteFleetPackageRequest, Empty, OperationMetadata> deleteFleetPackageOperationSettings;
    private final PagedCallSettings<ListReleasesRequest, ListReleasesResponse, ConfigDeliveryClient.ListReleasesPagedResponse> listReleasesSettings;
    private final UnaryCallSettings<GetReleaseRequest, Release> getReleaseSettings;
    private final UnaryCallSettings<CreateReleaseRequest, Operation> createReleaseSettings;
    private final OperationCallSettings<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings;
    private final UnaryCallSettings<UpdateReleaseRequest, Operation> updateReleaseSettings;
    private final OperationCallSettings<UpdateReleaseRequest, Release, OperationMetadata> updateReleaseOperationSettings;
    private final UnaryCallSettings<DeleteReleaseRequest, Operation> deleteReleaseSettings;
    private final OperationCallSettings<DeleteReleaseRequest, Empty, OperationMetadata> deleteReleaseOperationSettings;
    private final PagedCallSettings<ListVariantsRequest, ListVariantsResponse, ConfigDeliveryClient.ListVariantsPagedResponse> listVariantsSettings;
    private final UnaryCallSettings<GetVariantRequest, Variant> getVariantSettings;
    private final UnaryCallSettings<CreateVariantRequest, Operation> createVariantSettings;
    private final OperationCallSettings<CreateVariantRequest, Variant, OperationMetadata> createVariantOperationSettings;
    private final UnaryCallSettings<UpdateVariantRequest, Operation> updateVariantSettings;
    private final OperationCallSettings<UpdateVariantRequest, Variant, OperationMetadata> updateVariantOperationSettings;
    private final UnaryCallSettings<DeleteVariantRequest, Operation> deleteVariantSettings;
    private final OperationCallSettings<DeleteVariantRequest, Empty, OperationMetadata> deleteVariantOperationSettings;
    private final PagedCallSettings<ListRolloutsRequest, ListRolloutsResponse, ConfigDeliveryClient.ListRolloutsPagedResponse> listRolloutsSettings;
    private final UnaryCallSettings<GetRolloutRequest, Rollout> getRolloutSettings;
    private final UnaryCallSettings<SuspendRolloutRequest, Operation> suspendRolloutSettings;
    private final OperationCallSettings<SuspendRolloutRequest, Rollout, OperationMetadata> suspendRolloutOperationSettings;
    private final UnaryCallSettings<ResumeRolloutRequest, Operation> resumeRolloutSettings;
    private final OperationCallSettings<ResumeRolloutRequest, Rollout, OperationMetadata> resumeRolloutOperationSettings;
    private final UnaryCallSettings<AbortRolloutRequest, Operation> abortRolloutSettings;
    private final OperationCallSettings<AbortRolloutRequest, Rollout, OperationMetadata> abortRolloutOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConfigDeliveryClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle> LIST_RESOURCE_BUNDLES_PAGE_STR_DESC = new PagedListDescriptor<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle>(){

        public String emptyToken() {
            return "";
        }

        public ListResourceBundlesRequest injectToken(ListResourceBundlesRequest payload, String token) {
            return ListResourceBundlesRequest.newBuilder((ListResourceBundlesRequest)payload).setPageToken(token).build();
        }

        public ListResourceBundlesRequest injectPageSize(ListResourceBundlesRequest payload, int pageSize) {
            return ListResourceBundlesRequest.newBuilder((ListResourceBundlesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListResourceBundlesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListResourceBundlesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ResourceBundle> extractResources(ListResourceBundlesResponse payload) {
            return payload.getResourceBundlesList();
        }
    };
    private static final PagedListDescriptor<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage> LIST_FLEET_PACKAGES_PAGE_STR_DESC = new PagedListDescriptor<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage>(){

        public String emptyToken() {
            return "";
        }

        public ListFleetPackagesRequest injectToken(ListFleetPackagesRequest payload, String token) {
            return ListFleetPackagesRequest.newBuilder((ListFleetPackagesRequest)payload).setPageToken(token).build();
        }

        public ListFleetPackagesRequest injectPageSize(ListFleetPackagesRequest payload, int pageSize) {
            return ListFleetPackagesRequest.newBuilder((ListFleetPackagesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFleetPackagesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFleetPackagesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<FleetPackage> extractResources(ListFleetPackagesResponse payload) {
            return payload.getFleetPackagesList();
        }
    };
    private static final PagedListDescriptor<ListReleasesRequest, ListReleasesResponse, Release> LIST_RELEASES_PAGE_STR_DESC = new PagedListDescriptor<ListReleasesRequest, ListReleasesResponse, Release>(){

        public String emptyToken() {
            return "";
        }

        public ListReleasesRequest injectToken(ListReleasesRequest payload, String token) {
            return ListReleasesRequest.newBuilder((ListReleasesRequest)payload).setPageToken(token).build();
        }

        public ListReleasesRequest injectPageSize(ListReleasesRequest payload, int pageSize) {
            return ListReleasesRequest.newBuilder((ListReleasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListReleasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListReleasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Release> extractResources(ListReleasesResponse payload) {
            return payload.getReleasesList();
        }
    };
    private static final PagedListDescriptor<ListVariantsRequest, ListVariantsResponse, Variant> LIST_VARIANTS_PAGE_STR_DESC = new PagedListDescriptor<ListVariantsRequest, ListVariantsResponse, Variant>(){

        public String emptyToken() {
            return "";
        }

        public ListVariantsRequest injectToken(ListVariantsRequest payload, String token) {
            return ListVariantsRequest.newBuilder((ListVariantsRequest)payload).setPageToken(token).build();
        }

        public ListVariantsRequest injectPageSize(ListVariantsRequest payload, int pageSize) {
            return ListVariantsRequest.newBuilder((ListVariantsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListVariantsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListVariantsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Variant> extractResources(ListVariantsResponse payload) {
            return payload.getVariantsList();
        }
    };
    private static final PagedListDescriptor<ListRolloutsRequest, ListRolloutsResponse, Rollout> LIST_ROLLOUTS_PAGE_STR_DESC = new PagedListDescriptor<ListRolloutsRequest, ListRolloutsResponse, Rollout>(){

        public String emptyToken() {
            return "";
        }

        public ListRolloutsRequest injectToken(ListRolloutsRequest payload, String token) {
            return ListRolloutsRequest.newBuilder((ListRolloutsRequest)payload).setPageToken(token).build();
        }

        public ListRolloutsRequest injectPageSize(ListRolloutsRequest payload, int pageSize) {
            return ListRolloutsRequest.newBuilder((ListRolloutsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRolloutsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRolloutsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Rollout> extractResources(ListRolloutsResponse payload) {
            return payload.getRolloutsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListResourceBundlesRequest, ListResourceBundlesResponse, ConfigDeliveryClient.ListResourceBundlesPagedResponse> LIST_RESOURCE_BUNDLES_PAGE_STR_FACT = new PagedListResponseFactory<ListResourceBundlesRequest, ListResourceBundlesResponse, ConfigDeliveryClient.ListResourceBundlesPagedResponse>(){

        public ApiFuture<ConfigDeliveryClient.ListResourceBundlesPagedResponse> getFuturePagedResponse(UnaryCallable<ListResourceBundlesRequest, ListResourceBundlesResponse> callable, ListResourceBundlesRequest request, ApiCallContext context, ApiFuture<ListResourceBundlesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RESOURCE_BUNDLES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigDeliveryClient.ListResourceBundlesPagedResponse.createAsync((PageContext<ListResourceBundlesRequest, ListResourceBundlesResponse, ResourceBundle>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFleetPackagesRequest, ListFleetPackagesResponse, ConfigDeliveryClient.ListFleetPackagesPagedResponse> LIST_FLEET_PACKAGES_PAGE_STR_FACT = new PagedListResponseFactory<ListFleetPackagesRequest, ListFleetPackagesResponse, ConfigDeliveryClient.ListFleetPackagesPagedResponse>(){

        public ApiFuture<ConfigDeliveryClient.ListFleetPackagesPagedResponse> getFuturePagedResponse(UnaryCallable<ListFleetPackagesRequest, ListFleetPackagesResponse> callable, ListFleetPackagesRequest request, ApiCallContext context, ApiFuture<ListFleetPackagesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FLEET_PACKAGES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigDeliveryClient.ListFleetPackagesPagedResponse.createAsync((PageContext<ListFleetPackagesRequest, ListFleetPackagesResponse, FleetPackage>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListReleasesRequest, ListReleasesResponse, ConfigDeliveryClient.ListReleasesPagedResponse> LIST_RELEASES_PAGE_STR_FACT = new PagedListResponseFactory<ListReleasesRequest, ListReleasesResponse, ConfigDeliveryClient.ListReleasesPagedResponse>(){

        public ApiFuture<ConfigDeliveryClient.ListReleasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListReleasesRequest, ListReleasesResponse> callable, ListReleasesRequest request, ApiCallContext context, ApiFuture<ListReleasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_RELEASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigDeliveryClient.ListReleasesPagedResponse.createAsync((PageContext<ListReleasesRequest, ListReleasesResponse, Release>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListVariantsRequest, ListVariantsResponse, ConfigDeliveryClient.ListVariantsPagedResponse> LIST_VARIANTS_PAGE_STR_FACT = new PagedListResponseFactory<ListVariantsRequest, ListVariantsResponse, ConfigDeliveryClient.ListVariantsPagedResponse>(){

        public ApiFuture<ConfigDeliveryClient.ListVariantsPagedResponse> getFuturePagedResponse(UnaryCallable<ListVariantsRequest, ListVariantsResponse> callable, ListVariantsRequest request, ApiCallContext context, ApiFuture<ListVariantsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_VARIANTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigDeliveryClient.ListVariantsPagedResponse.createAsync((PageContext<ListVariantsRequest, ListVariantsResponse, Variant>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRolloutsRequest, ListRolloutsResponse, ConfigDeliveryClient.ListRolloutsPagedResponse> LIST_ROLLOUTS_PAGE_STR_FACT = new PagedListResponseFactory<ListRolloutsRequest, ListRolloutsResponse, ConfigDeliveryClient.ListRolloutsPagedResponse>(){

        public ApiFuture<ConfigDeliveryClient.ListRolloutsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRolloutsRequest, ListRolloutsResponse> callable, ListRolloutsRequest request, ApiCallContext context, ApiFuture<ListRolloutsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROLLOUTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigDeliveryClient.ListRolloutsPagedResponse.createAsync((PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConfigDeliveryClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ConfigDeliveryClient.ListLocationsPagedResponse>(){

        public ApiFuture<ConfigDeliveryClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConfigDeliveryClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListResourceBundlesRequest, ListResourceBundlesResponse, ConfigDeliveryClient.ListResourceBundlesPagedResponse> listResourceBundlesSettings() {
        return this.listResourceBundlesSettings;
    }

    public UnaryCallSettings<GetResourceBundleRequest, ResourceBundle> getResourceBundleSettings() {
        return this.getResourceBundleSettings;
    }

    public UnaryCallSettings<CreateResourceBundleRequest, Operation> createResourceBundleSettings() {
        return this.createResourceBundleSettings;
    }

    public OperationCallSettings<CreateResourceBundleRequest, ResourceBundle, OperationMetadata> createResourceBundleOperationSettings() {
        return this.createResourceBundleOperationSettings;
    }

    public UnaryCallSettings<UpdateResourceBundleRequest, Operation> updateResourceBundleSettings() {
        return this.updateResourceBundleSettings;
    }

    public OperationCallSettings<UpdateResourceBundleRequest, ResourceBundle, OperationMetadata> updateResourceBundleOperationSettings() {
        return this.updateResourceBundleOperationSettings;
    }

    public UnaryCallSettings<DeleteResourceBundleRequest, Operation> deleteResourceBundleSettings() {
        return this.deleteResourceBundleSettings;
    }

    public OperationCallSettings<DeleteResourceBundleRequest, Empty, OperationMetadata> deleteResourceBundleOperationSettings() {
        return this.deleteResourceBundleOperationSettings;
    }

    public PagedCallSettings<ListFleetPackagesRequest, ListFleetPackagesResponse, ConfigDeliveryClient.ListFleetPackagesPagedResponse> listFleetPackagesSettings() {
        return this.listFleetPackagesSettings;
    }

    public UnaryCallSettings<GetFleetPackageRequest, FleetPackage> getFleetPackageSettings() {
        return this.getFleetPackageSettings;
    }

    public UnaryCallSettings<CreateFleetPackageRequest, Operation> createFleetPackageSettings() {
        return this.createFleetPackageSettings;
    }

    public OperationCallSettings<CreateFleetPackageRequest, FleetPackage, OperationMetadata> createFleetPackageOperationSettings() {
        return this.createFleetPackageOperationSettings;
    }

    public UnaryCallSettings<UpdateFleetPackageRequest, Operation> updateFleetPackageSettings() {
        return this.updateFleetPackageSettings;
    }

    public OperationCallSettings<UpdateFleetPackageRequest, FleetPackage, OperationMetadata> updateFleetPackageOperationSettings() {
        return this.updateFleetPackageOperationSettings;
    }

    public UnaryCallSettings<DeleteFleetPackageRequest, Operation> deleteFleetPackageSettings() {
        return this.deleteFleetPackageSettings;
    }

    public OperationCallSettings<DeleteFleetPackageRequest, Empty, OperationMetadata> deleteFleetPackageOperationSettings() {
        return this.deleteFleetPackageOperationSettings;
    }

    public PagedCallSettings<ListReleasesRequest, ListReleasesResponse, ConfigDeliveryClient.ListReleasesPagedResponse> listReleasesSettings() {
        return this.listReleasesSettings;
    }

    public UnaryCallSettings<GetReleaseRequest, Release> getReleaseSettings() {
        return this.getReleaseSettings;
    }

    public UnaryCallSettings<CreateReleaseRequest, Operation> createReleaseSettings() {
        return this.createReleaseSettings;
    }

    public OperationCallSettings<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings() {
        return this.createReleaseOperationSettings;
    }

    public UnaryCallSettings<UpdateReleaseRequest, Operation> updateReleaseSettings() {
        return this.updateReleaseSettings;
    }

    public OperationCallSettings<UpdateReleaseRequest, Release, OperationMetadata> updateReleaseOperationSettings() {
        return this.updateReleaseOperationSettings;
    }

    public UnaryCallSettings<DeleteReleaseRequest, Operation> deleteReleaseSettings() {
        return this.deleteReleaseSettings;
    }

    public OperationCallSettings<DeleteReleaseRequest, Empty, OperationMetadata> deleteReleaseOperationSettings() {
        return this.deleteReleaseOperationSettings;
    }

    public PagedCallSettings<ListVariantsRequest, ListVariantsResponse, ConfigDeliveryClient.ListVariantsPagedResponse> listVariantsSettings() {
        return this.listVariantsSettings;
    }

    public UnaryCallSettings<GetVariantRequest, Variant> getVariantSettings() {
        return this.getVariantSettings;
    }

    public UnaryCallSettings<CreateVariantRequest, Operation> createVariantSettings() {
        return this.createVariantSettings;
    }

    public OperationCallSettings<CreateVariantRequest, Variant, OperationMetadata> createVariantOperationSettings() {
        return this.createVariantOperationSettings;
    }

    public UnaryCallSettings<UpdateVariantRequest, Operation> updateVariantSettings() {
        return this.updateVariantSettings;
    }

    public OperationCallSettings<UpdateVariantRequest, Variant, OperationMetadata> updateVariantOperationSettings() {
        return this.updateVariantOperationSettings;
    }

    public UnaryCallSettings<DeleteVariantRequest, Operation> deleteVariantSettings() {
        return this.deleteVariantSettings;
    }

    public OperationCallSettings<DeleteVariantRequest, Empty, OperationMetadata> deleteVariantOperationSettings() {
        return this.deleteVariantOperationSettings;
    }

    public PagedCallSettings<ListRolloutsRequest, ListRolloutsResponse, ConfigDeliveryClient.ListRolloutsPagedResponse> listRolloutsSettings() {
        return this.listRolloutsSettings;
    }

    public UnaryCallSettings<GetRolloutRequest, Rollout> getRolloutSettings() {
        return this.getRolloutSettings;
    }

    public UnaryCallSettings<SuspendRolloutRequest, Operation> suspendRolloutSettings() {
        return this.suspendRolloutSettings;
    }

    public OperationCallSettings<SuspendRolloutRequest, Rollout, OperationMetadata> suspendRolloutOperationSettings() {
        return this.suspendRolloutOperationSettings;
    }

    public UnaryCallSettings<ResumeRolloutRequest, Operation> resumeRolloutSettings() {
        return this.resumeRolloutSettings;
    }

    public OperationCallSettings<ResumeRolloutRequest, Rollout, OperationMetadata> resumeRolloutOperationSettings() {
        return this.resumeRolloutOperationSettings;
    }

    public UnaryCallSettings<AbortRolloutRequest, Operation> abortRolloutSettings() {
        return this.abortRolloutSettings;
    }

    public OperationCallSettings<AbortRolloutRequest, Rollout, OperationMetadata> abortRolloutOperationSettings() {
        return this.abortRolloutOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ConfigDeliveryClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ConfigDeliveryStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConfigDeliveryStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConfigDeliveryStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "configdelivery";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "configdelivery.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "configdelivery.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConfigDeliveryStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigDeliveryStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConfigDeliveryStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConfigDeliveryStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConfigDeliveryStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listResourceBundlesSettings = settingsBuilder.listResourceBundlesSettings().build();
        this.getResourceBundleSettings = settingsBuilder.getResourceBundleSettings().build();
        this.createResourceBundleSettings = settingsBuilder.createResourceBundleSettings().build();
        this.createResourceBundleOperationSettings = settingsBuilder.createResourceBundleOperationSettings().build();
        this.updateResourceBundleSettings = settingsBuilder.updateResourceBundleSettings().build();
        this.updateResourceBundleOperationSettings = settingsBuilder.updateResourceBundleOperationSettings().build();
        this.deleteResourceBundleSettings = settingsBuilder.deleteResourceBundleSettings().build();
        this.deleteResourceBundleOperationSettings = settingsBuilder.deleteResourceBundleOperationSettings().build();
        this.listFleetPackagesSettings = settingsBuilder.listFleetPackagesSettings().build();
        this.getFleetPackageSettings = settingsBuilder.getFleetPackageSettings().build();
        this.createFleetPackageSettings = settingsBuilder.createFleetPackageSettings().build();
        this.createFleetPackageOperationSettings = settingsBuilder.createFleetPackageOperationSettings().build();
        this.updateFleetPackageSettings = settingsBuilder.updateFleetPackageSettings().build();
        this.updateFleetPackageOperationSettings = settingsBuilder.updateFleetPackageOperationSettings().build();
        this.deleteFleetPackageSettings = settingsBuilder.deleteFleetPackageSettings().build();
        this.deleteFleetPackageOperationSettings = settingsBuilder.deleteFleetPackageOperationSettings().build();
        this.listReleasesSettings = settingsBuilder.listReleasesSettings().build();
        this.getReleaseSettings = settingsBuilder.getReleaseSettings().build();
        this.createReleaseSettings = settingsBuilder.createReleaseSettings().build();
        this.createReleaseOperationSettings = settingsBuilder.createReleaseOperationSettings().build();
        this.updateReleaseSettings = settingsBuilder.updateReleaseSettings().build();
        this.updateReleaseOperationSettings = settingsBuilder.updateReleaseOperationSettings().build();
        this.deleteReleaseSettings = settingsBuilder.deleteReleaseSettings().build();
        this.deleteReleaseOperationSettings = settingsBuilder.deleteReleaseOperationSettings().build();
        this.listVariantsSettings = settingsBuilder.listVariantsSettings().build();
        this.getVariantSettings = settingsBuilder.getVariantSettings().build();
        this.createVariantSettings = settingsBuilder.createVariantSettings().build();
        this.createVariantOperationSettings = settingsBuilder.createVariantOperationSettings().build();
        this.updateVariantSettings = settingsBuilder.updateVariantSettings().build();
        this.updateVariantOperationSettings = settingsBuilder.updateVariantOperationSettings().build();
        this.deleteVariantSettings = settingsBuilder.deleteVariantSettings().build();
        this.deleteVariantOperationSettings = settingsBuilder.deleteVariantOperationSettings().build();
        this.listRolloutsSettings = settingsBuilder.listRolloutsSettings().build();
        this.getRolloutSettings = settingsBuilder.getRolloutSettings().build();
        this.suspendRolloutSettings = settingsBuilder.suspendRolloutSettings().build();
        this.suspendRolloutOperationSettings = settingsBuilder.suspendRolloutOperationSettings().build();
        this.resumeRolloutSettings = settingsBuilder.resumeRolloutSettings().build();
        this.resumeRolloutOperationSettings = settingsBuilder.resumeRolloutOperationSettings().build();
        this.abortRolloutSettings = settingsBuilder.abortRolloutSettings().build();
        this.abortRolloutOperationSettings = settingsBuilder.abortRolloutOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConfigDeliveryStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListResourceBundlesRequest, ListResourceBundlesResponse, ConfigDeliveryClient.ListResourceBundlesPagedResponse> listResourceBundlesSettings;
        private final UnaryCallSettings.Builder<GetResourceBundleRequest, ResourceBundle> getResourceBundleSettings;
        private final UnaryCallSettings.Builder<CreateResourceBundleRequest, Operation> createResourceBundleSettings;
        private final OperationCallSettings.Builder<CreateResourceBundleRequest, ResourceBundle, OperationMetadata> createResourceBundleOperationSettings;
        private final UnaryCallSettings.Builder<UpdateResourceBundleRequest, Operation> updateResourceBundleSettings;
        private final OperationCallSettings.Builder<UpdateResourceBundleRequest, ResourceBundle, OperationMetadata> updateResourceBundleOperationSettings;
        private final UnaryCallSettings.Builder<DeleteResourceBundleRequest, Operation> deleteResourceBundleSettings;
        private final OperationCallSettings.Builder<DeleteResourceBundleRequest, Empty, OperationMetadata> deleteResourceBundleOperationSettings;
        private final PagedCallSettings.Builder<ListFleetPackagesRequest, ListFleetPackagesResponse, ConfigDeliveryClient.ListFleetPackagesPagedResponse> listFleetPackagesSettings;
        private final UnaryCallSettings.Builder<GetFleetPackageRequest, FleetPackage> getFleetPackageSettings;
        private final UnaryCallSettings.Builder<CreateFleetPackageRequest, Operation> createFleetPackageSettings;
        private final OperationCallSettings.Builder<CreateFleetPackageRequest, FleetPackage, OperationMetadata> createFleetPackageOperationSettings;
        private final UnaryCallSettings.Builder<UpdateFleetPackageRequest, Operation> updateFleetPackageSettings;
        private final OperationCallSettings.Builder<UpdateFleetPackageRequest, FleetPackage, OperationMetadata> updateFleetPackageOperationSettings;
        private final UnaryCallSettings.Builder<DeleteFleetPackageRequest, Operation> deleteFleetPackageSettings;
        private final OperationCallSettings.Builder<DeleteFleetPackageRequest, Empty, OperationMetadata> deleteFleetPackageOperationSettings;
        private final PagedCallSettings.Builder<ListReleasesRequest, ListReleasesResponse, ConfigDeliveryClient.ListReleasesPagedResponse> listReleasesSettings;
        private final UnaryCallSettings.Builder<GetReleaseRequest, Release> getReleaseSettings;
        private final UnaryCallSettings.Builder<CreateReleaseRequest, Operation> createReleaseSettings;
        private final OperationCallSettings.Builder<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings;
        private final UnaryCallSettings.Builder<UpdateReleaseRequest, Operation> updateReleaseSettings;
        private final OperationCallSettings.Builder<UpdateReleaseRequest, Release, OperationMetadata> updateReleaseOperationSettings;
        private final UnaryCallSettings.Builder<DeleteReleaseRequest, Operation> deleteReleaseSettings;
        private final OperationCallSettings.Builder<DeleteReleaseRequest, Empty, OperationMetadata> deleteReleaseOperationSettings;
        private final PagedCallSettings.Builder<ListVariantsRequest, ListVariantsResponse, ConfigDeliveryClient.ListVariantsPagedResponse> listVariantsSettings;
        private final UnaryCallSettings.Builder<GetVariantRequest, Variant> getVariantSettings;
        private final UnaryCallSettings.Builder<CreateVariantRequest, Operation> createVariantSettings;
        private final OperationCallSettings.Builder<CreateVariantRequest, Variant, OperationMetadata> createVariantOperationSettings;
        private final UnaryCallSettings.Builder<UpdateVariantRequest, Operation> updateVariantSettings;
        private final OperationCallSettings.Builder<UpdateVariantRequest, Variant, OperationMetadata> updateVariantOperationSettings;
        private final UnaryCallSettings.Builder<DeleteVariantRequest, Operation> deleteVariantSettings;
        private final OperationCallSettings.Builder<DeleteVariantRequest, Empty, OperationMetadata> deleteVariantOperationSettings;
        private final PagedCallSettings.Builder<ListRolloutsRequest, ListRolloutsResponse, ConfigDeliveryClient.ListRolloutsPagedResponse> listRolloutsSettings;
        private final UnaryCallSettings.Builder<GetRolloutRequest, Rollout> getRolloutSettings;
        private final UnaryCallSettings.Builder<SuspendRolloutRequest, Operation> suspendRolloutSettings;
        private final OperationCallSettings.Builder<SuspendRolloutRequest, Rollout, OperationMetadata> suspendRolloutOperationSettings;
        private final UnaryCallSettings.Builder<ResumeRolloutRequest, Operation> resumeRolloutSettings;
        private final OperationCallSettings.Builder<ResumeRolloutRequest, Rollout, OperationMetadata> resumeRolloutOperationSettings;
        private final UnaryCallSettings.Builder<AbortRolloutRequest, Operation> abortRolloutSettings;
        private final OperationCallSettings.Builder<AbortRolloutRequest, Rollout, OperationMetadata> abortRolloutOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConfigDeliveryClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listResourceBundlesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RESOURCE_BUNDLES_PAGE_STR_FACT);
            this.getResourceBundleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createResourceBundleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createResourceBundleOperationSettings = OperationCallSettings.newBuilder();
            this.updateResourceBundleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateResourceBundleOperationSettings = OperationCallSettings.newBuilder();
            this.deleteResourceBundleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteResourceBundleOperationSettings = OperationCallSettings.newBuilder();
            this.listFleetPackagesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FLEET_PACKAGES_PAGE_STR_FACT);
            this.getFleetPackageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFleetPackageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createFleetPackageOperationSettings = OperationCallSettings.newBuilder();
            this.updateFleetPackageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateFleetPackageOperationSettings = OperationCallSettings.newBuilder();
            this.deleteFleetPackageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteFleetPackageOperationSettings = OperationCallSettings.newBuilder();
            this.listReleasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_RELEASES_PAGE_STR_FACT);
            this.getReleaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createReleaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createReleaseOperationSettings = OperationCallSettings.newBuilder();
            this.updateReleaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateReleaseOperationSettings = OperationCallSettings.newBuilder();
            this.deleteReleaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteReleaseOperationSettings = OperationCallSettings.newBuilder();
            this.listVariantsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_VARIANTS_PAGE_STR_FACT);
            this.getVariantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVariantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createVariantOperationSettings = OperationCallSettings.newBuilder();
            this.updateVariantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateVariantOperationSettings = OperationCallSettings.newBuilder();
            this.deleteVariantSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteVariantOperationSettings = OperationCallSettings.newBuilder();
            this.listRolloutsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROLLOUTS_PAGE_STR_FACT);
            this.getRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suspendRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suspendRolloutOperationSettings = OperationCallSettings.newBuilder();
            this.resumeRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resumeRolloutOperationSettings = OperationCallSettings.newBuilder();
            this.abortRolloutSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.abortRolloutOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listResourceBundlesSettings, this.getResourceBundleSettings, this.createResourceBundleSettings, this.updateResourceBundleSettings, this.deleteResourceBundleSettings, this.listFleetPackagesSettings, this.getFleetPackageSettings, this.createFleetPackageSettings, this.updateFleetPackageSettings, this.deleteFleetPackageSettings, this.listReleasesSettings, this.getReleaseSettings, (Object[])new UnaryCallSettings.Builder[]{this.createReleaseSettings, this.updateReleaseSettings, this.deleteReleaseSettings, this.listVariantsSettings, this.getVariantSettings, this.createVariantSettings, this.updateVariantSettings, this.deleteVariantSettings, this.listRolloutsSettings, this.getRolloutSettings, this.suspendRolloutSettings, this.resumeRolloutSettings, this.abortRolloutSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ConfigDeliveryStubSettings settings) {
            super((StubSettings)settings);
            this.listResourceBundlesSettings = settings.listResourceBundlesSettings.toBuilder();
            this.getResourceBundleSettings = settings.getResourceBundleSettings.toBuilder();
            this.createResourceBundleSettings = settings.createResourceBundleSettings.toBuilder();
            this.createResourceBundleOperationSettings = settings.createResourceBundleOperationSettings.toBuilder();
            this.updateResourceBundleSettings = settings.updateResourceBundleSettings.toBuilder();
            this.updateResourceBundleOperationSettings = settings.updateResourceBundleOperationSettings.toBuilder();
            this.deleteResourceBundleSettings = settings.deleteResourceBundleSettings.toBuilder();
            this.deleteResourceBundleOperationSettings = settings.deleteResourceBundleOperationSettings.toBuilder();
            this.listFleetPackagesSettings = settings.listFleetPackagesSettings.toBuilder();
            this.getFleetPackageSettings = settings.getFleetPackageSettings.toBuilder();
            this.createFleetPackageSettings = settings.createFleetPackageSettings.toBuilder();
            this.createFleetPackageOperationSettings = settings.createFleetPackageOperationSettings.toBuilder();
            this.updateFleetPackageSettings = settings.updateFleetPackageSettings.toBuilder();
            this.updateFleetPackageOperationSettings = settings.updateFleetPackageOperationSettings.toBuilder();
            this.deleteFleetPackageSettings = settings.deleteFleetPackageSettings.toBuilder();
            this.deleteFleetPackageOperationSettings = settings.deleteFleetPackageOperationSettings.toBuilder();
            this.listReleasesSettings = settings.listReleasesSettings.toBuilder();
            this.getReleaseSettings = settings.getReleaseSettings.toBuilder();
            this.createReleaseSettings = settings.createReleaseSettings.toBuilder();
            this.createReleaseOperationSettings = settings.createReleaseOperationSettings.toBuilder();
            this.updateReleaseSettings = settings.updateReleaseSettings.toBuilder();
            this.updateReleaseOperationSettings = settings.updateReleaseOperationSettings.toBuilder();
            this.deleteReleaseSettings = settings.deleteReleaseSettings.toBuilder();
            this.deleteReleaseOperationSettings = settings.deleteReleaseOperationSettings.toBuilder();
            this.listVariantsSettings = settings.listVariantsSettings.toBuilder();
            this.getVariantSettings = settings.getVariantSettings.toBuilder();
            this.createVariantSettings = settings.createVariantSettings.toBuilder();
            this.createVariantOperationSettings = settings.createVariantOperationSettings.toBuilder();
            this.updateVariantSettings = settings.updateVariantSettings.toBuilder();
            this.updateVariantOperationSettings = settings.updateVariantOperationSettings.toBuilder();
            this.deleteVariantSettings = settings.deleteVariantSettings.toBuilder();
            this.deleteVariantOperationSettings = settings.deleteVariantOperationSettings.toBuilder();
            this.listRolloutsSettings = settings.listRolloutsSettings.toBuilder();
            this.getRolloutSettings = settings.getRolloutSettings.toBuilder();
            this.suspendRolloutSettings = settings.suspendRolloutSettings.toBuilder();
            this.suspendRolloutOperationSettings = settings.suspendRolloutOperationSettings.toBuilder();
            this.resumeRolloutSettings = settings.resumeRolloutSettings.toBuilder();
            this.resumeRolloutOperationSettings = settings.resumeRolloutOperationSettings.toBuilder();
            this.abortRolloutSettings = settings.abortRolloutSettings.toBuilder();
            this.abortRolloutOperationSettings = settings.abortRolloutOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listResourceBundlesSettings, this.getResourceBundleSettings, this.createResourceBundleSettings, this.updateResourceBundleSettings, this.deleteResourceBundleSettings, this.listFleetPackagesSettings, this.getFleetPackageSettings, this.createFleetPackageSettings, this.updateFleetPackageSettings, this.deleteFleetPackageSettings, this.listReleasesSettings, this.getReleaseSettings, (Object[])new UnaryCallSettings.Builder[]{this.createReleaseSettings, this.updateReleaseSettings, this.deleteReleaseSettings, this.listVariantsSettings, this.getVariantSettings, this.createVariantSettings, this.updateVariantSettings, this.deleteVariantSettings, this.listRolloutsSettings, this.getRolloutSettings, this.suspendRolloutSettings, this.resumeRolloutSettings, this.abortRolloutSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConfigDeliveryStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConfigDeliveryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigDeliveryStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConfigDeliveryStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConfigDeliveryStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConfigDeliveryStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConfigDeliveryStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConfigDeliveryStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listResourceBundlesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getResourceBundleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createResourceBundleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateResourceBundleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteResourceBundleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listFleetPackagesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getFleetPackageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createFleetPackageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateFleetPackageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteFleetPackageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listReleasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getReleaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createReleaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateReleaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteReleaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listVariantsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getVariantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createVariantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateVariantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteVariantSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listRolloutsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.suspendRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resumeRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.abortRolloutSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createResourceBundleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ResourceBundle.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateResourceBundleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ResourceBundle.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteResourceBundleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createFleetPackageOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(FleetPackage.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateFleetPackageOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(FleetPackage.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteFleetPackageOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createReleaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Release.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateReleaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Release.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteReleaseOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.createVariantOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Variant.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateVariantOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Variant.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteVariantOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.suspendRolloutOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Rollout.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.resumeRolloutOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Rollout.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.abortRolloutOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Rollout.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListResourceBundlesRequest, ListResourceBundlesResponse, ConfigDeliveryClient.ListResourceBundlesPagedResponse> listResourceBundlesSettings() {
            return this.listResourceBundlesSettings;
        }

        public UnaryCallSettings.Builder<GetResourceBundleRequest, ResourceBundle> getResourceBundleSettings() {
            return this.getResourceBundleSettings;
        }

        public UnaryCallSettings.Builder<CreateResourceBundleRequest, Operation> createResourceBundleSettings() {
            return this.createResourceBundleSettings;
        }

        public OperationCallSettings.Builder<CreateResourceBundleRequest, ResourceBundle, OperationMetadata> createResourceBundleOperationSettings() {
            return this.createResourceBundleOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateResourceBundleRequest, Operation> updateResourceBundleSettings() {
            return this.updateResourceBundleSettings;
        }

        public OperationCallSettings.Builder<UpdateResourceBundleRequest, ResourceBundle, OperationMetadata> updateResourceBundleOperationSettings() {
            return this.updateResourceBundleOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteResourceBundleRequest, Operation> deleteResourceBundleSettings() {
            return this.deleteResourceBundleSettings;
        }

        public OperationCallSettings.Builder<DeleteResourceBundleRequest, Empty, OperationMetadata> deleteResourceBundleOperationSettings() {
            return this.deleteResourceBundleOperationSettings;
        }

        public PagedCallSettings.Builder<ListFleetPackagesRequest, ListFleetPackagesResponse, ConfigDeliveryClient.ListFleetPackagesPagedResponse> listFleetPackagesSettings() {
            return this.listFleetPackagesSettings;
        }

        public UnaryCallSettings.Builder<GetFleetPackageRequest, FleetPackage> getFleetPackageSettings() {
            return this.getFleetPackageSettings;
        }

        public UnaryCallSettings.Builder<CreateFleetPackageRequest, Operation> createFleetPackageSettings() {
            return this.createFleetPackageSettings;
        }

        public OperationCallSettings.Builder<CreateFleetPackageRequest, FleetPackage, OperationMetadata> createFleetPackageOperationSettings() {
            return this.createFleetPackageOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateFleetPackageRequest, Operation> updateFleetPackageSettings() {
            return this.updateFleetPackageSettings;
        }

        public OperationCallSettings.Builder<UpdateFleetPackageRequest, FleetPackage, OperationMetadata> updateFleetPackageOperationSettings() {
            return this.updateFleetPackageOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteFleetPackageRequest, Operation> deleteFleetPackageSettings() {
            return this.deleteFleetPackageSettings;
        }

        public OperationCallSettings.Builder<DeleteFleetPackageRequest, Empty, OperationMetadata> deleteFleetPackageOperationSettings() {
            return this.deleteFleetPackageOperationSettings;
        }

        public PagedCallSettings.Builder<ListReleasesRequest, ListReleasesResponse, ConfigDeliveryClient.ListReleasesPagedResponse> listReleasesSettings() {
            return this.listReleasesSettings;
        }

        public UnaryCallSettings.Builder<GetReleaseRequest, Release> getReleaseSettings() {
            return this.getReleaseSettings;
        }

        public UnaryCallSettings.Builder<CreateReleaseRequest, Operation> createReleaseSettings() {
            return this.createReleaseSettings;
        }

        public OperationCallSettings.Builder<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationSettings() {
            return this.createReleaseOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateReleaseRequest, Operation> updateReleaseSettings() {
            return this.updateReleaseSettings;
        }

        public OperationCallSettings.Builder<UpdateReleaseRequest, Release, OperationMetadata> updateReleaseOperationSettings() {
            return this.updateReleaseOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteReleaseRequest, Operation> deleteReleaseSettings() {
            return this.deleteReleaseSettings;
        }

        public OperationCallSettings.Builder<DeleteReleaseRequest, Empty, OperationMetadata> deleteReleaseOperationSettings() {
            return this.deleteReleaseOperationSettings;
        }

        public PagedCallSettings.Builder<ListVariantsRequest, ListVariantsResponse, ConfigDeliveryClient.ListVariantsPagedResponse> listVariantsSettings() {
            return this.listVariantsSettings;
        }

        public UnaryCallSettings.Builder<GetVariantRequest, Variant> getVariantSettings() {
            return this.getVariantSettings;
        }

        public UnaryCallSettings.Builder<CreateVariantRequest, Operation> createVariantSettings() {
            return this.createVariantSettings;
        }

        public OperationCallSettings.Builder<CreateVariantRequest, Variant, OperationMetadata> createVariantOperationSettings() {
            return this.createVariantOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateVariantRequest, Operation> updateVariantSettings() {
            return this.updateVariantSettings;
        }

        public OperationCallSettings.Builder<UpdateVariantRequest, Variant, OperationMetadata> updateVariantOperationSettings() {
            return this.updateVariantOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteVariantRequest, Operation> deleteVariantSettings() {
            return this.deleteVariantSettings;
        }

        public OperationCallSettings.Builder<DeleteVariantRequest, Empty, OperationMetadata> deleteVariantOperationSettings() {
            return this.deleteVariantOperationSettings;
        }

        public PagedCallSettings.Builder<ListRolloutsRequest, ListRolloutsResponse, ConfigDeliveryClient.ListRolloutsPagedResponse> listRolloutsSettings() {
            return this.listRolloutsSettings;
        }

        public UnaryCallSettings.Builder<GetRolloutRequest, Rollout> getRolloutSettings() {
            return this.getRolloutSettings;
        }

        public UnaryCallSettings.Builder<SuspendRolloutRequest, Operation> suspendRolloutSettings() {
            return this.suspendRolloutSettings;
        }

        public OperationCallSettings.Builder<SuspendRolloutRequest, Rollout, OperationMetadata> suspendRolloutOperationSettings() {
            return this.suspendRolloutOperationSettings;
        }

        public UnaryCallSettings.Builder<ResumeRolloutRequest, Operation> resumeRolloutSettings() {
            return this.resumeRolloutSettings;
        }

        public OperationCallSettings.Builder<ResumeRolloutRequest, Rollout, OperationMetadata> resumeRolloutOperationSettings() {
            return this.resumeRolloutOperationSettings;
        }

        public UnaryCallSettings.Builder<AbortRolloutRequest, Operation> abortRolloutSettings() {
            return this.abortRolloutSettings;
        }

        public OperationCallSettings.Builder<AbortRolloutRequest, Rollout, OperationMetadata> abortRolloutOperationSettings() {
            return this.abortRolloutOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ConfigDeliveryClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ConfigDeliveryStubSettings build() throws IOException {
            return new ConfigDeliveryStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

