/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.CalendarModeAdviceResponse;
import com.google.cloud.compute.v1.CalendarModeAdviceRpcRequest;
import com.google.cloud.compute.v1.stub.AdviceStub;
import com.google.cloud.compute.v1.stub.AdviceStubSettings;
import com.google.cloud.compute.v1.stub.HttpJsonAdviceCallableFactory;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonAdviceStub
extends AdviceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CalendarModeAdviceRpcRequest, CalendarModeAdviceResponse> calendarModeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Advice/CalendarMode").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/regions/{region}/advice/calendarMode", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        serializer.putPathParam(fields, "region", (Object)request.getRegion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("calendarModeAdviceRequestResource", (Message)request.getCalendarModeAdviceRequestResource(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CalendarModeAdviceResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CalendarModeAdviceRpcRequest, CalendarModeAdviceResponse> calendarModeCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonAdviceStub create(AdviceStubSettings settings) throws IOException {
        return new HttpJsonAdviceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonAdviceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonAdviceStub(AdviceStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonAdviceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonAdviceStub(AdviceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonAdviceStub(AdviceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonAdviceCallableFactory());
    }

    protected HttpJsonAdviceStub(AdviceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings calendarModeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(calendarModeMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("project", String.valueOf(request.getProject()));
            builder.add("region", String.valueOf(request.getRegion()));
            return builder.build();
        }).build();
        this.calendarModeCallable = callableFactory.createUnaryCallable(calendarModeTransportSettings, settings.calendarModeSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(calendarModeMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CalendarModeAdviceRpcRequest, CalendarModeAdviceResponse> calendarModeCallable() {
        return this.calendarModeCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

