/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteWireGroupRequest;
import com.google.cloud.compute.v1.GetWireGroupRequest;
import com.google.cloud.compute.v1.InsertWireGroupRequest;
import com.google.cloud.compute.v1.ListWireGroupsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchWireGroupRequest;
import com.google.cloud.compute.v1.WireGroup;
import com.google.cloud.compute.v1.WireGroupList;
import com.google.cloud.compute.v1.WireGroupsSettings;
import com.google.cloud.compute.v1.stub.WireGroupsStub;
import com.google.cloud.compute.v1.stub.WireGroupsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class WireGroupsClient
implements BackgroundResource {
    private final WireGroupsSettings settings;
    private final WireGroupsStub stub;

    public static final WireGroupsClient create() throws IOException {
        return WireGroupsClient.create(WireGroupsSettings.newBuilder().build());
    }

    public static final WireGroupsClient create(WireGroupsSettings settings) throws IOException {
        return new WireGroupsClient(settings);
    }

    public static final WireGroupsClient create(WireGroupsStub stub) {
        return new WireGroupsClient(stub);
    }

    protected WireGroupsClient(WireGroupsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((WireGroupsStubSettings)settings.getStubSettings()).createStub();
    }

    protected WireGroupsClient(WireGroupsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final WireGroupsSettings getSettings() {
        return this.settings;
    }

    public WireGroupsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String crossSiteNetwork, String wireGroup) {
        DeleteWireGroupRequest request = DeleteWireGroupRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).setWireGroup(wireGroup).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteWireGroupRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWireGroupRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteWireGroupRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final WireGroup get(String project, String crossSiteNetwork, String wireGroup) {
        GetWireGroupRequest request = GetWireGroupRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).setWireGroup(wireGroup).build();
        return this.get(request);
    }

    public final WireGroup get(GetWireGroupRequest request) {
        return (WireGroup)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetWireGroupRequest, WireGroup> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String crossSiteNetwork, WireGroup wireGroupResource) {
        InsertWireGroupRequest request = InsertWireGroupRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).setWireGroupResource(wireGroupResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertWireGroupRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertWireGroupRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertWireGroupRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String crossSiteNetwork) {
        ListWireGroupsRequest request = ListWireGroupsRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListWireGroupsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWireGroupsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListWireGroupsRequest, WireGroupList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String crossSiteNetwork, String wireGroup, WireGroup wireGroupResource) {
        PatchWireGroupRequest request = PatchWireGroupRequest.newBuilder().setProject(project).setCrossSiteNetwork(crossSiteNetwork).setWireGroup(wireGroup).setWireGroupResource(wireGroupResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchWireGroupRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchWireGroupRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchWireGroupRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWireGroupsRequest, WireGroupList, WireGroup, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListWireGroupsRequest, WireGroupList, WireGroup, ListPage> {
        private ListPage(PageContext<ListWireGroupsRequest, WireGroupList, WireGroup> context, WireGroupList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListWireGroupsRequest, WireGroupList, WireGroup> context, WireGroupList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListWireGroupsRequest, WireGroupList, WireGroup> context, ApiFuture<WireGroupList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListWireGroupsRequest, WireGroupList, WireGroup, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListWireGroupsRequest, WireGroupList, WireGroup> context, ApiFuture<WireGroupList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

