/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListFutureReservationsRequest;
import com.google.cloud.compute.v1.CancelFutureReservationRequest;
import com.google.cloud.compute.v1.DeleteFutureReservationRequest;
import com.google.cloud.compute.v1.FutureReservation;
import com.google.cloud.compute.v1.FutureReservationsAggregatedListResponse;
import com.google.cloud.compute.v1.FutureReservationsListResponse;
import com.google.cloud.compute.v1.FutureReservationsScopedList;
import com.google.cloud.compute.v1.FutureReservationsSettings;
import com.google.cloud.compute.v1.GetFutureReservationRequest;
import com.google.cloud.compute.v1.InsertFutureReservationRequest;
import com.google.cloud.compute.v1.ListFutureReservationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.UpdateFutureReservationRequest;
import com.google.cloud.compute.v1.stub.FutureReservationsStub;
import com.google.cloud.compute.v1.stub.FutureReservationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FutureReservationsClient
implements BackgroundResource {
    private final FutureReservationsSettings settings;
    private final FutureReservationsStub stub;

    public static final FutureReservationsClient create() throws IOException {
        return FutureReservationsClient.create(FutureReservationsSettings.newBuilder().build());
    }

    public static final FutureReservationsClient create(FutureReservationsSettings settings) throws IOException {
        return new FutureReservationsClient(settings);
    }

    public static final FutureReservationsClient create(FutureReservationsStub stub) {
        return new FutureReservationsClient(stub);
    }

    protected FutureReservationsClient(FutureReservationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FutureReservationsStubSettings)settings.getStubSettings()).createStub();
    }

    protected FutureReservationsClient(FutureReservationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FutureReservationsSettings getSettings() {
        return this.settings;
    }

    public FutureReservationsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListFutureReservationsRequest request = AggregatedListFutureReservationsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListFutureReservationsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListFutureReservationsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> cancelAsync(String project, String zone, String futureReservation) {
        CancelFutureReservationRequest request = CancelFutureReservationRequest.newBuilder().setProject(project).setZone(zone).setFutureReservation(futureReservation).build();
        return this.cancelAsync(request);
    }

    public final OperationFuture<Operation, Operation> cancelAsync(CancelFutureReservationRequest request) {
        return this.cancelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CancelFutureReservationRequest, Operation, Operation> cancelOperationCallable() {
        return this.stub.cancelOperationCallable();
    }

    public final UnaryCallable<CancelFutureReservationRequest, Operation> cancelCallable() {
        return this.stub.cancelCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String futureReservation) {
        DeleteFutureReservationRequest request = DeleteFutureReservationRequest.newBuilder().setProject(project).setZone(zone).setFutureReservation(futureReservation).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteFutureReservationRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteFutureReservationRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteFutureReservationRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final FutureReservation get(String project, String zone, String futureReservation) {
        GetFutureReservationRequest request = GetFutureReservationRequest.newBuilder().setProject(project).setZone(zone).setFutureReservation(futureReservation).build();
        return this.get(request);
    }

    public final FutureReservation get(GetFutureReservationRequest request) {
        return (FutureReservation)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetFutureReservationRequest, FutureReservation> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, FutureReservation futureReservationResource) {
        InsertFutureReservationRequest request = InsertFutureReservationRequest.newBuilder().setProject(project).setZone(zone).setFutureReservationResource(futureReservationResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertFutureReservationRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertFutureReservationRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertFutureReservationRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListFutureReservationsRequest request = ListFutureReservationsRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListFutureReservationsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFutureReservationsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListFutureReservationsRequest, FutureReservationsListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String zone, String futureReservation, FutureReservation futureReservationResource) {
        UpdateFutureReservationRequest request = UpdateFutureReservationRequest.newBuilder().setProject(project).setZone(zone).setFutureReservation(futureReservation).setFutureReservationResource(futureReservationResource).build();
        return this.updateAsync(request);
    }

    public final OperationFuture<Operation, Operation> updateAsync(UpdateFutureReservationRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateFutureReservationRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateFutureReservationRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation, ListPage> {
        private ListPage(PageContext<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation> context, FutureReservationsListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation> context, FutureReservationsListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation> context, ApiFuture<FutureReservationsListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListFutureReservationsRequest, FutureReservationsListResponse, FutureReservation> context, ApiFuture<FutureReservationsListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>> context, FutureReservationsAggregatedListResponse response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>> context, FutureReservationsAggregatedListResponse response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>> context, ApiFuture<FutureReservationsAggregatedListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListFutureReservationsRequest, FutureReservationsAggregatedListResponse, Map.Entry<String, FutureReservationsScopedList>> context, ApiFuture<FutureReservationsAggregatedListResponse> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

