/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BulkInsertInstanceResource;
import com.google.cloud.compute.v1.BulkInsertRegionInstanceRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionInstancesSettings;
import com.google.cloud.compute.v1.stub.RegionInstancesStub;
import com.google.cloud.compute.v1.stub.RegionInstancesStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RegionInstancesClient
implements BackgroundResource {
    private final RegionInstancesSettings settings;
    private final RegionInstancesStub stub;

    public static final RegionInstancesClient create() throws IOException {
        return RegionInstancesClient.create(RegionInstancesSettings.newBuilder().build());
    }

    public static final RegionInstancesClient create(RegionInstancesSettings settings) throws IOException {
        return new RegionInstancesClient(settings);
    }

    public static final RegionInstancesClient create(RegionInstancesStub stub) {
        return new RegionInstancesClient(stub);
    }

    protected RegionInstancesClient(RegionInstancesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionInstancesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionInstancesClient(RegionInstancesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionInstancesSettings getSettings() {
        return this.settings;
    }

    public RegionInstancesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> bulkInsertAsync(String project, String region, BulkInsertInstanceResource bulkInsertInstanceResourceResource) {
        BulkInsertRegionInstanceRequest request = BulkInsertRegionInstanceRequest.newBuilder().setProject(project).setRegion(region).setBulkInsertInstanceResourceResource(bulkInsertInstanceResourceResource).build();
        return this.bulkInsertAsync(request);
    }

    public final OperationFuture<Operation, Operation> bulkInsertAsync(BulkInsertRegionInstanceRequest request) {
        return this.bulkInsertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BulkInsertRegionInstanceRequest, Operation, Operation> bulkInsertOperationCallable() {
        return this.stub.bulkInsertOperationCallable();
    }

    public final UnaryCallable<BulkInsertRegionInstanceRequest, Operation> bulkInsertCallable() {
        return this.stub.bulkInsertCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

