/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListInstanceTemplatesRequest;
import com.google.cloud.compute.v1.DeleteInstanceTemplateRequest;
import com.google.cloud.compute.v1.GetIamPolicyInstanceTemplateRequest;
import com.google.cloud.compute.v1.GetInstanceTemplateRequest;
import com.google.cloud.compute.v1.GlobalSetPolicyRequest;
import com.google.cloud.compute.v1.InsertInstanceTemplateRequest;
import com.google.cloud.compute.v1.InstanceTemplate;
import com.google.cloud.compute.v1.InstanceTemplateAggregatedList;
import com.google.cloud.compute.v1.InstanceTemplateList;
import com.google.cloud.compute.v1.InstanceTemplatesScopedList;
import com.google.cloud.compute.v1.InstanceTemplatesSettings;
import com.google.cloud.compute.v1.ListInstanceTemplatesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicyInstanceTemplateRequest;
import com.google.cloud.compute.v1.TestIamPermissionsInstanceTemplateRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.InstanceTemplatesStub;
import com.google.cloud.compute.v1.stub.InstanceTemplatesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InstanceTemplatesClient
implements BackgroundResource {
    private final InstanceTemplatesSettings settings;
    private final InstanceTemplatesStub stub;

    public static final InstanceTemplatesClient create() throws IOException {
        return InstanceTemplatesClient.create(InstanceTemplatesSettings.newBuilder().build());
    }

    public static final InstanceTemplatesClient create(InstanceTemplatesSettings settings) throws IOException {
        return new InstanceTemplatesClient(settings);
    }

    public static final InstanceTemplatesClient create(InstanceTemplatesStub stub) {
        return new InstanceTemplatesClient(stub);
    }

    protected InstanceTemplatesClient(InstanceTemplatesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceTemplatesStubSettings)settings.getStubSettings()).createStub();
    }

    protected InstanceTemplatesClient(InstanceTemplatesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceTemplatesSettings getSettings() {
        return this.settings;
    }

    public InstanceTemplatesStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListInstanceTemplatesRequest request = AggregatedListInstanceTemplatesRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListInstanceTemplatesRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListInstanceTemplatesRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String instanceTemplate) {
        DeleteInstanceTemplateRequest request = DeleteInstanceTemplateRequest.newBuilder().setProject(project).setInstanceTemplate(instanceTemplate).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInstanceTemplateRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceTemplateRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceTemplateRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InstanceTemplate get(String project, String instanceTemplate) {
        GetInstanceTemplateRequest request = GetInstanceTemplateRequest.newBuilder().setProject(project).setInstanceTemplate(instanceTemplate).build();
        return this.get(request);
    }

    public final InstanceTemplate get(GetInstanceTemplateRequest request) {
        return (InstanceTemplate)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceTemplateRequest, InstanceTemplate> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String resource) {
        GetIamPolicyInstanceTemplateRequest request = GetIamPolicyInstanceTemplateRequest.newBuilder().setProject(project).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyInstanceTemplateRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyInstanceTemplateRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, InstanceTemplate instanceTemplateResource) {
        InsertInstanceTemplateRequest request = InsertInstanceTemplateRequest.newBuilder().setProject(project).setInstanceTemplateResource(instanceTemplateResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertInstanceTemplateRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInstanceTemplateRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInstanceTemplateRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListInstanceTemplatesRequest request = ListInstanceTemplatesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInstanceTemplatesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceTemplatesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInstanceTemplatesRequest, InstanceTemplateList> listCallable() {
        return this.stub.listCallable();
    }

    public final Policy setIamPolicy(String project, String resource, GlobalSetPolicyRequest globalSetPolicyRequestResource) {
        SetIamPolicyInstanceTemplateRequest request = SetIamPolicyInstanceTemplateRequest.newBuilder().setProject(project).setResource(resource).setGlobalSetPolicyRequestResource(globalSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyInstanceTemplateRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyInstanceTemplateRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsInstanceTemplateRequest request = TestIamPermissionsInstanceTemplateRequest.newBuilder().setProject(project).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsInstanceTemplateRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsInstanceTemplateRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate, ListPage> {
        private ListPage(PageContext<ListInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, InstanceTemplateList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, InstanceTemplateList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, ApiFuture<InstanceTemplateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInstanceTemplatesRequest, InstanceTemplateList, InstanceTemplate> context, ApiFuture<InstanceTemplateList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList, Map.Entry<String, InstanceTemplatesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList, Map.Entry<String, InstanceTemplatesScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList, Map.Entry<String, InstanceTemplatesScopedList>> context, InstanceTemplateAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList, Map.Entry<String, InstanceTemplatesScopedList>> context, InstanceTemplateAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList, Map.Entry<String, InstanceTemplatesScopedList>> context, ApiFuture<InstanceTemplateAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList, Map.Entry<String, InstanceTemplatesScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListInstanceTemplatesRequest, InstanceTemplateAggregatedList, Map.Entry<String, InstanceTemplatesScopedList>> context, ApiFuture<InstanceTemplateAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

