/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionSslPolicyRequest;
import com.google.cloud.compute.v1.GetRegionSslPolicyRequest;
import com.google.cloud.compute.v1.InsertRegionSslPolicyRequest;
import com.google.cloud.compute.v1.ListAvailableFeaturesRegionSslPoliciesRequest;
import com.google.cloud.compute.v1.ListRegionSslPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionSslPolicyRequest;
import com.google.cloud.compute.v1.RegionSslPoliciesSettings;
import com.google.cloud.compute.v1.SslPoliciesList;
import com.google.cloud.compute.v1.SslPoliciesListAvailableFeaturesResponse;
import com.google.cloud.compute.v1.SslPolicy;
import com.google.cloud.compute.v1.stub.RegionSslPoliciesStub;
import com.google.cloud.compute.v1.stub.RegionSslPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionSslPoliciesClient
implements BackgroundResource {
    private final RegionSslPoliciesSettings settings;
    private final RegionSslPoliciesStub stub;

    public static final RegionSslPoliciesClient create() throws IOException {
        return RegionSslPoliciesClient.create(RegionSslPoliciesSettings.newBuilder().build());
    }

    public static final RegionSslPoliciesClient create(RegionSslPoliciesSettings settings) throws IOException {
        return new RegionSslPoliciesClient(settings);
    }

    public static final RegionSslPoliciesClient create(RegionSslPoliciesStub stub) {
        return new RegionSslPoliciesClient(stub);
    }

    protected RegionSslPoliciesClient(RegionSslPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionSslPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionSslPoliciesClient(RegionSslPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionSslPoliciesSettings getSettings() {
        return this.settings;
    }

    public RegionSslPoliciesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String sslPolicy) {
        DeleteRegionSslPolicyRequest request = DeleteRegionSslPolicyRequest.newBuilder().setProject(project).setRegion(region).setSslPolicy(sslPolicy).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionSslPolicyRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionSslPolicyRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionSslPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SslPolicy get(String project, String region, String sslPolicy) {
        GetRegionSslPolicyRequest request = GetRegionSslPolicyRequest.newBuilder().setProject(project).setRegion(region).setSslPolicy(sslPolicy).build();
        return this.get(request);
    }

    public final SslPolicy get(GetRegionSslPolicyRequest request) {
        return (SslPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionSslPolicyRequest, SslPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, SslPolicy sslPolicyResource) {
        InsertRegionSslPolicyRequest request = InsertRegionSslPolicyRequest.newBuilder().setProject(project).setRegion(region).setSslPolicyResource(sslPolicyResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionSslPolicyRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionSslPolicyRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionSslPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionSslPoliciesRequest request = ListRegionSslPoliciesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionSslPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionSslPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionSslPoliciesRequest, SslPoliciesList> listCallable() {
        return this.stub.listCallable();
    }

    public final SslPoliciesListAvailableFeaturesResponse listAvailableFeatures(String project, String region) {
        ListAvailableFeaturesRegionSslPoliciesRequest request = ListAvailableFeaturesRegionSslPoliciesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.listAvailableFeatures(request);
    }

    public final SslPoliciesListAvailableFeaturesResponse listAvailableFeatures(ListAvailableFeaturesRegionSslPoliciesRequest request) {
        return (SslPoliciesListAvailableFeaturesResponse)this.listAvailableFeaturesCallable().call((Object)request);
    }

    public final UnaryCallable<ListAvailableFeaturesRegionSslPoliciesRequest, SslPoliciesListAvailableFeaturesResponse> listAvailableFeaturesCallable() {
        return this.stub.listAvailableFeaturesCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String sslPolicy, SslPolicy sslPolicyResource) {
        PatchRegionSslPolicyRequest request = PatchRegionSslPolicyRequest.newBuilder().setProject(project).setRegion(region).setSslPolicy(sslPolicy).setSslPolicyResource(sslPolicyResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionSslPolicyRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionSslPolicyRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionSslPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage> {
        private ListPage(PageContext<ListRegionSslPoliciesRequest, SslPoliciesList, SslPolicy> context, SslPoliciesList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionSslPoliciesRequest, SslPoliciesList, SslPolicy> context, SslPoliciesList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionSslPoliciesRequest, SslPoliciesList, SslPolicy> context, ApiFuture<SslPoliciesList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionSslPoliciesRequest, SslPoliciesList, SslPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionSslPoliciesRequest, SslPoliciesList, SslPolicy> context, ApiFuture<SslPoliciesList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

