/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetInterconnectRemoteLocationRequest;
import com.google.cloud.compute.v1.InterconnectRemoteLocation;
import com.google.cloud.compute.v1.InterconnectRemoteLocationList;
import com.google.cloud.compute.v1.InterconnectRemoteLocationsSettings;
import com.google.cloud.compute.v1.ListInterconnectRemoteLocationsRequest;
import com.google.cloud.compute.v1.stub.InterconnectRemoteLocationsStub;
import com.google.cloud.compute.v1.stub.InterconnectRemoteLocationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InterconnectRemoteLocationsClient
implements BackgroundResource {
    private final InterconnectRemoteLocationsSettings settings;
    private final InterconnectRemoteLocationsStub stub;

    public static final InterconnectRemoteLocationsClient create() throws IOException {
        return InterconnectRemoteLocationsClient.create(InterconnectRemoteLocationsSettings.newBuilder().build());
    }

    public static final InterconnectRemoteLocationsClient create(InterconnectRemoteLocationsSettings settings) throws IOException {
        return new InterconnectRemoteLocationsClient(settings);
    }

    public static final InterconnectRemoteLocationsClient create(InterconnectRemoteLocationsStub stub) {
        return new InterconnectRemoteLocationsClient(stub);
    }

    protected InterconnectRemoteLocationsClient(InterconnectRemoteLocationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InterconnectRemoteLocationsStubSettings)settings.getStubSettings()).createStub();
    }

    protected InterconnectRemoteLocationsClient(InterconnectRemoteLocationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InterconnectRemoteLocationsSettings getSettings() {
        return this.settings;
    }

    public InterconnectRemoteLocationsStub getStub() {
        return this.stub;
    }

    public final InterconnectRemoteLocation get(String project, String interconnectRemoteLocation) {
        GetInterconnectRemoteLocationRequest request = GetInterconnectRemoteLocationRequest.newBuilder().setProject(project).setInterconnectRemoteLocation(interconnectRemoteLocation).build();
        return this.get(request);
    }

    public final InterconnectRemoteLocation get(GetInterconnectRemoteLocationRequest request) {
        return (InterconnectRemoteLocation)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInterconnectRemoteLocationRequest, InterconnectRemoteLocation> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project) {
        ListInterconnectRemoteLocationsRequest request = ListInterconnectRemoteLocationsRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInterconnectRemoteLocationsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInterconnectRemoteLocationsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation, ListPage> {
        private ListPage(PageContext<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation> context, InterconnectRemoteLocationList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation> context, InterconnectRemoteLocationList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation> context, ApiFuture<InterconnectRemoteLocationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInterconnectRemoteLocationsRequest, InterconnectRemoteLocationList, InterconnectRemoteLocation> context, ApiFuture<InterconnectRemoteLocationList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

