/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddSignedUrlKeyBackendBucketRequest;
import com.google.cloud.compute.v1.BackendBucket;
import com.google.cloud.compute.v1.BackendBucketList;
import com.google.cloud.compute.v1.BackendBucketsClient;
import com.google.cloud.compute.v1.DeleteBackendBucketRequest;
import com.google.cloud.compute.v1.DeleteSignedUrlKeyBackendBucketRequest;
import com.google.cloud.compute.v1.GetBackendBucketRequest;
import com.google.cloud.compute.v1.GetIamPolicyBackendBucketRequest;
import com.google.cloud.compute.v1.InsertBackendBucketRequest;
import com.google.cloud.compute.v1.ListBackendBucketsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchBackendBucketRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetEdgeSecurityPolicyBackendBucketRequest;
import com.google.cloud.compute.v1.SetIamPolicyBackendBucketRequest;
import com.google.cloud.compute.v1.TestIamPermissionsBackendBucketRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateBackendBucketRequest;
import com.google.cloud.compute.v1.stub.BackendBucketsStub;
import com.google.cloud.compute.v1.stub.HttpJsonBackendBucketsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class BackendBucketsStubSettings
extends StubSettings<BackendBucketsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AddSignedUrlKeyBackendBucketRequest, Operation> addSignedUrlKeySettings;
    private final OperationCallSettings<AddSignedUrlKeyBackendBucketRequest, Operation, Operation> addSignedUrlKeyOperationSettings;
    private final UnaryCallSettings<DeleteBackendBucketRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteBackendBucketRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DeleteSignedUrlKeyBackendBucketRequest, Operation> deleteSignedUrlKeySettings;
    private final OperationCallSettings<DeleteSignedUrlKeyBackendBucketRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings;
    private final UnaryCallSettings<GetBackendBucketRequest, BackendBucket> getSettings;
    private final UnaryCallSettings<GetIamPolicyBackendBucketRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<InsertBackendBucketRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertBackendBucketRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListBackendBucketsRequest, BackendBucketList, BackendBucketsClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchBackendBucketRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchBackendBucketRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<SetEdgeSecurityPolicyBackendBucketRequest, Operation> setEdgeSecurityPolicySettings;
    private final OperationCallSettings<SetEdgeSecurityPolicyBackendBucketRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings;
    private final UnaryCallSettings<SetIamPolicyBackendBucketRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsBackendBucketRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private final UnaryCallSettings<UpdateBackendBucketRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateBackendBucketRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<ListBackendBucketsRequest, BackendBucketList, BackendBucket> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListBackendBucketsRequest, BackendBucketList, BackendBucket>(){

        public String emptyToken() {
            return "";
        }

        public ListBackendBucketsRequest injectToken(ListBackendBucketsRequest payload, String token) {
            return ListBackendBucketsRequest.newBuilder((ListBackendBucketsRequest)payload).setPageToken(token).build();
        }

        public ListBackendBucketsRequest injectPageSize(ListBackendBucketsRequest payload, int pageSize) {
            return ListBackendBucketsRequest.newBuilder((ListBackendBucketsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListBackendBucketsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(BackendBucketList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<BackendBucket> extractResources(BackendBucketList payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListBackendBucketsRequest, BackendBucketList, BackendBucketsClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListBackendBucketsRequest, BackendBucketList, BackendBucketsClient.ListPagedResponse>(){

        public ApiFuture<BackendBucketsClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListBackendBucketsRequest, BackendBucketList> callable, ListBackendBucketsRequest request, ApiCallContext context, ApiFuture<BackendBucketList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BackendBucketsClient.ListPagedResponse.createAsync((PageContext<ListBackendBucketsRequest, BackendBucketList, BackendBucket>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AddSignedUrlKeyBackendBucketRequest, Operation> addSignedUrlKeySettings() {
        return this.addSignedUrlKeySettings;
    }

    public OperationCallSettings<AddSignedUrlKeyBackendBucketRequest, Operation, Operation> addSignedUrlKeyOperationSettings() {
        return this.addSignedUrlKeyOperationSettings;
    }

    public UnaryCallSettings<DeleteBackendBucketRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteBackendBucketRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DeleteSignedUrlKeyBackendBucketRequest, Operation> deleteSignedUrlKeySettings() {
        return this.deleteSignedUrlKeySettings;
    }

    public OperationCallSettings<DeleteSignedUrlKeyBackendBucketRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings() {
        return this.deleteSignedUrlKeyOperationSettings;
    }

    public UnaryCallSettings<GetBackendBucketRequest, BackendBucket> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyBackendBucketRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<InsertBackendBucketRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertBackendBucketRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListBackendBucketsRequest, BackendBucketList, BackendBucketsClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchBackendBucketRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchBackendBucketRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<SetEdgeSecurityPolicyBackendBucketRequest, Operation> setEdgeSecurityPolicySettings() {
        return this.setEdgeSecurityPolicySettings;
    }

    public OperationCallSettings<SetEdgeSecurityPolicyBackendBucketRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings() {
        return this.setEdgeSecurityPolicyOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyBackendBucketRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsBackendBucketRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public UnaryCallSettings<UpdateBackendBucketRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateBackendBucketRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public BackendBucketsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBackendBucketsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BackendBucketsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BackendBucketsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BackendBucketsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.addSignedUrlKeySettings = settingsBuilder.addSignedUrlKeySettings().build();
        this.addSignedUrlKeyOperationSettings = settingsBuilder.addSignedUrlKeyOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.deleteSignedUrlKeySettings = settingsBuilder.deleteSignedUrlKeySettings().build();
        this.deleteSignedUrlKeyOperationSettings = settingsBuilder.deleteSignedUrlKeyOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.setEdgeSecurityPolicySettings = settingsBuilder.setEdgeSecurityPolicySettings().build();
        this.setEdgeSecurityPolicyOperationSettings = settingsBuilder.setEdgeSecurityPolicyOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BackendBucketsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AddSignedUrlKeyBackendBucketRequest, Operation> addSignedUrlKeySettings;
        private final OperationCallSettings.Builder<AddSignedUrlKeyBackendBucketRequest, Operation, Operation> addSignedUrlKeyOperationSettings;
        private final UnaryCallSettings.Builder<DeleteBackendBucketRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteBackendBucketRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendBucketRequest, Operation> deleteSignedUrlKeySettings;
        private final OperationCallSettings.Builder<DeleteSignedUrlKeyBackendBucketRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings;
        private final UnaryCallSettings.Builder<GetBackendBucketRequest, BackendBucket> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyBackendBucketRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<InsertBackendBucketRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertBackendBucketRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListBackendBucketsRequest, BackendBucketList, BackendBucketsClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchBackendBucketRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchBackendBucketRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<SetEdgeSecurityPolicyBackendBucketRequest, Operation> setEdgeSecurityPolicySettings;
        private final OperationCallSettings.Builder<SetEdgeSecurityPolicyBackendBucketRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyBackendBucketRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsBackendBucketRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private final UnaryCallSettings.Builder<UpdateBackendBucketRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateBackendBucketRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.addSignedUrlKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.addSignedUrlKeyOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSignedUrlKeySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSignedUrlKeyOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.setEdgeSecurityPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setEdgeSecurityPolicyOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeySettings, this.deleteSettings, this.deleteSignedUrlKeySettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.patchSettings, this.setEdgeSecurityPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        protected Builder(BackendBucketsStubSettings settings) {
            super((StubSettings)settings);
            this.addSignedUrlKeySettings = settings.addSignedUrlKeySettings.toBuilder();
            this.addSignedUrlKeyOperationSettings = settings.addSignedUrlKeyOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.deleteSignedUrlKeySettings = settings.deleteSignedUrlKeySettings.toBuilder();
            this.deleteSignedUrlKeyOperationSettings = settings.deleteSignedUrlKeyOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.setEdgeSecurityPolicySettings = settings.setEdgeSecurityPolicySettings.toBuilder();
            this.setEdgeSecurityPolicyOperationSettings = settings.setEdgeSecurityPolicyOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.addSignedUrlKeySettings, this.deleteSettings, this.deleteSignedUrlKeySettings, this.getSettings, this.getIamPolicySettings, this.insertSettings, this.listSettings, this.patchSettings, this.setEdgeSecurityPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings, this.updateSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BackendBucketsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BackendBucketsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BackendBucketsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(BackendBucketsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.addSignedUrlKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSignedUrlKeySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setEdgeSecurityPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.addSignedUrlKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.deleteSignedUrlKeyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.setEdgeSecurityPolicyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AddSignedUrlKeyBackendBucketRequest, Operation> addSignedUrlKeySettings() {
            return this.addSignedUrlKeySettings;
        }

        public OperationCallSettings.Builder<AddSignedUrlKeyBackendBucketRequest, Operation, Operation> addSignedUrlKeyOperationSettings() {
            return this.addSignedUrlKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteBackendBucketRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteBackendBucketRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSignedUrlKeyBackendBucketRequest, Operation> deleteSignedUrlKeySettings() {
            return this.deleteSignedUrlKeySettings;
        }

        public OperationCallSettings.Builder<DeleteSignedUrlKeyBackendBucketRequest, Operation, Operation> deleteSignedUrlKeyOperationSettings() {
            return this.deleteSignedUrlKeyOperationSettings;
        }

        public UnaryCallSettings.Builder<GetBackendBucketRequest, BackendBucket> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyBackendBucketRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<InsertBackendBucketRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertBackendBucketRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListBackendBucketsRequest, BackendBucketList, BackendBucketsClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchBackendBucketRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchBackendBucketRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<SetEdgeSecurityPolicyBackendBucketRequest, Operation> setEdgeSecurityPolicySettings() {
            return this.setEdgeSecurityPolicySettings;
        }

        public OperationCallSettings.Builder<SetEdgeSecurityPolicyBackendBucketRequest, Operation, Operation> setEdgeSecurityPolicyOperationSettings() {
            return this.setEdgeSecurityPolicyOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyBackendBucketRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsBackendBucketRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateBackendBucketRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateBackendBucketRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public BackendBucketsStubSettings build() throws IOException {
            return new BackendBucketsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

