/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetIamPolicyReservationSubBlockRequest;
import com.google.cloud.compute.v1.GetReservationSubBlockRequest;
import com.google.cloud.compute.v1.ListReservationSubBlocksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PerformMaintenanceReservationSubBlockRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.ReportFaultyReservationSubBlockRequest;
import com.google.cloud.compute.v1.ReservationSubBlock;
import com.google.cloud.compute.v1.ReservationSubBlocksClient;
import com.google.cloud.compute.v1.ReservationSubBlocksGetResponse;
import com.google.cloud.compute.v1.ReservationSubBlocksListResponse;
import com.google.cloud.compute.v1.SetIamPolicyReservationSubBlockRequest;
import com.google.cloud.compute.v1.TestIamPermissionsReservationSubBlockRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonReservationSubBlocksStub;
import com.google.cloud.compute.v1.stub.ReservationSubBlocksStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ReservationSubBlocksStubSettings
extends StubSettings<ReservationSubBlocksStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings;
    private final UnaryCallSettings<GetIamPolicyReservationSubBlockRequest, Policy> getIamPolicySettings;
    private final PagedCallSettings<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PerformMaintenanceReservationSubBlockRequest, Operation> performMaintenanceSettings;
    private final OperationCallSettings<PerformMaintenanceReservationSubBlockRequest, Operation, Operation> performMaintenanceOperationSettings;
    private final UnaryCallSettings<ReportFaultyReservationSubBlockRequest, Operation> reportFaultySettings;
    private final OperationCallSettings<ReportFaultyReservationSubBlockRequest, Operation, Operation> reportFaultyOperationSettings;
    private final UnaryCallSettings<SetIamPolicyReservationSubBlockRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsReservationSubBlockRequest, TestPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock>(){

        public String emptyToken() {
            return "";
        }

        public ListReservationSubBlocksRequest injectToken(ListReservationSubBlocksRequest payload, String token) {
            return ListReservationSubBlocksRequest.newBuilder((ListReservationSubBlocksRequest)payload).setPageToken(token).build();
        }

        public ListReservationSubBlocksRequest injectPageSize(ListReservationSubBlocksRequest payload, int pageSize) {
            return ListReservationSubBlocksRequest.newBuilder((ListReservationSubBlocksRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListReservationSubBlocksRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ReservationSubBlocksListResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ReservationSubBlock> extractResources(ReservationSubBlocksListResponse payload) {
            return payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse>(){

        public ApiFuture<ReservationSubBlocksClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse> callable, ListReservationSubBlocksRequest request, ApiCallContext context, ApiFuture<ReservationSubBlocksListResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ReservationSubBlocksClient.ListPagedResponse.createAsync((PageContext<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlock>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetIamPolicyReservationSubBlockRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public PagedCallSettings<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PerformMaintenanceReservationSubBlockRequest, Operation> performMaintenanceSettings() {
        return this.performMaintenanceSettings;
    }

    public OperationCallSettings<PerformMaintenanceReservationSubBlockRequest, Operation, Operation> performMaintenanceOperationSettings() {
        return this.performMaintenanceOperationSettings;
    }

    public UnaryCallSettings<ReportFaultyReservationSubBlockRequest, Operation> reportFaultySettings() {
        return this.reportFaultySettings;
    }

    public OperationCallSettings<ReportFaultyReservationSubBlockRequest, Operation, Operation> reportFaultyOperationSettings() {
        return this.reportFaultyOperationSettings;
    }

    public UnaryCallSettings<SetIamPolicyReservationSubBlockRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsReservationSubBlockRequest, TestPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public ReservationSubBlocksStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonReservationSubBlocksStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ReservationSubBlocksStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ReservationSubBlocksStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ReservationSubBlocksStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSettings = settingsBuilder.getSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.performMaintenanceSettings = settingsBuilder.performMaintenanceSettings().build();
        this.performMaintenanceOperationSettings = settingsBuilder.performMaintenanceOperationSettings().build();
        this.reportFaultySettings = settingsBuilder.reportFaultySettings().build();
        this.reportFaultyOperationSettings = settingsBuilder.reportFaultyOperationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ReservationSubBlocksStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyReservationSubBlockRequest, Policy> getIamPolicySettings;
        private final PagedCallSettings.Builder<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PerformMaintenanceReservationSubBlockRequest, Operation> performMaintenanceSettings;
        private final OperationCallSettings.Builder<PerformMaintenanceReservationSubBlockRequest, Operation, Operation> performMaintenanceOperationSettings;
        private final UnaryCallSettings.Builder<ReportFaultyReservationSubBlockRequest, Operation> reportFaultySettings;
        private final OperationCallSettings.Builder<ReportFaultyReservationSubBlockRequest, Operation, Operation> reportFaultyOperationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyReservationSubBlockRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsReservationSubBlockRequest, TestPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.performMaintenanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.performMaintenanceOperationSettings = OperationCallSettings.newBuilder();
            this.reportFaultySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reportFaultyOperationSettings = OperationCallSettings.newBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.getIamPolicySettings, this.listSettings, this.performMaintenanceSettings, this.reportFaultySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ReservationSubBlocksStubSettings settings) {
            super((StubSettings)settings);
            this.getSettings = settings.getSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.performMaintenanceSettings = settings.performMaintenanceSettings.toBuilder();
            this.performMaintenanceOperationSettings = settings.performMaintenanceOperationSettings.toBuilder();
            this.reportFaultySettings = settings.reportFaultySettings.toBuilder();
            this.reportFaultyOperationSettings = settings.reportFaultyOperationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSettings, this.getIamPolicySettings, this.listSettings, this.performMaintenanceSettings, this.reportFaultySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ReservationSubBlocksStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ReservationSubBlocksStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ReservationSubBlocksStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ReservationSubBlocksStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.performMaintenanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.reportFaultySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.performMaintenanceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            builder.reportFaultyOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(20000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetReservationSubBlockRequest, ReservationSubBlocksGetResponse> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyReservationSubBlockRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public PagedCallSettings.Builder<ListReservationSubBlocksRequest, ReservationSubBlocksListResponse, ReservationSubBlocksClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PerformMaintenanceReservationSubBlockRequest, Operation> performMaintenanceSettings() {
            return this.performMaintenanceSettings;
        }

        public OperationCallSettings.Builder<PerformMaintenanceReservationSubBlockRequest, Operation, Operation> performMaintenanceOperationSettings() {
            return this.performMaintenanceOperationSettings;
        }

        public UnaryCallSettings.Builder<ReportFaultyReservationSubBlockRequest, Operation> reportFaultySettings() {
            return this.reportFaultySettings;
        }

        public OperationCallSettings.Builder<ReportFaultyReservationSubBlockRequest, Operation, Operation> reportFaultyOperationSettings() {
            return this.reportFaultyOperationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyReservationSubBlockRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsReservationSubBlockRequest, TestPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ReservationSubBlocksStubSettings build() throws IOException {
            return new ReservationSubBlocksStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(600000L)).setTotalTimeoutDuration(Duration.ofMillis(600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

