/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionHealthCheckServiceRequest;
import com.google.cloud.compute.v1.GetRegionHealthCheckServiceRequest;
import com.google.cloud.compute.v1.HealthCheckService;
import com.google.cloud.compute.v1.HealthCheckServicesList;
import com.google.cloud.compute.v1.InsertRegionHealthCheckServiceRequest;
import com.google.cloud.compute.v1.ListRegionHealthCheckServicesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionHealthCheckServiceRequest;
import com.google.cloud.compute.v1.RegionHealthCheckServicesSettings;
import com.google.cloud.compute.v1.stub.RegionHealthCheckServicesStub;
import com.google.cloud.compute.v1.stub.RegionHealthCheckServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionHealthCheckServicesClient
implements BackgroundResource {
    private final RegionHealthCheckServicesSettings settings;
    private final RegionHealthCheckServicesStub stub;

    public static final RegionHealthCheckServicesClient create() throws IOException {
        return RegionHealthCheckServicesClient.create(RegionHealthCheckServicesSettings.newBuilder().build());
    }

    public static final RegionHealthCheckServicesClient create(RegionHealthCheckServicesSettings settings) throws IOException {
        return new RegionHealthCheckServicesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionHealthCheckServicesClient create(RegionHealthCheckServicesStub stub) {
        return new RegionHealthCheckServicesClient(stub);
    }

    protected RegionHealthCheckServicesClient(RegionHealthCheckServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionHealthCheckServicesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionHealthCheckServicesClient(RegionHealthCheckServicesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionHealthCheckServicesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionHealthCheckServicesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String healthCheckService) {
        DeleteRegionHealthCheckServiceRequest request = DeleteRegionHealthCheckServiceRequest.newBuilder().setProject(project).setRegion(region).setHealthCheckService(healthCheckService).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionHealthCheckServiceRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionHealthCheckServiceRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionHealthCheckServiceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final HealthCheckService get(String project, String region, String healthCheckService) {
        GetRegionHealthCheckServiceRequest request = GetRegionHealthCheckServiceRequest.newBuilder().setProject(project).setRegion(region).setHealthCheckService(healthCheckService).build();
        return this.get(request);
    }

    public final HealthCheckService get(GetRegionHealthCheckServiceRequest request) {
        return (HealthCheckService)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionHealthCheckServiceRequest, HealthCheckService> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, HealthCheckService healthCheckServiceResource) {
        InsertRegionHealthCheckServiceRequest request = InsertRegionHealthCheckServiceRequest.newBuilder().setProject(project).setRegion(region).setHealthCheckServiceResource(healthCheckServiceResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionHealthCheckServiceRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionHealthCheckServiceRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionHealthCheckServiceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionHealthCheckServicesRequest request = ListRegionHealthCheckServicesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionHealthCheckServicesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionHealthCheckServicesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionHealthCheckServicesRequest, HealthCheckServicesList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String healthCheckService, HealthCheckService healthCheckServiceResource) {
        PatchRegionHealthCheckServiceRequest request = PatchRegionHealthCheckServiceRequest.newBuilder().setProject(project).setRegion(region).setHealthCheckService(healthCheckService).setHealthCheckServiceResource(healthCheckServiceResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionHealthCheckServiceRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionHealthCheckServiceRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionHealthCheckServiceRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionHealthCheckServicesRequest, HealthCheckServicesList, HealthCheckService, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionHealthCheckServicesRequest, HealthCheckServicesList, HealthCheckService, ListPage> {
        private ListPage(PageContext<ListRegionHealthCheckServicesRequest, HealthCheckServicesList, HealthCheckService> context, HealthCheckServicesList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionHealthCheckServicesRequest, HealthCheckServicesList, HealthCheckService> context, HealthCheckServicesList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionHealthCheckServicesRequest, HealthCheckServicesList, HealthCheckService> context, ApiFuture<HealthCheckServicesList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionHealthCheckServicesRequest, HealthCheckServicesList, HealthCheckService, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionHealthCheckServicesRequest, HealthCheckServicesList, HealthCheckService> context, ApiFuture<HealthCheckServicesList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

