/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DiskType;
import com.google.cloud.compute.v1.GetRegionDiskTypeRequest;
import com.google.cloud.compute.v1.ListRegionDiskTypesRequest;
import com.google.cloud.compute.v1.RegionDiskTypeList;
import com.google.cloud.compute.v1.RegionDiskTypesSettings;
import com.google.cloud.compute.v1.stub.RegionDiskTypesStub;
import com.google.cloud.compute.v1.stub.RegionDiskTypesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionDiskTypesClient
implements BackgroundResource {
    private final RegionDiskTypesSettings settings;
    private final RegionDiskTypesStub stub;

    public static final RegionDiskTypesClient create() throws IOException {
        return RegionDiskTypesClient.create(RegionDiskTypesSettings.newBuilder().build());
    }

    public static final RegionDiskTypesClient create(RegionDiskTypesSettings settings) throws IOException {
        return new RegionDiskTypesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionDiskTypesClient create(RegionDiskTypesStub stub) {
        return new RegionDiskTypesClient(stub);
    }

    protected RegionDiskTypesClient(RegionDiskTypesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionDiskTypesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionDiskTypesClient(RegionDiskTypesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionDiskTypesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionDiskTypesStub getStub() {
        return this.stub;
    }

    public final DiskType get(String project, String region, String diskType) {
        GetRegionDiskTypeRequest request = GetRegionDiskTypeRequest.newBuilder().setProject(project).setRegion(region).setDiskType(diskType).build();
        return this.get(request);
    }

    public final DiskType get(GetRegionDiskTypeRequest request) {
        return (DiskType)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionDiskTypeRequest, DiskType> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionDiskTypesRequest request = ListRegionDiskTypesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionDiskTypesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionDiskTypesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionDiskTypesRequest, RegionDiskTypeList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionDiskTypesRequest, RegionDiskTypeList, DiskType, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionDiskTypesRequest, RegionDiskTypeList, DiskType, ListPage> {
        private ListPage(PageContext<ListRegionDiskTypesRequest, RegionDiskTypeList, DiskType> context, RegionDiskTypeList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionDiskTypesRequest, RegionDiskTypeList, DiskType> context, RegionDiskTypeList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionDiskTypesRequest, RegionDiskTypeList, DiskType> context, ApiFuture<RegionDiskTypeList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionDiskTypesRequest, RegionDiskTypeList, DiskType, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionDiskTypesRequest, RegionDiskTypeList, DiskType> context, ApiFuture<RegionDiskTypeList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

