/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRegionSslCertificateRequest;
import com.google.cloud.compute.v1.GetRegionSslCertificateRequest;
import com.google.cloud.compute.v1.InsertRegionSslCertificateRequest;
import com.google.cloud.compute.v1.ListRegionSslCertificatesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.RegionSslCertificatesSettings;
import com.google.cloud.compute.v1.SslCertificate;
import com.google.cloud.compute.v1.SslCertificateList;
import com.google.cloud.compute.v1.stub.RegionSslCertificatesStub;
import com.google.cloud.compute.v1.stub.RegionSslCertificatesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionSslCertificatesClient
implements BackgroundResource {
    private final RegionSslCertificatesSettings settings;
    private final RegionSslCertificatesStub stub;

    public static final RegionSslCertificatesClient create() throws IOException {
        return RegionSslCertificatesClient.create(RegionSslCertificatesSettings.newBuilder().build());
    }

    public static final RegionSslCertificatesClient create(RegionSslCertificatesSettings settings) throws IOException {
        return new RegionSslCertificatesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RegionSslCertificatesClient create(RegionSslCertificatesStub stub) {
        return new RegionSslCertificatesClient(stub);
    }

    protected RegionSslCertificatesClient(RegionSslCertificatesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionSslCertificatesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RegionSslCertificatesClient(RegionSslCertificatesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionSslCertificatesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RegionSslCertificatesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String sslCertificate) {
        DeleteRegionSslCertificateRequest request = DeleteRegionSslCertificateRequest.newBuilder().setProject(project).setRegion(region).setSslCertificate(sslCertificate).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionSslCertificateRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionSslCertificateRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionSslCertificateRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SslCertificate get(String project, String region, String sslCertificate) {
        GetRegionSslCertificateRequest request = GetRegionSslCertificateRequest.newBuilder().setProject(project).setRegion(region).setSslCertificate(sslCertificate).build();
        return this.get(request);
    }

    public final SslCertificate get(GetRegionSslCertificateRequest request) {
        return (SslCertificate)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionSslCertificateRequest, SslCertificate> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, SslCertificate sslCertificateResource) {
        InsertRegionSslCertificateRequest request = InsertRegionSslCertificateRequest.newBuilder().setProject(project).setRegion(region).setSslCertificateResource(sslCertificateResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionSslCertificateRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionSslCertificateRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionSslCertificateRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionSslCertificatesRequest request = ListRegionSslCertificatesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionSslCertificatesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionSslCertificatesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionSslCertificatesRequest, SslCertificateList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionSslCertificatesRequest, SslCertificateList, SslCertificate, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionSslCertificatesRequest, SslCertificateList, SslCertificate, ListPage> {
        private ListPage(PageContext<ListRegionSslCertificatesRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionSslCertificatesRequest, SslCertificateList, SslCertificate> context, SslCertificateList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionSslCertificatesRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionSslCertificatesRequest, SslCertificateList, SslCertificate, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionSslCertificatesRequest, SslCertificateList, SslCertificate> context, ApiFuture<SslCertificateList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

