/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.CancelInstanceGroupManagerResizeRequestRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupManagerResizeRequestRequest;
import com.google.cloud.compute.v1.GetInstanceGroupManagerResizeRequestRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupManagerResizeRequestRequest;
import com.google.cloud.compute.v1.InstanceGroupManagerResizeRequest;
import com.google.cloud.compute.v1.InstanceGroupManagerResizeRequestsListResponse;
import com.google.cloud.compute.v1.InstanceGroupManagerResizeRequestsSettings;
import com.google.cloud.compute.v1.ListInstanceGroupManagerResizeRequestsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.InstanceGroupManagerResizeRequestsStub;
import com.google.cloud.compute.v1.stub.InstanceGroupManagerResizeRequestsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InstanceGroupManagerResizeRequestsClient
implements BackgroundResource {
    private final InstanceGroupManagerResizeRequestsSettings settings;
    private final InstanceGroupManagerResizeRequestsStub stub;

    public static final InstanceGroupManagerResizeRequestsClient create() throws IOException {
        return InstanceGroupManagerResizeRequestsClient.create(InstanceGroupManagerResizeRequestsSettings.newBuilder().build());
    }

    public static final InstanceGroupManagerResizeRequestsClient create(InstanceGroupManagerResizeRequestsSettings settings) throws IOException {
        return new InstanceGroupManagerResizeRequestsClient(settings);
    }

    public static final InstanceGroupManagerResizeRequestsClient create(InstanceGroupManagerResizeRequestsStub stub) {
        return new InstanceGroupManagerResizeRequestsClient(stub);
    }

    protected InstanceGroupManagerResizeRequestsClient(InstanceGroupManagerResizeRequestsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceGroupManagerResizeRequestsStubSettings)settings.getStubSettings()).createStub();
    }

    protected InstanceGroupManagerResizeRequestsClient(InstanceGroupManagerResizeRequestsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final InstanceGroupManagerResizeRequestsSettings getSettings() {
        return this.settings;
    }

    public InstanceGroupManagerResizeRequestsStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> cancelAsync(String project, String zone, String instanceGroupManager, String resizeRequest) {
        CancelInstanceGroupManagerResizeRequestRequest request = CancelInstanceGroupManagerResizeRequestRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setResizeRequest(resizeRequest).build();
        return this.cancelAsync(request);
    }

    public final OperationFuture<Operation, Operation> cancelAsync(CancelInstanceGroupManagerResizeRequestRequest request) {
        return this.cancelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CancelInstanceGroupManagerResizeRequestRequest, Operation, Operation> cancelOperationCallable() {
        return this.stub.cancelOperationCallable();
    }

    public final UnaryCallable<CancelInstanceGroupManagerResizeRequestRequest, Operation> cancelCallable() {
        return this.stub.cancelCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String instanceGroupManager, String resizeRequest) {
        DeleteInstanceGroupManagerResizeRequestRequest request = DeleteInstanceGroupManagerResizeRequestRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setResizeRequest(resizeRequest).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteInstanceGroupManagerResizeRequestRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteInstanceGroupManagerResizeRequestRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteInstanceGroupManagerResizeRequestRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final InstanceGroupManagerResizeRequest get(String project, String zone, String instanceGroupManager, String resizeRequest) {
        GetInstanceGroupManagerResizeRequestRequest request = GetInstanceGroupManagerResizeRequestRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setResizeRequest(resizeRequest).build();
        return this.get(request);
    }

    public final InstanceGroupManagerResizeRequest get(GetInstanceGroupManagerResizeRequestRequest request) {
        return (InstanceGroupManagerResizeRequest)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceGroupManagerResizeRequestRequest, InstanceGroupManagerResizeRequest> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, String instanceGroupManager, InstanceGroupManagerResizeRequest instanceGroupManagerResizeRequestResource) {
        InsertInstanceGroupManagerResizeRequestRequest request = InsertInstanceGroupManagerResizeRequestRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).setInstanceGroupManagerResizeRequestResource(instanceGroupManagerResizeRequestResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertInstanceGroupManagerResizeRequestRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertInstanceGroupManagerResizeRequestRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertInstanceGroupManagerResizeRequestRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone, String instanceGroupManager) {
        ListInstanceGroupManagerResizeRequestsRequest request = ListInstanceGroupManagerResizeRequestsRequest.newBuilder().setProject(project).setZone(zone).setInstanceGroupManager(instanceGroupManager).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListInstanceGroupManagerResizeRequestsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceGroupManagerResizeRequestsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse, InstanceGroupManagerResizeRequest, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse, InstanceGroupManagerResizeRequest, ListPage> {
        private ListPage(PageContext<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse, InstanceGroupManagerResizeRequest> context, InstanceGroupManagerResizeRequestsListResponse response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse, InstanceGroupManagerResizeRequest> context, InstanceGroupManagerResizeRequestsListResponse response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse, InstanceGroupManagerResizeRequest> context, ApiFuture<InstanceGroupManagerResizeRequestsListResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse, InstanceGroupManagerResizeRequest, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListInstanceGroupManagerResizeRequestsRequest, InstanceGroupManagerResizeRequestsListResponse, InstanceGroupManagerResizeRequest> context, ApiFuture<InstanceGroupManagerResizeRequestsListResponse> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

