/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AbandonInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.AggregatedListInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ApplyUpdatesToInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.CreateInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeleteInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.DeletePerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.GetInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InsertInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.InstanceGroupManager;
import com.google.cloud.compute.v1.InstanceGroupManagerAggregatedList;
import com.google.cloud.compute.v1.InstanceGroupManagerList;
import com.google.cloud.compute.v1.InstanceGroupManagersClient;
import com.google.cloud.compute.v1.InstanceGroupManagersListErrorsResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersListManagedInstancesResponse;
import com.google.cloud.compute.v1.InstanceGroupManagersListPerInstanceConfigsResp;
import com.google.cloud.compute.v1.InstanceGroupManagersScopedList;
import com.google.cloud.compute.v1.InstanceManagedByIgmError;
import com.google.cloud.compute.v1.ListErrorsInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListManagedInstancesInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ListPerInstanceConfigsInstanceGroupManagersRequest;
import com.google.cloud.compute.v1.ManagedInstance;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PatchPerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.PerInstanceConfig;
import com.google.cloud.compute.v1.RecreateInstancesInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.ResizeInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetInstanceTemplateInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.SetTargetPoolsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.UpdatePerInstanceConfigsInstanceGroupManagerRequest;
import com.google.cloud.compute.v1.stub.HttpJsonInstanceGroupManagersStub;
import com.google.cloud.compute.v1.stub.InstanceGroupManagersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class InstanceGroupManagersStubSettings
extends StubSettings<InstanceGroupManagersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<AbandonInstancesInstanceGroupManagerRequest, Operation> abandonInstancesSettings;
    private final OperationCallSettings<AbandonInstancesInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings;
    private final PagedCallSettings<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings;
    private final OperationCallSettings<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings;
    private final UnaryCallSettings<CreateInstancesInstanceGroupManagerRequest, Operation> createInstancesSettings;
    private final OperationCallSettings<CreateInstancesInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings;
    private final UnaryCallSettings<DeleteInstanceGroupManagerRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<DeleteInstancesInstanceGroupManagerRequest, Operation> deleteInstancesSettings;
    private final OperationCallSettings<DeleteInstancesInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings;
    private final UnaryCallSettings<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings;
    private final OperationCallSettings<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings;
    private final UnaryCallSettings<GetInstanceGroupManagerRequest, InstanceGroupManager> getSettings;
    private final UnaryCallSettings<InsertInstanceGroupManagerRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManagersClient.ListPagedResponse> listSettings;
    private final PagedCallSettings<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings;
    private final PagedCallSettings<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, InstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings;
    private final PagedCallSettings<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings;
    private final UnaryCallSettings<PatchInstanceGroupManagerRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings;
    private final OperationCallSettings<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings;
    private final UnaryCallSettings<RecreateInstancesInstanceGroupManagerRequest, Operation> recreateInstancesSettings;
    private final OperationCallSettings<RecreateInstancesInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings;
    private final UnaryCallSettings<ResizeInstanceGroupManagerRequest, Operation> resizeSettings;
    private final OperationCallSettings<ResizeInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings;
    private final UnaryCallSettings<SetInstanceTemplateInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings;
    private final OperationCallSettings<SetInstanceTemplateInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings;
    private final UnaryCallSettings<SetTargetPoolsInstanceGroupManagerRequest, Operation> setTargetPoolsSettings;
    private final OperationCallSettings<SetTargetPoolsInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings;
    private final UnaryCallSettings<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings;
    private final OperationCallSettings<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings;
    private static final PagedListDescriptor<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListInstanceGroupManagersRequest injectToken(AggregatedListInstanceGroupManagersRequest payload, String token) {
            return AggregatedListInstanceGroupManagersRequest.newBuilder((AggregatedListInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public AggregatedListInstanceGroupManagersRequest injectPageSize(AggregatedListInstanceGroupManagersRequest payload, int pageSize) {
            return AggregatedListInstanceGroupManagersRequest.newBuilder((AggregatedListInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupManagerAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, InstanceGroupManagersScopedList>> extractResources(InstanceGroupManagerAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager>(){

        public String emptyToken() {
            return "";
        }

        public ListInstanceGroupManagersRequest injectToken(ListInstanceGroupManagersRequest payload, String token) {
            return ListInstanceGroupManagersRequest.newBuilder((ListInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListInstanceGroupManagersRequest injectPageSize(ListInstanceGroupManagersRequest payload, int pageSize) {
            return ListInstanceGroupManagersRequest.newBuilder((ListInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupManagerList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceGroupManager> extractResources(InstanceGroupManagerList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError> LIST_ERRORS_PAGE_STR_DESC = new PagedListDescriptor<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError>(){

        public String emptyToken() {
            return "";
        }

        public ListErrorsInstanceGroupManagersRequest injectToken(ListErrorsInstanceGroupManagersRequest payload, String token) {
            return ListErrorsInstanceGroupManagersRequest.newBuilder((ListErrorsInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListErrorsInstanceGroupManagersRequest injectPageSize(ListErrorsInstanceGroupManagersRequest payload, int pageSize) {
            return ListErrorsInstanceGroupManagersRequest.newBuilder((ListErrorsInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListErrorsInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupManagersListErrorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InstanceManagedByIgmError> extractResources(InstanceGroupManagersListErrorsResponse payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListDescriptor<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance> LIST_MANAGED_INSTANCES_PAGE_STR_DESC = new PagedListDescriptor<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance>(){

        public String emptyToken() {
            return "";
        }

        public ListManagedInstancesInstanceGroupManagersRequest injectToken(ListManagedInstancesInstanceGroupManagersRequest payload, String token) {
            return ListManagedInstancesInstanceGroupManagersRequest.newBuilder((ListManagedInstancesInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListManagedInstancesInstanceGroupManagersRequest injectPageSize(ListManagedInstancesInstanceGroupManagersRequest payload, int pageSize) {
            return ListManagedInstancesInstanceGroupManagersRequest.newBuilder((ListManagedInstancesInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListManagedInstancesInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupManagersListManagedInstancesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ManagedInstance> extractResources(InstanceGroupManagersListManagedInstancesResponse payload) {
            return payload.getManagedInstancesList() == null ? ImmutableList.of() : payload.getManagedInstancesList();
        }
    };
    private static final PagedListDescriptor<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig> LIST_PER_INSTANCE_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListPerInstanceConfigsInstanceGroupManagersRequest injectToken(ListPerInstanceConfigsInstanceGroupManagersRequest payload, String token) {
            return ListPerInstanceConfigsInstanceGroupManagersRequest.newBuilder((ListPerInstanceConfigsInstanceGroupManagersRequest)payload).setPageToken(token).build();
        }

        public ListPerInstanceConfigsInstanceGroupManagersRequest injectPageSize(ListPerInstanceConfigsInstanceGroupManagersRequest payload, int pageSize) {
            return ListPerInstanceConfigsInstanceGroupManagersRequest.newBuilder((ListPerInstanceConfigsInstanceGroupManagersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListPerInstanceConfigsInstanceGroupManagersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(InstanceGroupManagersListPerInstanceConfigsResp payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PerInstanceConfig> extractResources(InstanceGroupManagersListPerInstanceConfigsResp payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersClient.AggregatedListPagedResponse>(){

        public ApiFuture<InstanceGroupManagersClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList> callable, AggregatedListInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<InstanceGroupManagerAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupManagersClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, Map.Entry<String, InstanceGroupManagersScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManagersClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManagersClient.ListPagedResponse>(){

        public ApiFuture<InstanceGroupManagersClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListInstanceGroupManagersRequest, InstanceGroupManagerList> callable, ListInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<InstanceGroupManagerList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupManagersClient.ListPagedResponse.createAsync((PageContext<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManager>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceGroupManagersClient.ListErrorsPagedResponse> LIST_ERRORS_PAGE_STR_FACT = new PagedListResponseFactory<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceGroupManagersClient.ListErrorsPagedResponse>(){

        public ApiFuture<InstanceGroupManagersClient.ListErrorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse> callable, ListErrorsInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<InstanceGroupManagersListErrorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ERRORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupManagersClient.ListErrorsPagedResponse.createAsync((PageContext<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceManagedByIgmError>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, InstanceGroupManagersClient.ListManagedInstancesPagedResponse> LIST_MANAGED_INSTANCES_PAGE_STR_FACT = new PagedListResponseFactory<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, InstanceGroupManagersClient.ListManagedInstancesPagedResponse>(){

        public ApiFuture<InstanceGroupManagersClient.ListManagedInstancesPagedResponse> getFuturePagedResponse(UnaryCallable<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse> callable, ListManagedInstancesInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<InstanceGroupManagersListManagedInstancesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_MANAGED_INSTANCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupManagersClient.ListManagedInstancesPagedResponse.createAsync((PageContext<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, ManagedInstance>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> LIST_PER_INSTANCE_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse>(){

        public ApiFuture<InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp> callable, ListPerInstanceConfigsInstanceGroupManagersRequest request, ApiCallContext context, ApiFuture<InstanceGroupManagersListPerInstanceConfigsResp> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PER_INSTANCE_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse.createAsync((PageContext<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, PerInstanceConfig>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<AbandonInstancesInstanceGroupManagerRequest, Operation> abandonInstancesSettings() {
        return this.abandonInstancesSettings;
    }

    public OperationCallSettings<AbandonInstancesInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings() {
        return this.abandonInstancesOperationSettings;
    }

    public PagedCallSettings<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings() {
        return this.applyUpdatesToInstancesSettings;
    }

    public OperationCallSettings<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings() {
        return this.applyUpdatesToInstancesOperationSettings;
    }

    public UnaryCallSettings<CreateInstancesInstanceGroupManagerRequest, Operation> createInstancesSettings() {
        return this.createInstancesSettings;
    }

    public OperationCallSettings<CreateInstancesInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings() {
        return this.createInstancesOperationSettings;
    }

    public UnaryCallSettings<DeleteInstanceGroupManagerRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<DeleteInstancesInstanceGroupManagerRequest, Operation> deleteInstancesSettings() {
        return this.deleteInstancesSettings;
    }

    public OperationCallSettings<DeleteInstancesInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings() {
        return this.deleteInstancesOperationSettings;
    }

    public UnaryCallSettings<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings() {
        return this.deletePerInstanceConfigsSettings;
    }

    public OperationCallSettings<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings() {
        return this.deletePerInstanceConfigsOperationSettings;
    }

    public UnaryCallSettings<GetInstanceGroupManagerRequest, InstanceGroupManager> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertInstanceGroupManagerRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManagersClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public PagedCallSettings<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings() {
        return this.listErrorsSettings;
    }

    public PagedCallSettings<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, InstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings() {
        return this.listManagedInstancesSettings;
    }

    public PagedCallSettings<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings() {
        return this.listPerInstanceConfigsSettings;
    }

    public UnaryCallSettings<PatchInstanceGroupManagerRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings() {
        return this.patchPerInstanceConfigsSettings;
    }

    public OperationCallSettings<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings() {
        return this.patchPerInstanceConfigsOperationSettings;
    }

    public UnaryCallSettings<RecreateInstancesInstanceGroupManagerRequest, Operation> recreateInstancesSettings() {
        return this.recreateInstancesSettings;
    }

    public OperationCallSettings<RecreateInstancesInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings() {
        return this.recreateInstancesOperationSettings;
    }

    public UnaryCallSettings<ResizeInstanceGroupManagerRequest, Operation> resizeSettings() {
        return this.resizeSettings;
    }

    public OperationCallSettings<ResizeInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings() {
        return this.resizeOperationSettings;
    }

    public UnaryCallSettings<SetInstanceTemplateInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings() {
        return this.setInstanceTemplateSettings;
    }

    public OperationCallSettings<SetInstanceTemplateInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings() {
        return this.setInstanceTemplateOperationSettings;
    }

    public UnaryCallSettings<SetTargetPoolsInstanceGroupManagerRequest, Operation> setTargetPoolsSettings() {
        return this.setTargetPoolsSettings;
    }

    public OperationCallSettings<SetTargetPoolsInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings() {
        return this.setTargetPoolsOperationSettings;
    }

    public UnaryCallSettings<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings() {
        return this.updatePerInstanceConfigsSettings;
    }

    public OperationCallSettings<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings() {
        return this.updatePerInstanceConfigsOperationSettings;
    }

    public InstanceGroupManagersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInstanceGroupManagersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InstanceGroupManagersStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InstanceGroupManagersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InstanceGroupManagersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.abandonInstancesSettings = settingsBuilder.abandonInstancesSettings().build();
        this.abandonInstancesOperationSettings = settingsBuilder.abandonInstancesOperationSettings().build();
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.applyUpdatesToInstancesSettings = settingsBuilder.applyUpdatesToInstancesSettings().build();
        this.applyUpdatesToInstancesOperationSettings = settingsBuilder.applyUpdatesToInstancesOperationSettings().build();
        this.createInstancesSettings = settingsBuilder.createInstancesSettings().build();
        this.createInstancesOperationSettings = settingsBuilder.createInstancesOperationSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.deleteInstancesSettings = settingsBuilder.deleteInstancesSettings().build();
        this.deleteInstancesOperationSettings = settingsBuilder.deleteInstancesOperationSettings().build();
        this.deletePerInstanceConfigsSettings = settingsBuilder.deletePerInstanceConfigsSettings().build();
        this.deletePerInstanceConfigsOperationSettings = settingsBuilder.deletePerInstanceConfigsOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.listErrorsSettings = settingsBuilder.listErrorsSettings().build();
        this.listManagedInstancesSettings = settingsBuilder.listManagedInstancesSettings().build();
        this.listPerInstanceConfigsSettings = settingsBuilder.listPerInstanceConfigsSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.patchPerInstanceConfigsSettings = settingsBuilder.patchPerInstanceConfigsSettings().build();
        this.patchPerInstanceConfigsOperationSettings = settingsBuilder.patchPerInstanceConfigsOperationSettings().build();
        this.recreateInstancesSettings = settingsBuilder.recreateInstancesSettings().build();
        this.recreateInstancesOperationSettings = settingsBuilder.recreateInstancesOperationSettings().build();
        this.resizeSettings = settingsBuilder.resizeSettings().build();
        this.resizeOperationSettings = settingsBuilder.resizeOperationSettings().build();
        this.setInstanceTemplateSettings = settingsBuilder.setInstanceTemplateSettings().build();
        this.setInstanceTemplateOperationSettings = settingsBuilder.setInstanceTemplateOperationSettings().build();
        this.setTargetPoolsSettings = settingsBuilder.setTargetPoolsSettings().build();
        this.setTargetPoolsOperationSettings = settingsBuilder.setTargetPoolsOperationSettings().build();
        this.updatePerInstanceConfigsSettings = settingsBuilder.updatePerInstanceConfigsSettings().build();
        this.updatePerInstanceConfigsOperationSettings = settingsBuilder.updatePerInstanceConfigsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InstanceGroupManagersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<AbandonInstancesInstanceGroupManagerRequest, Operation> abandonInstancesSettings;
        private final OperationCallSettings.Builder<AbandonInstancesInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings;
        private final PagedCallSettings.Builder<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings;
        private final OperationCallSettings.Builder<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings;
        private final UnaryCallSettings.Builder<CreateInstancesInstanceGroupManagerRequest, Operation> createInstancesSettings;
        private final OperationCallSettings.Builder<CreateInstancesInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstanceGroupManagerRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInstancesInstanceGroupManagerRequest, Operation> deleteInstancesSettings;
        private final OperationCallSettings.Builder<DeleteInstancesInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings;
        private final UnaryCallSettings.Builder<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings;
        private final OperationCallSettings.Builder<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings;
        private final UnaryCallSettings.Builder<GetInstanceGroupManagerRequest, InstanceGroupManager> getSettings;
        private final UnaryCallSettings.Builder<InsertInstanceGroupManagerRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManagersClient.ListPagedResponse> listSettings;
        private final PagedCallSettings.Builder<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings;
        private final PagedCallSettings.Builder<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, InstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings;
        private final PagedCallSettings.Builder<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings;
        private final UnaryCallSettings.Builder<PatchInstanceGroupManagerRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings;
        private final OperationCallSettings.Builder<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings;
        private final UnaryCallSettings.Builder<RecreateInstancesInstanceGroupManagerRequest, Operation> recreateInstancesSettings;
        private final OperationCallSettings.Builder<RecreateInstancesInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings;
        private final UnaryCallSettings.Builder<ResizeInstanceGroupManagerRequest, Operation> resizeSettings;
        private final OperationCallSettings.Builder<ResizeInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings;
        private final UnaryCallSettings.Builder<SetInstanceTemplateInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings;
        private final OperationCallSettings.Builder<SetInstanceTemplateInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings;
        private final UnaryCallSettings.Builder<SetTargetPoolsInstanceGroupManagerRequest, Operation> setTargetPoolsSettings;
        private final OperationCallSettings.Builder<SetTargetPoolsInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings;
        private final UnaryCallSettings.Builder<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings;
        private final OperationCallSettings.Builder<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.abandonInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.abandonInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.applyUpdatesToInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.applyUpdatesToInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.createInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.deletePerInstanceConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deletePerInstanceConfigsOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.listErrorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ERRORS_PAGE_STR_FACT);
            this.listManagedInstancesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_MANAGED_INSTANCES_PAGE_STR_FACT);
            this.listPerInstanceConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PER_INSTANCE_CONFIGS_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.patchPerInstanceConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchPerInstanceConfigsOperationSettings = OperationCallSettings.newBuilder();
            this.recreateInstancesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.recreateInstancesOperationSettings = OperationCallSettings.newBuilder();
            this.resizeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.resizeOperationSettings = OperationCallSettings.newBuilder();
            this.setInstanceTemplateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setInstanceTemplateOperationSettings = OperationCallSettings.newBuilder();
            this.setTargetPoolsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setTargetPoolsOperationSettings = OperationCallSettings.newBuilder();
            this.updatePerInstanceConfigsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePerInstanceConfigsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.abandonInstancesSettings, this.aggregatedListSettings, this.applyUpdatesToInstancesSettings, this.createInstancesSettings, this.deleteSettings, this.deleteInstancesSettings, this.deletePerInstanceConfigsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listErrorsSettings, this.listManagedInstancesSettings, (Object[])new UnaryCallSettings.Builder[]{this.listPerInstanceConfigsSettings, this.patchSettings, this.patchPerInstanceConfigsSettings, this.recreateInstancesSettings, this.resizeSettings, this.setInstanceTemplateSettings, this.setTargetPoolsSettings, this.updatePerInstanceConfigsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(InstanceGroupManagersStubSettings settings) {
            super((StubSettings)settings);
            this.abandonInstancesSettings = settings.abandonInstancesSettings.toBuilder();
            this.abandonInstancesOperationSettings = settings.abandonInstancesOperationSettings.toBuilder();
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.applyUpdatesToInstancesSettings = settings.applyUpdatesToInstancesSettings.toBuilder();
            this.applyUpdatesToInstancesOperationSettings = settings.applyUpdatesToInstancesOperationSettings.toBuilder();
            this.createInstancesSettings = settings.createInstancesSettings.toBuilder();
            this.createInstancesOperationSettings = settings.createInstancesOperationSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.deleteInstancesSettings = settings.deleteInstancesSettings.toBuilder();
            this.deleteInstancesOperationSettings = settings.deleteInstancesOperationSettings.toBuilder();
            this.deletePerInstanceConfigsSettings = settings.deletePerInstanceConfigsSettings.toBuilder();
            this.deletePerInstanceConfigsOperationSettings = settings.deletePerInstanceConfigsOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.listErrorsSettings = settings.listErrorsSettings.toBuilder();
            this.listManagedInstancesSettings = settings.listManagedInstancesSettings.toBuilder();
            this.listPerInstanceConfigsSettings = settings.listPerInstanceConfigsSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.patchPerInstanceConfigsSettings = settings.patchPerInstanceConfigsSettings.toBuilder();
            this.patchPerInstanceConfigsOperationSettings = settings.patchPerInstanceConfigsOperationSettings.toBuilder();
            this.recreateInstancesSettings = settings.recreateInstancesSettings.toBuilder();
            this.recreateInstancesOperationSettings = settings.recreateInstancesOperationSettings.toBuilder();
            this.resizeSettings = settings.resizeSettings.toBuilder();
            this.resizeOperationSettings = settings.resizeOperationSettings.toBuilder();
            this.setInstanceTemplateSettings = settings.setInstanceTemplateSettings.toBuilder();
            this.setInstanceTemplateOperationSettings = settings.setInstanceTemplateOperationSettings.toBuilder();
            this.setTargetPoolsSettings = settings.setTargetPoolsSettings.toBuilder();
            this.setTargetPoolsOperationSettings = settings.setTargetPoolsOperationSettings.toBuilder();
            this.updatePerInstanceConfigsSettings = settings.updatePerInstanceConfigsSettings.toBuilder();
            this.updatePerInstanceConfigsOperationSettings = settings.updatePerInstanceConfigsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.abandonInstancesSettings, this.aggregatedListSettings, this.applyUpdatesToInstancesSettings, this.createInstancesSettings, this.deleteSettings, this.deleteInstancesSettings, this.deletePerInstanceConfigsSettings, this.getSettings, this.insertSettings, this.listSettings, this.listErrorsSettings, this.listManagedInstancesSettings, (Object[])new UnaryCallSettings.Builder[]{this.listPerInstanceConfigsSettings, this.patchSettings, this.patchPerInstanceConfigsSettings, this.recreateInstancesSettings, this.resizeSettings, this.setInstanceTemplateSettings, this.setTargetPoolsSettings, this.updatePerInstanceConfigsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InstanceGroupManagersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InstanceGroupManagersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InstanceGroupManagersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(InstanceGroupManagersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.abandonInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.applyUpdatesToInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deletePerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listErrorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listManagedInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listPerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.patchPerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.recreateInstancesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.resizeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setInstanceTemplateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setTargetPoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updatePerInstanceConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.abandonInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.applyUpdatesToInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.createInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deleteInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.deletePerInstanceConfigsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchPerInstanceConfigsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.recreateInstancesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.resizeOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setInstanceTemplateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.setTargetPoolsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updatePerInstanceConfigsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<AbandonInstancesInstanceGroupManagerRequest, Operation> abandonInstancesSettings() {
            return this.abandonInstancesSettings;
        }

        public OperationCallSettings.Builder<AbandonInstancesInstanceGroupManagerRequest, Operation, Operation> abandonInstancesOperationSettings() {
            return this.abandonInstancesOperationSettings;
        }

        public PagedCallSettings.Builder<AggregatedListInstanceGroupManagersRequest, InstanceGroupManagerAggregatedList, InstanceGroupManagersClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation> applyUpdatesToInstancesSettings() {
            return this.applyUpdatesToInstancesSettings;
        }

        public OperationCallSettings.Builder<ApplyUpdatesToInstancesInstanceGroupManagerRequest, Operation, Operation> applyUpdatesToInstancesOperationSettings() {
            return this.applyUpdatesToInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateInstancesInstanceGroupManagerRequest, Operation> createInstancesSettings() {
            return this.createInstancesSettings;
        }

        public OperationCallSettings.Builder<CreateInstancesInstanceGroupManagerRequest, Operation, Operation> createInstancesOperationSettings() {
            return this.createInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstanceGroupManagerRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteInstanceGroupManagerRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInstancesInstanceGroupManagerRequest, Operation> deleteInstancesSettings() {
            return this.deleteInstancesSettings;
        }

        public OperationCallSettings.Builder<DeleteInstancesInstanceGroupManagerRequest, Operation, Operation> deleteInstancesOperationSettings() {
            return this.deleteInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation> deletePerInstanceConfigsSettings() {
            return this.deletePerInstanceConfigsSettings;
        }

        public OperationCallSettings.Builder<DeletePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> deletePerInstanceConfigsOperationSettings() {
            return this.deletePerInstanceConfigsOperationSettings;
        }

        public UnaryCallSettings.Builder<GetInstanceGroupManagerRequest, InstanceGroupManager> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertInstanceGroupManagerRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertInstanceGroupManagerRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListInstanceGroupManagersRequest, InstanceGroupManagerList, InstanceGroupManagersClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public PagedCallSettings.Builder<ListErrorsInstanceGroupManagersRequest, InstanceGroupManagersListErrorsResponse, InstanceGroupManagersClient.ListErrorsPagedResponse> listErrorsSettings() {
            return this.listErrorsSettings;
        }

        public PagedCallSettings.Builder<ListManagedInstancesInstanceGroupManagersRequest, InstanceGroupManagersListManagedInstancesResponse, InstanceGroupManagersClient.ListManagedInstancesPagedResponse> listManagedInstancesSettings() {
            return this.listManagedInstancesSettings;
        }

        public PagedCallSettings.Builder<ListPerInstanceConfigsInstanceGroupManagersRequest, InstanceGroupManagersListPerInstanceConfigsResp, InstanceGroupManagersClient.ListPerInstanceConfigsPagedResponse> listPerInstanceConfigsSettings() {
            return this.listPerInstanceConfigsSettings;
        }

        public UnaryCallSettings.Builder<PatchInstanceGroupManagerRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchInstanceGroupManagerRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation> patchPerInstanceConfigsSettings() {
            return this.patchPerInstanceConfigsSettings;
        }

        public OperationCallSettings.Builder<PatchPerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> patchPerInstanceConfigsOperationSettings() {
            return this.patchPerInstanceConfigsOperationSettings;
        }

        public UnaryCallSettings.Builder<RecreateInstancesInstanceGroupManagerRequest, Operation> recreateInstancesSettings() {
            return this.recreateInstancesSettings;
        }

        public OperationCallSettings.Builder<RecreateInstancesInstanceGroupManagerRequest, Operation, Operation> recreateInstancesOperationSettings() {
            return this.recreateInstancesOperationSettings;
        }

        public UnaryCallSettings.Builder<ResizeInstanceGroupManagerRequest, Operation> resizeSettings() {
            return this.resizeSettings;
        }

        public OperationCallSettings.Builder<ResizeInstanceGroupManagerRequest, Operation, Operation> resizeOperationSettings() {
            return this.resizeOperationSettings;
        }

        public UnaryCallSettings.Builder<SetInstanceTemplateInstanceGroupManagerRequest, Operation> setInstanceTemplateSettings() {
            return this.setInstanceTemplateSettings;
        }

        public OperationCallSettings.Builder<SetInstanceTemplateInstanceGroupManagerRequest, Operation, Operation> setInstanceTemplateOperationSettings() {
            return this.setInstanceTemplateOperationSettings;
        }

        public UnaryCallSettings.Builder<SetTargetPoolsInstanceGroupManagerRequest, Operation> setTargetPoolsSettings() {
            return this.setTargetPoolsSettings;
        }

        public OperationCallSettings.Builder<SetTargetPoolsInstanceGroupManagerRequest, Operation, Operation> setTargetPoolsOperationSettings() {
            return this.setTargetPoolsOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation> updatePerInstanceConfigsSettings() {
            return this.updatePerInstanceConfigsSettings;
        }

        public OperationCallSettings.Builder<UpdatePerInstanceConfigsInstanceGroupManagerRequest, Operation, Operation> updatePerInstanceConfigsOperationSettings() {
            return this.updatePerInstanceConfigsOperationSettings;
        }

        public InstanceGroupManagersStubSettings build() throws IOException {
            return new InstanceGroupManagersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

