/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.BackendService;
import com.google.cloud.compute.v1.BackendServiceGroupHealth;
import com.google.cloud.compute.v1.BackendServiceList;
import com.google.cloud.compute.v1.BackendServiceListUsable;
import com.google.cloud.compute.v1.DeleteRegionBackendServiceRequest;
import com.google.cloud.compute.v1.GetHealthRegionBackendServiceRequest;
import com.google.cloud.compute.v1.GetIamPolicyRegionBackendServiceRequest;
import com.google.cloud.compute.v1.GetRegionBackendServiceRequest;
import com.google.cloud.compute.v1.InsertRegionBackendServiceRequest;
import com.google.cloud.compute.v1.ListRegionBackendServicesRequest;
import com.google.cloud.compute.v1.ListUsableRegionBackendServicesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionBackendServiceRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RegionBackendServicesSettings;
import com.google.cloud.compute.v1.RegionSetPolicyRequest;
import com.google.cloud.compute.v1.ResourceGroupReference;
import com.google.cloud.compute.v1.SecurityPolicyReference;
import com.google.cloud.compute.v1.SetIamPolicyRegionBackendServiceRequest;
import com.google.cloud.compute.v1.SetSecurityPolicyRegionBackendServiceRequest;
import com.google.cloud.compute.v1.TestIamPermissionsRegionBackendServiceRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateRegionBackendServiceRequest;
import com.google.cloud.compute.v1.stub.RegionBackendServicesStub;
import com.google.cloud.compute.v1.stub.RegionBackendServicesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionBackendServicesClient
implements BackgroundResource {
    private final RegionBackendServicesSettings settings;
    private final RegionBackendServicesStub stub;

    public static final RegionBackendServicesClient create() throws IOException {
        return RegionBackendServicesClient.create(RegionBackendServicesSettings.newBuilder().build());
    }

    public static final RegionBackendServicesClient create(RegionBackendServicesSettings settings) throws IOException {
        return new RegionBackendServicesClient(settings);
    }

    public static final RegionBackendServicesClient create(RegionBackendServicesStub stub) {
        return new RegionBackendServicesClient(stub);
    }

    protected RegionBackendServicesClient(RegionBackendServicesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionBackendServicesStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionBackendServicesClient(RegionBackendServicesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionBackendServicesSettings getSettings() {
        return this.settings;
    }

    public RegionBackendServicesStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String backendService) {
        DeleteRegionBackendServiceRequest request = DeleteRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).build();
        return this.deleteAsync(request);
    }

    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionBackendServiceRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionBackendServiceRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionBackendServiceRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final BackendService get(String project, String region, String backendService) {
        GetRegionBackendServiceRequest request = GetRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).build();
        return this.get(request);
    }

    public final BackendService get(GetRegionBackendServiceRequest request) {
        return (BackendService)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionBackendServiceRequest, BackendService> getCallable() {
        return this.stub.getCallable();
    }

    public final BackendServiceGroupHealth getHealth(String project, String region, String backendService, ResourceGroupReference resourceGroupReferenceResource) {
        GetHealthRegionBackendServiceRequest request = GetHealthRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).setResourceGroupReferenceResource(resourceGroupReferenceResource).build();
        return this.getHealth(request);
    }

    public final BackendServiceGroupHealth getHealth(GetHealthRegionBackendServiceRequest request) {
        return (BackendServiceGroupHealth)this.getHealthCallable().call((Object)request);
    }

    public final UnaryCallable<GetHealthRegionBackendServiceRequest, BackendServiceGroupHealth> getHealthCallable() {
        return this.stub.getHealthCallable();
    }

    public final Policy getIamPolicy(String project, String region, String resource) {
        GetIamPolicyRegionBackendServiceRequest request = GetIamPolicyRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRegionBackendServiceRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRegionBackendServiceRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, BackendService backendServiceResource) {
        InsertRegionBackendServiceRequest request = InsertRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendServiceResource(backendServiceResource).build();
        return this.insertAsync(request);
    }

    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionBackendServiceRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionBackendServiceRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionBackendServiceRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionBackendServicesRequest request = ListRegionBackendServicesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionBackendServicesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionBackendServicesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionBackendServicesRequest, BackendServiceList> listCallable() {
        return this.stub.listCallable();
    }

    public final ListUsablePagedResponse listUsable(String project, String region) {
        ListUsableRegionBackendServicesRequest request = ListUsableRegionBackendServicesRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.listUsable(request);
    }

    public final ListUsablePagedResponse listUsable(ListUsableRegionBackendServicesRequest request) {
        return (ListUsablePagedResponse)((Object)this.listUsablePagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListUsableRegionBackendServicesRequest, ListUsablePagedResponse> listUsablePagedCallable() {
        return this.stub.listUsablePagedCallable();
    }

    public final UnaryCallable<ListUsableRegionBackendServicesRequest, BackendServiceListUsable> listUsableCallable() {
        return this.stub.listUsableCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, String backendService, BackendService backendServiceResource) {
        PatchRegionBackendServiceRequest request = PatchRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.patchAsync(request);
    }

    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionBackendServiceRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionBackendServiceRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionBackendServiceRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Policy setIamPolicy(String project, String region, String resource, RegionSetPolicyRequest regionSetPolicyRequestResource) {
        SetIamPolicyRegionBackendServiceRequest request = SetIamPolicyRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setRegionSetPolicyRequestResource(regionSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRegionBackendServiceRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRegionBackendServiceRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> setSecurityPolicyAsync(String project, String region, String backendService, SecurityPolicyReference securityPolicyReferenceResource) {
        SetSecurityPolicyRegionBackendServiceRequest request = SetSecurityPolicyRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).setSecurityPolicyReferenceResource(securityPolicyReferenceResource).build();
        return this.setSecurityPolicyAsync(request);
    }

    public final OperationFuture<Operation, Operation> setSecurityPolicyAsync(SetSecurityPolicyRegionBackendServiceRequest request) {
        return this.setSecurityPolicyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetSecurityPolicyRegionBackendServiceRequest, Operation, Operation> setSecurityPolicyOperationCallable() {
        return this.stub.setSecurityPolicyOperationCallable();
    }

    public final UnaryCallable<SetSecurityPolicyRegionBackendServiceRequest, Operation> setSecurityPolicyCallable() {
        return this.stub.setSecurityPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsRegionBackendServiceRequest request = TestIamPermissionsRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsRegionBackendServiceRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRegionBackendServiceRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String region, String backendService, BackendService backendServiceResource) {
        UpdateRegionBackendServiceRequest request = UpdateRegionBackendServiceRequest.newBuilder().setProject(project).setRegion(region).setBackendService(backendService).setBackendServiceResource(backendServiceResource).build();
        return this.updateAsync(request);
    }

    public final OperationFuture<Operation, Operation> updateAsync(UpdateRegionBackendServiceRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRegionBackendServiceRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateRegionBackendServiceRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListUsableFixedSizeCollection
    extends AbstractFixedSizeCollection<ListUsableRegionBackendServicesRequest, BackendServiceListUsable, BackendService, ListUsablePage, ListUsableFixedSizeCollection> {
        private ListUsableFixedSizeCollection(List<ListUsablePage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListUsableFixedSizeCollection createEmptyCollection() {
            return new ListUsableFixedSizeCollection(null, 0);
        }

        protected ListUsableFixedSizeCollection createCollection(List<ListUsablePage> pages, int collectionSize) {
            return new ListUsableFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListUsablePage
    extends AbstractPage<ListUsableRegionBackendServicesRequest, BackendServiceListUsable, BackendService, ListUsablePage> {
        private ListUsablePage(PageContext<ListUsableRegionBackendServicesRequest, BackendServiceListUsable, BackendService> context, BackendServiceListUsable response) {
            super(context, (Object)response);
        }

        private static ListUsablePage createEmptyPage() {
            return new ListUsablePage(null, null);
        }

        protected ListUsablePage createPage(PageContext<ListUsableRegionBackendServicesRequest, BackendServiceListUsable, BackendService> context, BackendServiceListUsable response) {
            return new ListUsablePage(context, response);
        }

        public ApiFuture<ListUsablePage> createPageAsync(PageContext<ListUsableRegionBackendServicesRequest, BackendServiceListUsable, BackendService> context, ApiFuture<BackendServiceListUsable> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListUsablePagedResponse
    extends AbstractPagedListResponse<ListUsableRegionBackendServicesRequest, BackendServiceListUsable, BackendService, ListUsablePage, ListUsableFixedSizeCollection> {
        public static ApiFuture<ListUsablePagedResponse> createAsync(PageContext<ListUsableRegionBackendServicesRequest, BackendServiceListUsable, BackendService> context, ApiFuture<BackendServiceListUsable> futureResponse) {
            ApiFuture<ListUsablePage> futurePage = ListUsablePage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListUsablePagedResponse((ListUsablePage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListUsablePagedResponse(ListUsablePage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListUsableFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionBackendServicesRequest, BackendServiceList, BackendService, ListPage> {
        private ListPage(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, BackendServiceList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionBackendServicesRequest, BackendServiceList, BackendService, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionBackendServicesRequest, BackendServiceList, BackendService> context, ApiFuture<BackendServiceList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

