/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.httpjson.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListAutoscalersRequest;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.AutoscalerAggregatedList;
import com.google.cloud.compute.v1.AutoscalerList;
import com.google.cloud.compute.v1.AutoscalersClient;
import com.google.cloud.compute.v1.AutoscalersScopedList;
import com.google.cloud.compute.v1.DeleteAutoscalerRequest;
import com.google.cloud.compute.v1.GetAutoscalerRequest;
import com.google.cloud.compute.v1.InsertAutoscalerRequest;
import com.google.cloud.compute.v1.ListAutoscalersRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchAutoscalerRequest;
import com.google.cloud.compute.v1.UpdateAutoscalerRequest;
import com.google.cloud.compute.v1.stub.AutoscalersStub;
import com.google.cloud.compute.v1.stub.HttpJsonAutoscalersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class AutoscalersStubSettings
extends StubSettings<AutoscalersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, AutoscalersClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<DeleteAutoscalerRequest, Operation> deleteSettings;
    private final OperationCallSettings<DeleteAutoscalerRequest, Operation, Operation> deleteOperationSettings;
    private final UnaryCallSettings<GetAutoscalerRequest, Autoscaler> getSettings;
    private final UnaryCallSettings<InsertAutoscalerRequest, Operation> insertSettings;
    private final OperationCallSettings<InsertAutoscalerRequest, Operation, Operation> insertOperationSettings;
    private final PagedCallSettings<ListAutoscalersRequest, AutoscalerList, AutoscalersClient.ListPagedResponse> listSettings;
    private final UnaryCallSettings<PatchAutoscalerRequest, Operation> patchSettings;
    private final OperationCallSettings<PatchAutoscalerRequest, Operation, Operation> patchOperationSettings;
    private final UnaryCallSettings<UpdateAutoscalerRequest, Operation> updateSettings;
    private final OperationCallSettings<UpdateAutoscalerRequest, Operation, Operation> updateOperationSettings;
    private static final PagedListDescriptor<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListAutoscalersRequest injectToken(AggregatedListAutoscalersRequest payload, String token) {
            return AggregatedListAutoscalersRequest.newBuilder((AggregatedListAutoscalersRequest)payload).setPageToken(token).build();
        }

        public AggregatedListAutoscalersRequest injectPageSize(AggregatedListAutoscalersRequest payload, int pageSize) {
            return AggregatedListAutoscalersRequest.newBuilder((AggregatedListAutoscalersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListAutoscalersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AutoscalerAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, AutoscalersScopedList>> extractResources(AutoscalerAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListAutoscalersRequest, AutoscalerList, Autoscaler> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListAutoscalersRequest, AutoscalerList, Autoscaler>(){

        public String emptyToken() {
            return "";
        }

        public ListAutoscalersRequest injectToken(ListAutoscalersRequest payload, String token) {
            return ListAutoscalersRequest.newBuilder((ListAutoscalersRequest)payload).setPageToken(token).build();
        }

        public ListAutoscalersRequest injectPageSize(ListAutoscalersRequest payload, int pageSize) {
            return ListAutoscalersRequest.newBuilder((ListAutoscalersRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListAutoscalersRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(AutoscalerList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Autoscaler> extractResources(AutoscalerList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, AutoscalersClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, AutoscalersClient.AggregatedListPagedResponse>(){

        public ApiFuture<AutoscalersClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListAutoscalersRequest, AutoscalerAggregatedList> callable, AggregatedListAutoscalersRequest request, ApiCallContext context, ApiFuture<AutoscalerAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoscalersClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAutoscalersRequest, AutoscalerList, AutoscalersClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListAutoscalersRequest, AutoscalerList, AutoscalersClient.ListPagedResponse>(){

        public ApiFuture<AutoscalersClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListAutoscalersRequest, AutoscalerList> callable, ListAutoscalersRequest request, ApiCallContext context, ApiFuture<AutoscalerList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AutoscalersClient.ListPagedResponse.createAsync((PageContext<ListAutoscalersRequest, AutoscalerList, Autoscaler>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, AutoscalersClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<DeleteAutoscalerRequest, Operation> deleteSettings() {
        return this.deleteSettings;
    }

    public OperationCallSettings<DeleteAutoscalerRequest, Operation, Operation> deleteOperationSettings() {
        return this.deleteOperationSettings;
    }

    public UnaryCallSettings<GetAutoscalerRequest, Autoscaler> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<InsertAutoscalerRequest, Operation> insertSettings() {
        return this.insertSettings;
    }

    public OperationCallSettings<InsertAutoscalerRequest, Operation, Operation> insertOperationSettings() {
        return this.insertOperationSettings;
    }

    public PagedCallSettings<ListAutoscalersRequest, AutoscalerList, AutoscalersClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    public UnaryCallSettings<PatchAutoscalerRequest, Operation> patchSettings() {
        return this.patchSettings;
    }

    public OperationCallSettings<PatchAutoscalerRequest, Operation, Operation> patchOperationSettings() {
        return this.patchOperationSettings;
    }

    public UnaryCallSettings<UpdateAutoscalerRequest, Operation> updateSettings() {
        return this.updateSettings;
    }

    public OperationCallSettings<UpdateAutoscalerRequest, Operation, Operation> updateOperationSettings() {
        return this.updateOperationSettings;
    }

    public AutoscalersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAutoscalersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return AutoscalersStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "compute";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AutoscalersStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AutoscalersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AutoscalersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.deleteSettings = settingsBuilder.deleteSettings().build();
        this.deleteOperationSettings = settingsBuilder.deleteOperationSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.insertSettings = settingsBuilder.insertSettings().build();
        this.insertOperationSettings = settingsBuilder.insertOperationSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
        this.patchSettings = settingsBuilder.patchSettings().build();
        this.patchOperationSettings = settingsBuilder.patchOperationSettings().build();
        this.updateSettings = settingsBuilder.updateSettings().build();
        this.updateOperationSettings = settingsBuilder.updateOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AutoscalersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, AutoscalersClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<DeleteAutoscalerRequest, Operation> deleteSettings;
        private final OperationCallSettings.Builder<DeleteAutoscalerRequest, Operation, Operation> deleteOperationSettings;
        private final UnaryCallSettings.Builder<GetAutoscalerRequest, Autoscaler> getSettings;
        private final UnaryCallSettings.Builder<InsertAutoscalerRequest, Operation> insertSettings;
        private final OperationCallSettings.Builder<InsertAutoscalerRequest, Operation, Operation> insertOperationSettings;
        private final PagedCallSettings.Builder<ListAutoscalersRequest, AutoscalerList, AutoscalersClient.ListPagedResponse> listSettings;
        private final UnaryCallSettings.Builder<PatchAutoscalerRequest, Operation> patchSettings;
        private final OperationCallSettings.Builder<PatchAutoscalerRequest, Operation, Operation> patchOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAutoscalerRequest, Operation> updateSettings;
        private final OperationCallSettings.Builder<UpdateAutoscalerRequest, Operation, Operation> updateOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.deleteSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteOperationSettings = OperationCallSettings.newBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertOperationSettings = OperationCallSettings.newBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.patchSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.patchOperationSettings = OperationCallSettings.newBuilder();
            this.updateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.updateSettings);
            Builder.initDefaults(this);
        }

        protected Builder(AutoscalersStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.deleteSettings = settings.deleteSettings.toBuilder();
            this.deleteOperationSettings = settings.deleteOperationSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.insertSettings = settings.insertSettings.toBuilder();
            this.insertOperationSettings = settings.insertOperationSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.patchSettings = settings.patchSettings.toBuilder();
            this.patchOperationSettings = settings.patchOperationSettings.toBuilder();
            this.updateSettings = settings.updateSettings.toBuilder();
            this.updateOperationSettings = settings.updateOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.deleteSettings, this.getSettings, this.insertSettings, this.listSettings, this.patchSettings, this.updateSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AutoscalersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AutoscalersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AutoscalersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AutoscalersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.insertSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.patchSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.insertOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.patchOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            builder.updateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Operation.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Operation.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)20000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, AutoscalersClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<DeleteAutoscalerRequest, Operation> deleteSettings() {
            return this.deleteSettings;
        }

        public OperationCallSettings.Builder<DeleteAutoscalerRequest, Operation, Operation> deleteOperationSettings() {
            return this.deleteOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAutoscalerRequest, Autoscaler> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<InsertAutoscalerRequest, Operation> insertSettings() {
            return this.insertSettings;
        }

        public OperationCallSettings.Builder<InsertAutoscalerRequest, Operation, Operation> insertOperationSettings() {
            return this.insertOperationSettings;
        }

        public PagedCallSettings.Builder<ListAutoscalersRequest, AutoscalerList, AutoscalersClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public UnaryCallSettings.Builder<PatchAutoscalerRequest, Operation> patchSettings() {
            return this.patchSettings;
        }

        public OperationCallSettings.Builder<PatchAutoscalerRequest, Operation, Operation> patchOperationSettings() {
            return this.patchOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAutoscalerRequest, Operation> updateSettings() {
            return this.updateSettings;
        }

        public OperationCallSettings.Builder<UpdateAutoscalerRequest, Operation, Operation> updateOperationSettings() {
            return this.updateOperationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return AutoscalersStubSettings.getDefaultEndpoint();
        }

        public AutoscalersStubSettings build() throws IOException {
            return new AutoscalersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

