/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DisableXpnHostProjectRequest;
import com.google.cloud.compute.v1.DisableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.EnableXpnHostProjectRequest;
import com.google.cloud.compute.v1.EnableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.GetProjectRequest;
import com.google.cloud.compute.v1.GetXpnHostProjectRequest;
import com.google.cloud.compute.v1.GetXpnResourcesProjectsRequest;
import com.google.cloud.compute.v1.ListXpnHostsProjectsRequest;
import com.google.cloud.compute.v1.MoveDiskProjectRequest;
import com.google.cloud.compute.v1.MoveInstanceProjectRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Project;
import com.google.cloud.compute.v1.ProjectsClient;
import com.google.cloud.compute.v1.ProjectsGetXpnResources;
import com.google.cloud.compute.v1.SetCommonInstanceMetadataProjectRequest;
import com.google.cloud.compute.v1.SetDefaultNetworkTierProjectRequest;
import com.google.cloud.compute.v1.SetUsageExportBucketProjectRequest;
import com.google.cloud.compute.v1.XpnHostList;
import com.google.cloud.compute.v1.XpnResourceId;
import com.google.cloud.compute.v1.stub.HttpJsonProjectsStub;
import com.google.cloud.compute.v1.stub.ProjectsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ProjectsStubSettings
extends StubSettings<ProjectsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<DisableXpnHostProjectRequest, Operation> disableXpnHostSettings;
    private final UnaryCallSettings<DisableXpnResourceProjectRequest, Operation> disableXpnResourceSettings;
    private final UnaryCallSettings<EnableXpnHostProjectRequest, Operation> enableXpnHostSettings;
    private final UnaryCallSettings<EnableXpnResourceProjectRequest, Operation> enableXpnResourceSettings;
    private final UnaryCallSettings<GetProjectRequest, Project> getSettings;
    private final UnaryCallSettings<GetXpnHostProjectRequest, Project> getXpnHostSettings;
    private final PagedCallSettings<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, ProjectsClient.GetXpnResourcesPagedResponse> getXpnResourcesSettings;
    private final PagedCallSettings<ListXpnHostsProjectsRequest, XpnHostList, ProjectsClient.ListXpnHostsPagedResponse> listXpnHostsSettings;
    private final UnaryCallSettings<MoveDiskProjectRequest, Operation> moveDiskSettings;
    private final UnaryCallSettings<MoveInstanceProjectRequest, Operation> moveInstanceSettings;
    private final UnaryCallSettings<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataSettings;
    private final UnaryCallSettings<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierSettings;
    private final UnaryCallSettings<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketSettings;
    private static final PagedListDescriptor<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId> GET_XPN_RESOURCES_PAGE_STR_DESC = new PagedListDescriptor<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId>(){

        public String emptyToken() {
            return "";
        }

        public GetXpnResourcesProjectsRequest injectToken(GetXpnResourcesProjectsRequest payload, String token) {
            return GetXpnResourcesProjectsRequest.newBuilder((GetXpnResourcesProjectsRequest)payload).setPageToken(token).build();
        }

        public GetXpnResourcesProjectsRequest injectPageSize(GetXpnResourcesProjectsRequest payload, int pageSize) {
            return GetXpnResourcesProjectsRequest.newBuilder((GetXpnResourcesProjectsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(GetXpnResourcesProjectsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(ProjectsGetXpnResources payload) {
            return payload.getNextPageToken();
        }

        public Iterable<XpnResourceId> extractResources(ProjectsGetXpnResources payload) {
            return payload.getResourcesList() == null ? ImmutableList.of() : payload.getResourcesList();
        }
    };
    private static final PagedListDescriptor<ListXpnHostsProjectsRequest, XpnHostList, Project> LIST_XPN_HOSTS_PAGE_STR_DESC = new PagedListDescriptor<ListXpnHostsProjectsRequest, XpnHostList, Project>(){

        public String emptyToken() {
            return "";
        }

        public ListXpnHostsProjectsRequest injectToken(ListXpnHostsProjectsRequest payload, String token) {
            return ListXpnHostsProjectsRequest.newBuilder((ListXpnHostsProjectsRequest)payload).setPageToken(token).build();
        }

        public ListXpnHostsProjectsRequest injectPageSize(ListXpnHostsProjectsRequest payload, int pageSize) {
            return ListXpnHostsProjectsRequest.newBuilder((ListXpnHostsProjectsRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListXpnHostsProjectsRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(XpnHostList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Project> extractResources(XpnHostList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, ProjectsClient.GetXpnResourcesPagedResponse> GET_XPN_RESOURCES_PAGE_STR_FACT = new PagedListResponseFactory<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, ProjectsClient.GetXpnResourcesPagedResponse>(){

        public ApiFuture<ProjectsClient.GetXpnResourcesPagedResponse> getFuturePagedResponse(UnaryCallable<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources> callable, GetXpnResourcesProjectsRequest request, ApiCallContext context, ApiFuture<ProjectsGetXpnResources> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)GET_XPN_RESOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProjectsClient.GetXpnResourcesPagedResponse.createAsync((PageContext<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, XpnResourceId>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListXpnHostsProjectsRequest, XpnHostList, ProjectsClient.ListXpnHostsPagedResponse> LIST_XPN_HOSTS_PAGE_STR_FACT = new PagedListResponseFactory<ListXpnHostsProjectsRequest, XpnHostList, ProjectsClient.ListXpnHostsPagedResponse>(){

        public ApiFuture<ProjectsClient.ListXpnHostsPagedResponse> getFuturePagedResponse(UnaryCallable<ListXpnHostsProjectsRequest, XpnHostList> callable, ListXpnHostsProjectsRequest request, ApiCallContext context, ApiFuture<XpnHostList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_XPN_HOSTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ProjectsClient.ListXpnHostsPagedResponse.createAsync((PageContext<ListXpnHostsProjectsRequest, XpnHostList, Project>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<DisableXpnHostProjectRequest, Operation> disableXpnHostSettings() {
        return this.disableXpnHostSettings;
    }

    public UnaryCallSettings<DisableXpnResourceProjectRequest, Operation> disableXpnResourceSettings() {
        return this.disableXpnResourceSettings;
    }

    public UnaryCallSettings<EnableXpnHostProjectRequest, Operation> enableXpnHostSettings() {
        return this.enableXpnHostSettings;
    }

    public UnaryCallSettings<EnableXpnResourceProjectRequest, Operation> enableXpnResourceSettings() {
        return this.enableXpnResourceSettings;
    }

    public UnaryCallSettings<GetProjectRequest, Project> getSettings() {
        return this.getSettings;
    }

    public UnaryCallSettings<GetXpnHostProjectRequest, Project> getXpnHostSettings() {
        return this.getXpnHostSettings;
    }

    public PagedCallSettings<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, ProjectsClient.GetXpnResourcesPagedResponse> getXpnResourcesSettings() {
        return this.getXpnResourcesSettings;
    }

    public PagedCallSettings<ListXpnHostsProjectsRequest, XpnHostList, ProjectsClient.ListXpnHostsPagedResponse> listXpnHostsSettings() {
        return this.listXpnHostsSettings;
    }

    public UnaryCallSettings<MoveDiskProjectRequest, Operation> moveDiskSettings() {
        return this.moveDiskSettings;
    }

    public UnaryCallSettings<MoveInstanceProjectRequest, Operation> moveInstanceSettings() {
        return this.moveInstanceSettings;
    }

    public UnaryCallSettings<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataSettings() {
        return this.setCommonInstanceMetadataSettings;
    }

    public UnaryCallSettings<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierSettings() {
        return this.setDefaultNetworkTierSettings;
    }

    public UnaryCallSettings<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketSettings() {
        return this.setUsageExportBucketSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ProjectsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonProjectsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ProjectsStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ProjectsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ProjectsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.disableXpnHostSettings = settingsBuilder.disableXpnHostSettings().build();
        this.disableXpnResourceSettings = settingsBuilder.disableXpnResourceSettings().build();
        this.enableXpnHostSettings = settingsBuilder.enableXpnHostSettings().build();
        this.enableXpnResourceSettings = settingsBuilder.enableXpnResourceSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.getXpnHostSettings = settingsBuilder.getXpnHostSettings().build();
        this.getXpnResourcesSettings = settingsBuilder.getXpnResourcesSettings().build();
        this.listXpnHostsSettings = settingsBuilder.listXpnHostsSettings().build();
        this.moveDiskSettings = settingsBuilder.moveDiskSettings().build();
        this.moveInstanceSettings = settingsBuilder.moveInstanceSettings().build();
        this.setCommonInstanceMetadataSettings = settingsBuilder.setCommonInstanceMetadataSettings().build();
        this.setDefaultNetworkTierSettings = settingsBuilder.setDefaultNetworkTierSettings().build();
        this.setUsageExportBucketSettings = settingsBuilder.setUsageExportBucketSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ProjectsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<DisableXpnHostProjectRequest, Operation> disableXpnHostSettings;
        private final UnaryCallSettings.Builder<DisableXpnResourceProjectRequest, Operation> disableXpnResourceSettings;
        private final UnaryCallSettings.Builder<EnableXpnHostProjectRequest, Operation> enableXpnHostSettings;
        private final UnaryCallSettings.Builder<EnableXpnResourceProjectRequest, Operation> enableXpnResourceSettings;
        private final UnaryCallSettings.Builder<GetProjectRequest, Project> getSettings;
        private final UnaryCallSettings.Builder<GetXpnHostProjectRequest, Project> getXpnHostSettings;
        private final PagedCallSettings.Builder<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, ProjectsClient.GetXpnResourcesPagedResponse> getXpnResourcesSettings;
        private final PagedCallSettings.Builder<ListXpnHostsProjectsRequest, XpnHostList, ProjectsClient.ListXpnHostsPagedResponse> listXpnHostsSettings;
        private final UnaryCallSettings.Builder<MoveDiskProjectRequest, Operation> moveDiskSettings;
        private final UnaryCallSettings.Builder<MoveInstanceProjectRequest, Operation> moveInstanceSettings;
        private final UnaryCallSettings.Builder<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataSettings;
        private final UnaryCallSettings.Builder<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierSettings;
        private final UnaryCallSettings.Builder<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.disableXpnHostSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableXpnResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableXpnHostSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableXpnResourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getXpnHostSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getXpnResourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)GET_XPN_RESOURCES_PAGE_STR_FACT);
            this.listXpnHostsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_XPN_HOSTS_PAGE_STR_FACT);
            this.moveDiskSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.moveInstanceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setCommonInstanceMetadataSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setDefaultNetworkTierSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setUsageExportBucketSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.disableXpnHostSettings, this.disableXpnResourceSettings, this.enableXpnHostSettings, this.enableXpnResourceSettings, this.getSettings, this.getXpnHostSettings, this.getXpnResourcesSettings, this.listXpnHostsSettings, this.moveDiskSettings, this.moveInstanceSettings, this.setCommonInstanceMetadataSettings, this.setDefaultNetworkTierSettings, (Object[])new UnaryCallSettings.Builder[]{this.setUsageExportBucketSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ProjectsStubSettings settings) {
            super((StubSettings)settings);
            this.disableXpnHostSettings = settings.disableXpnHostSettings.toBuilder();
            this.disableXpnResourceSettings = settings.disableXpnResourceSettings.toBuilder();
            this.enableXpnHostSettings = settings.enableXpnHostSettings.toBuilder();
            this.enableXpnResourceSettings = settings.enableXpnResourceSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.getXpnHostSettings = settings.getXpnHostSettings.toBuilder();
            this.getXpnResourcesSettings = settings.getXpnResourcesSettings.toBuilder();
            this.listXpnHostsSettings = settings.listXpnHostsSettings.toBuilder();
            this.moveDiskSettings = settings.moveDiskSettings.toBuilder();
            this.moveInstanceSettings = settings.moveInstanceSettings.toBuilder();
            this.setCommonInstanceMetadataSettings = settings.setCommonInstanceMetadataSettings.toBuilder();
            this.setDefaultNetworkTierSettings = settings.setDefaultNetworkTierSettings.toBuilder();
            this.setUsageExportBucketSettings = settings.setUsageExportBucketSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.disableXpnHostSettings, this.disableXpnResourceSettings, this.enableXpnHostSettings, this.enableXpnResourceSettings, this.getSettings, this.getXpnHostSettings, this.getXpnResourcesSettings, this.listXpnHostsSettings, this.moveDiskSettings, this.moveInstanceSettings, this.setCommonInstanceMetadataSettings, this.setDefaultNetworkTierSettings, (Object[])new UnaryCallSettings.Builder[]{this.setUsageExportBucketSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ProjectsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ProjectsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ProjectsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ProjectsStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ProjectsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.disableXpnHostSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.disableXpnResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.enableXpnHostSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.enableXpnResourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getXpnHostSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getXpnResourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listXpnHostsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.moveDiskSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.moveInstanceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setCommonInstanceMetadataSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setDefaultNetworkTierSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.setUsageExportBucketSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<DisableXpnHostProjectRequest, Operation> disableXpnHostSettings() {
            return this.disableXpnHostSettings;
        }

        public UnaryCallSettings.Builder<DisableXpnResourceProjectRequest, Operation> disableXpnResourceSettings() {
            return this.disableXpnResourceSettings;
        }

        public UnaryCallSettings.Builder<EnableXpnHostProjectRequest, Operation> enableXpnHostSettings() {
            return this.enableXpnHostSettings;
        }

        public UnaryCallSettings.Builder<EnableXpnResourceProjectRequest, Operation> enableXpnResourceSettings() {
            return this.enableXpnResourceSettings;
        }

        public UnaryCallSettings.Builder<GetProjectRequest, Project> getSettings() {
            return this.getSettings;
        }

        public UnaryCallSettings.Builder<GetXpnHostProjectRequest, Project> getXpnHostSettings() {
            return this.getXpnHostSettings;
        }

        public PagedCallSettings.Builder<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources, ProjectsClient.GetXpnResourcesPagedResponse> getXpnResourcesSettings() {
            return this.getXpnResourcesSettings;
        }

        public PagedCallSettings.Builder<ListXpnHostsProjectsRequest, XpnHostList, ProjectsClient.ListXpnHostsPagedResponse> listXpnHostsSettings() {
            return this.listXpnHostsSettings;
        }

        public UnaryCallSettings.Builder<MoveDiskProjectRequest, Operation> moveDiskSettings() {
            return this.moveDiskSettings;
        }

        public UnaryCallSettings.Builder<MoveInstanceProjectRequest, Operation> moveInstanceSettings() {
            return this.moveInstanceSettings;
        }

        public UnaryCallSettings.Builder<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataSettings() {
            return this.setCommonInstanceMetadataSettings;
        }

        public UnaryCallSettings.Builder<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierSettings() {
            return this.setDefaultNetworkTierSettings;
        }

        public UnaryCallSettings.Builder<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketSettings() {
            return this.setUsageExportBucketSettings;
        }

        public ProjectsStubSettings build() throws IOException {
            return new ProjectsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

