/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Address;
import com.google.cloud.compute.v1.AddressList;
import com.google.cloud.compute.v1.DeleteGlobalAddressRequest;
import com.google.cloud.compute.v1.GetGlobalAddressRequest;
import com.google.cloud.compute.v1.GlobalAddressesSettings;
import com.google.cloud.compute.v1.InsertGlobalAddressRequest;
import com.google.cloud.compute.v1.ListGlobalAddressesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.stub.GlobalAddressesStub;
import com.google.cloud.compute.v1.stub.GlobalAddressesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class GlobalAddressesClient
implements BackgroundResource {
    private final GlobalAddressesSettings settings;
    private final GlobalAddressesStub stub;

    public static final GlobalAddressesClient create() throws IOException {
        return GlobalAddressesClient.create(GlobalAddressesSettings.newBuilder().build());
    }

    public static final GlobalAddressesClient create(GlobalAddressesSettings settings) throws IOException {
        return new GlobalAddressesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalAddressesClient create(GlobalAddressesStub stub) {
        return new GlobalAddressesClient(stub);
    }

    protected GlobalAddressesClient(GlobalAddressesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalAddressesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalAddressesClient(GlobalAddressesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalAddressesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalAddressesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String address) {
        DeleteGlobalAddressRequest request = DeleteGlobalAddressRequest.newBuilder().setProject(project).setAddress(address).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteGlobalAddressRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlobalAddressRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Address get(String project, String address) {
        GetGlobalAddressRequest request = GetGlobalAddressRequest.newBuilder().setProject(project).setAddress(address).build();
        return this.get(request);
    }

    public final Address get(GetGlobalAddressRequest request) {
        return (Address)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlobalAddressRequest, Address> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, Address addressResource) {
        InsertGlobalAddressRequest request = InsertGlobalAddressRequest.newBuilder().setProject(project).setAddressResource(addressResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertGlobalAddressRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertGlobalAddressRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListGlobalAddressesRequest request = ListGlobalAddressesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListGlobalAddressesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlobalAddressesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListGlobalAddressesRequest, AddressList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalAddressesRequest, AddressList, Address, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListGlobalAddressesRequest, AddressList, Address, ListPage> {
        private ListPage(PageContext<ListGlobalAddressesRequest, AddressList, Address> context, AddressList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListGlobalAddressesRequest, AddressList, Address> context, AddressList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListGlobalAddressesRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListGlobalAddressesRequest, AddressList, Address, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListGlobalAddressesRequest, AddressList, Address> context, ApiFuture<AddressList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

