/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.GetSnapshotSettingRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSnapshotSettingRequest;
import com.google.cloud.compute.v1.SnapshotSettings;
import com.google.cloud.compute.v1.SnapshotSettingsServiceSettings;
import com.google.cloud.compute.v1.stub.SnapshotSettingsServiceStub;
import com.google.cloud.compute.v1.stub.SnapshotSettingsServiceStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class SnapshotSettingsServiceClient
implements BackgroundResource {
    private final SnapshotSettingsServiceSettings settings;
    private final SnapshotSettingsServiceStub stub;

    public static final SnapshotSettingsServiceClient create() throws IOException {
        return SnapshotSettingsServiceClient.create(SnapshotSettingsServiceSettings.newBuilder().build());
    }

    public static final SnapshotSettingsServiceClient create(SnapshotSettingsServiceSettings settings) throws IOException {
        return new SnapshotSettingsServiceClient(settings);
    }

    public static final SnapshotSettingsServiceClient create(SnapshotSettingsServiceStub stub) {
        return new SnapshotSettingsServiceClient(stub);
    }

    protected SnapshotSettingsServiceClient(SnapshotSettingsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SnapshotSettingsServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected SnapshotSettingsServiceClient(SnapshotSettingsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SnapshotSettingsServiceSettings getSettings() {
        return this.settings;
    }

    public SnapshotSettingsServiceStub getStub() {
        return this.stub;
    }

    public final SnapshotSettings get(String project) {
        GetSnapshotSettingRequest request = GetSnapshotSettingRequest.newBuilder().setProject(project).build();
        return this.get(request);
    }

    public final SnapshotSettings get(GetSnapshotSettingRequest request) {
        return (SnapshotSettings)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetSnapshotSettingRequest, SnapshotSettings> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, SnapshotSettings snapshotSettingsResource) {
        PatchSnapshotSettingRequest request = PatchSnapshotSettingRequest.newBuilder().setProject(project).setSnapshotSettingsResource(snapshotSettingsResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchSnapshotSettingRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchSnapshotSettingRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchSnapshotSettingRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

