/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListDiskTypesRequest;
import com.google.cloud.compute.v1.DiskType;
import com.google.cloud.compute.v1.DiskTypeAggregatedList;
import com.google.cloud.compute.v1.DiskTypeList;
import com.google.cloud.compute.v1.DiskTypesClient;
import com.google.cloud.compute.v1.DiskTypesScopedList;
import com.google.cloud.compute.v1.GetDiskTypeRequest;
import com.google.cloud.compute.v1.ListDiskTypesRequest;
import com.google.cloud.compute.v1.stub.DiskTypesStub;
import com.google.cloud.compute.v1.stub.HttpJsonDiskTypesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.threeten.bp.Duration;

public class DiskTypesStubSettings
extends StubSettings<DiskTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, DiskTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
    private final UnaryCallSettings<GetDiskTypeRequest, DiskType> getSettings;
    private final PagedCallSettings<ListDiskTypesRequest, DiskTypeList, DiskTypesClient.ListPagedResponse> listSettings;
    private static final PagedListDescriptor<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, Map.Entry<String, DiskTypesScopedList>> AGGREGATED_LIST_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, Map.Entry<String, DiskTypesScopedList>>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListDiskTypesRequest injectToken(AggregatedListDiskTypesRequest payload, String token) {
            return AggregatedListDiskTypesRequest.newBuilder((AggregatedListDiskTypesRequest)payload).setPageToken(token).build();
        }

        public AggregatedListDiskTypesRequest injectPageSize(AggregatedListDiskTypesRequest payload, int pageSize) {
            return AggregatedListDiskTypesRequest.newBuilder((AggregatedListDiskTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListDiskTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskTypeAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Map.Entry<String, DiskTypesScopedList>> extractResources(DiskTypeAggregatedList payload) {
            return payload.getItemsMap() == null ? Collections.emptySet() : payload.getItemsMap().entrySet();
        }
    };
    private static final PagedListDescriptor<ListDiskTypesRequest, DiskTypeList, DiskType> LIST_PAGE_STR_DESC = new PagedListDescriptor<ListDiskTypesRequest, DiskTypeList, DiskType>(){

        public String emptyToken() {
            return "";
        }

        public ListDiskTypesRequest injectToken(ListDiskTypesRequest payload, String token) {
            return ListDiskTypesRequest.newBuilder((ListDiskTypesRequest)payload).setPageToken(token).build();
        }

        public ListDiskTypesRequest injectPageSize(ListDiskTypesRequest payload, int pageSize) {
            return ListDiskTypesRequest.newBuilder((ListDiskTypesRequest)payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListDiskTypesRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(DiskTypeList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DiskType> extractResources(DiskTypeList payload) {
            return payload.getItemsList() == null ? ImmutableList.of() : payload.getItemsList();
        }
    };
    private static final PagedListResponseFactory<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, DiskTypesClient.AggregatedListPagedResponse> AGGREGATED_LIST_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, DiskTypesClient.AggregatedListPagedResponse>(){

        public ApiFuture<DiskTypesClient.AggregatedListPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListDiskTypesRequest, DiskTypeAggregatedList> callable, AggregatedListDiskTypesRequest request, ApiCallContext context, ApiFuture<DiskTypeAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DiskTypesClient.AggregatedListPagedResponse.createAsync((PageContext<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, Map.Entry<String, DiskTypesScopedList>>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDiskTypesRequest, DiskTypeList, DiskTypesClient.ListPagedResponse> LIST_PAGE_STR_FACT = new PagedListResponseFactory<ListDiskTypesRequest, DiskTypeList, DiskTypesClient.ListPagedResponse>(){

        public ApiFuture<DiskTypesClient.ListPagedResponse> getFuturePagedResponse(UnaryCallable<ListDiskTypesRequest, DiskTypeList> callable, ListDiskTypesRequest request, ApiCallContext context, ApiFuture<DiskTypeList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DiskTypesClient.ListPagedResponse.createAsync((PageContext<ListDiskTypesRequest, DiskTypeList, DiskType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, DiskTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
        return this.aggregatedListSettings;
    }

    public UnaryCallSettings<GetDiskTypeRequest, DiskType> getSettings() {
        return this.getSettings;
    }

    public PagedCallSettings<ListDiskTypesRequest, DiskTypeList, DiskTypesClient.ListPagedResponse> listSettings() {
        return this.listSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DiskTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDiskTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "compute.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "compute.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DiskTypesStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DiskTypesStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DiskTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSettings = settingsBuilder.aggregatedListSettings().build();
        this.getSettings = settingsBuilder.getSettings().build();
        this.listSettings = settingsBuilder.listSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DiskTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, DiskTypesClient.AggregatedListPagedResponse> aggregatedListSettings;
        private final UnaryCallSettings.Builder<GetDiskTypeRequest, DiskType> getSettings;
        private final PagedCallSettings.Builder<ListDiskTypesRequest, DiskTypeList, DiskTypesClient.ListPagedResponse> listSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_PAGE_STR_FACT);
            this.getSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DiskTypesStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSettings = settings.aggregatedListSettings.toBuilder();
            this.getSettings = settings.getSettings.toBuilder();
            this.listSettings = settings.listSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSettings, this.getSettings, this.listSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DiskTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DiskTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DiskTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DiskTypesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DiskTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListDiskTypesRequest, DiskTypeAggregatedList, DiskTypesClient.AggregatedListPagedResponse> aggregatedListSettings() {
            return this.aggregatedListSettings;
        }

        public UnaryCallSettings.Builder<GetDiskTypeRequest, DiskType> getSettings() {
            return this.getSettings;
        }

        public PagedCallSettings.Builder<ListDiskTypesRequest, DiskTypeList, DiskTypesClient.ListPagedResponse> listSettings() {
            return this.listSettings;
        }

        public DiskTypesStubSettings build() throws IOException {
            return new DiskTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

