/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteZoneOperationRequest;
import com.google.cloud.compute.v1.DeleteZoneOperationResponse;
import com.google.cloud.compute.v1.GetZoneOperationRequest;
import com.google.cloud.compute.v1.ListZoneOperationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.WaitZoneOperationRequest;
import com.google.cloud.compute.v1.ZoneOperationsSettings;
import com.google.cloud.compute.v1.stub.ZoneOperationsStub;
import com.google.cloud.compute.v1.stub.ZoneOperationsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ZoneOperationsClient
implements BackgroundResource {
    private final ZoneOperationsSettings settings;
    private final ZoneOperationsStub stub;

    public static final ZoneOperationsClient create() throws IOException {
        return ZoneOperationsClient.create(ZoneOperationsSettings.newBuilder().build());
    }

    public static final ZoneOperationsClient create(ZoneOperationsSettings settings) throws IOException {
        return new ZoneOperationsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ZoneOperationsClient create(ZoneOperationsStub stub) {
        return new ZoneOperationsClient(stub);
    }

    protected ZoneOperationsClient(ZoneOperationsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ZoneOperationsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ZoneOperationsClient(ZoneOperationsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ZoneOperationsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ZoneOperationsStub getStub() {
        return this.stub;
    }

    public final DeleteZoneOperationResponse delete(String project, String zone, String operation) {
        DeleteZoneOperationRequest request = DeleteZoneOperationRequest.newBuilder().setProject(project).setZone(zone).setOperation(operation).build();
        return this.delete(request);
    }

    public final DeleteZoneOperationResponse delete(DeleteZoneOperationRequest request) {
        return (DeleteZoneOperationResponse)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteZoneOperationRequest, DeleteZoneOperationResponse> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Operation get(String project, String zone, String operation) {
        GetZoneOperationRequest request = GetZoneOperationRequest.newBuilder().setProject(project).setZone(zone).setOperation(operation).build();
        return this.get(request);
    }

    public final Operation get(GetZoneOperationRequest request) {
        return (Operation)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetZoneOperationRequest, Operation> getCallable() {
        return this.stub.getCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListZoneOperationsRequest request = ListZoneOperationsRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListZoneOperationsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListZoneOperationsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListZoneOperationsRequest, OperationList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation wait(String project, String zone, String operation) {
        WaitZoneOperationRequest request = WaitZoneOperationRequest.newBuilder().setProject(project).setZone(zone).setOperation(operation).build();
        return this.wait(request);
    }

    public final Operation wait(WaitZoneOperationRequest request) {
        return (Operation)this.waitCallable().call((Object)request);
    }

    public final UnaryCallable<WaitZoneOperationRequest, Operation> waitCallable() {
        return this.stub.waitCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZoneOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListZoneOperationsRequest, OperationList, Operation, ListPage> {
        private ListPage(PageContext<ListZoneOperationsRequest, OperationList, Operation> context, OperationList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListZoneOperationsRequest, OperationList, Operation> context, OperationList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListZoneOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListZoneOperationsRequest, OperationList, Operation, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListZoneOperationsRequest, OperationList, Operation> context, ApiFuture<OperationList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

