/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.DeleteSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.GetSecurityPolicyRequest;
import com.google.cloud.compute.v1.InsertSecurityPolicyRequest;
import com.google.cloud.compute.v1.ListPreconfiguredExpressionSetsSecurityPoliciesRequest;
import com.google.cloud.compute.v1.ListSecurityPoliciesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.PatchSecurityPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleSecurityPolicyRequest;
import com.google.cloud.compute.v1.SecurityPoliciesListPreconfiguredExpressionSetsResponse;
import com.google.cloud.compute.v1.SecurityPoliciesSettings;
import com.google.cloud.compute.v1.SecurityPolicy;
import com.google.cloud.compute.v1.SecurityPolicyList;
import com.google.cloud.compute.v1.SecurityPolicyRule;
import com.google.cloud.compute.v1.stub.SecurityPoliciesStub;
import com.google.cloud.compute.v1.stub.SecurityPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class SecurityPoliciesClient
implements BackgroundResource {
    private final SecurityPoliciesSettings settings;
    private final SecurityPoliciesStub stub;

    public static final SecurityPoliciesClient create() throws IOException {
        return SecurityPoliciesClient.create(SecurityPoliciesSettings.newBuilder().build());
    }

    public static final SecurityPoliciesClient create(SecurityPoliciesSettings settings) throws IOException {
        return new SecurityPoliciesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final SecurityPoliciesClient create(SecurityPoliciesStub stub) {
        return new SecurityPoliciesClient(stub);
    }

    protected SecurityPoliciesClient(SecurityPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SecurityPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected SecurityPoliciesClient(SecurityPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SecurityPoliciesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SecurityPoliciesStub getStub() {
        return this.stub;
    }

    public final Operation addRule(String project, String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        AddRuleSecurityPolicyRequest request = AddRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.addRule(request);
    }

    public final Operation addRule(AddRuleSecurityPolicyRequest request) {
        return (Operation)this.addRuleCallable().call((Object)request);
    }

    public final UnaryCallable<AddRuleSecurityPolicyRequest, Operation> addRuleCallable() {
        return this.stub.addRuleCallable();
    }

    public final Operation delete(String project, String securityPolicy) {
        DeleteSecurityPolicyRequest request = DeleteSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteSecurityPolicyRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteSecurityPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final SecurityPolicy get(String project, String securityPolicy) {
        GetSecurityPolicyRequest request = GetSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.get(request);
    }

    public final SecurityPolicy get(GetSecurityPolicyRequest request) {
        return (SecurityPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetSecurityPolicyRequest, SecurityPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final SecurityPolicyRule getRule(String project, String securityPolicy) {
        GetRuleSecurityPolicyRequest request = GetRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.getRule(request);
    }

    public final SecurityPolicyRule getRule(GetRuleSecurityPolicyRequest request) {
        return (SecurityPolicyRule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleSecurityPolicyRequest, SecurityPolicyRule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final Operation insert(String project, SecurityPolicy securityPolicyResource) {
        InsertSecurityPolicyRequest request = InsertSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicyResource(securityPolicyResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertSecurityPolicyRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertSecurityPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListSecurityPoliciesRequest request = ListSecurityPoliciesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListSecurityPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSecurityPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListSecurityPoliciesRequest, SecurityPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSets(String project) {
        ListPreconfiguredExpressionSetsSecurityPoliciesRequest request = ListPreconfiguredExpressionSetsSecurityPoliciesRequest.newBuilder().setProject(project).build();
        return this.listPreconfiguredExpressionSets(request);
    }

    public final SecurityPoliciesListPreconfiguredExpressionSetsResponse listPreconfiguredExpressionSets(ListPreconfiguredExpressionSetsSecurityPoliciesRequest request) {
        return (SecurityPoliciesListPreconfiguredExpressionSetsResponse)this.listPreconfiguredExpressionSetsCallable().call((Object)request);
    }

    public final UnaryCallable<ListPreconfiguredExpressionSetsSecurityPoliciesRequest, SecurityPoliciesListPreconfiguredExpressionSetsResponse> listPreconfiguredExpressionSetsCallable() {
        return this.stub.listPreconfiguredExpressionSetsCallable();
    }

    public final Operation patch(String project, String securityPolicy, SecurityPolicy securityPolicyResource) {
        PatchSecurityPolicyRequest request = PatchSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).setSecurityPolicyResource(securityPolicyResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchSecurityPolicyRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchSecurityPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation patchRule(String project, String securityPolicy, SecurityPolicyRule securityPolicyRuleResource) {
        PatchRuleSecurityPolicyRequest request = PatchRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).setSecurityPolicyRuleResource(securityPolicyRuleResource).build();
        return this.patchRule(request);
    }

    public final Operation patchRule(PatchRuleSecurityPolicyRequest request) {
        return (Operation)this.patchRuleCallable().call((Object)request);
    }

    public final UnaryCallable<PatchRuleSecurityPolicyRequest, Operation> patchRuleCallable() {
        return this.stub.patchRuleCallable();
    }

    public final Operation removeRule(String project, String securityPolicy) {
        RemoveRuleSecurityPolicyRequest request = RemoveRuleSecurityPolicyRequest.newBuilder().setProject(project).setSecurityPolicy(securityPolicy).build();
        return this.removeRule(request);
    }

    public final Operation removeRule(RemoveRuleSecurityPolicyRequest request) {
        return (Operation)this.removeRuleCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveRuleSecurityPolicyRequest, Operation> removeRuleCallable() {
        return this.stub.removeRuleCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage> {
        private ListPage(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, SecurityPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListSecurityPoliciesRequest, SecurityPolicyList, SecurityPolicy> context, ApiFuture<SecurityPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

