/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteRouteRequest;
import com.google.cloud.compute.v1.GetRouteRequest;
import com.google.cloud.compute.v1.InsertRouteRequest;
import com.google.cloud.compute.v1.ListRoutesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Route;
import com.google.cloud.compute.v1.RouteList;
import com.google.cloud.compute.v1.RoutesSettings;
import com.google.cloud.compute.v1.stub.RoutesStub;
import com.google.cloud.compute.v1.stub.RoutesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RoutesClient
implements BackgroundResource {
    private final RoutesSettings settings;
    private final RoutesStub stub;

    public static final RoutesClient create() throws IOException {
        return RoutesClient.create(RoutesSettings.newBuilder().build());
    }

    public static final RoutesClient create(RoutesSettings settings) throws IOException {
        return new RoutesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RoutesClient create(RoutesStub stub) {
        return new RoutesClient(stub);
    }

    protected RoutesClient(RoutesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RoutesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RoutesClient(RoutesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RoutesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RoutesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String route) {
        DeleteRouteRequest request = DeleteRouteRequest.newBuilder().setProject(project).setRoute(route).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteRouteRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteRouteRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Route get(String project, String route) {
        GetRouteRequest request = GetRouteRequest.newBuilder().setProject(project).setRoute(route).build();
        return this.get(request);
    }

    public final Route get(GetRouteRequest request) {
        return (Route)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRouteRequest, Route> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, Route routeResource) {
        InsertRouteRequest request = InsertRouteRequest.newBuilder().setProject(project).setRouteResource(routeResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertRouteRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertRouteRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListRoutesRequest request = ListRoutesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRoutesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRoutesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRoutesRequest, RouteList> listCallable() {
        return this.stub.listCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRoutesRequest, RouteList, Route, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRoutesRequest, RouteList, Route, ListPage> {
        private ListPage(PageContext<ListRoutesRequest, RouteList, Route> context, RouteList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRoutesRequest, RouteList, Route> context, RouteList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRoutesRequest, RouteList, Route> context, ApiFuture<RouteList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRoutesRequest, RouteList, Route, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRoutesRequest, RouteList, Route> context, ApiFuture<RouteList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

