/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListHealthChecksRequest;
import com.google.cloud.compute.v1.DeleteHealthCheckRequest;
import com.google.cloud.compute.v1.GetHealthCheckRequest;
import com.google.cloud.compute.v1.HealthCheck;
import com.google.cloud.compute.v1.HealthCheckList;
import com.google.cloud.compute.v1.HealthChecksAggregatedList;
import com.google.cloud.compute.v1.HealthChecksScopedList;
import com.google.cloud.compute.v1.HealthChecksSettings;
import com.google.cloud.compute.v1.InsertHealthCheckRequest;
import com.google.cloud.compute.v1.ListHealthChecksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchHealthCheckRequest;
import com.google.cloud.compute.v1.UpdateHealthCheckRequest;
import com.google.cloud.compute.v1.stub.HealthChecksStub;
import com.google.cloud.compute.v1.stub.HealthChecksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class HealthChecksClient
implements BackgroundResource {
    private final HealthChecksSettings settings;
    private final HealthChecksStub stub;

    public static final HealthChecksClient create() throws IOException {
        return HealthChecksClient.create(HealthChecksSettings.newBuilder().build());
    }

    public static final HealthChecksClient create(HealthChecksSettings settings) throws IOException {
        return new HealthChecksClient(settings);
    }

    public static final HealthChecksClient create(HealthChecksStub stub) {
        return new HealthChecksClient(stub);
    }

    protected HealthChecksClient(HealthChecksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((HealthChecksStubSettings)settings.getStubSettings()).createStub();
    }

    protected HealthChecksClient(HealthChecksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final HealthChecksSettings getSettings() {
        return this.settings;
    }

    public HealthChecksStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListHealthChecksRequest request = AggregatedListHealthChecksRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListHealthChecksRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListHealthChecksRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListHealthChecksRequest, HealthChecksAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String healthCheck) {
        DeleteHealthCheckRequest request = DeleteHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteHealthCheckRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHealthCheckRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteHealthCheckRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final HealthCheck get(String project, String healthCheck) {
        GetHealthCheckRequest request = GetHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).build();
        return this.get(request);
    }

    public final HealthCheck get(GetHealthCheckRequest request) {
        return (HealthCheck)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetHealthCheckRequest, HealthCheck> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, HealthCheck healthCheckResource) {
        InsertHealthCheckRequest request = InsertHealthCheckRequest.newBuilder().setProject(project).setHealthCheckResource(healthCheckResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertHealthCheckRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertHealthCheckRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertHealthCheckRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListHealthChecksRequest request = ListHealthChecksRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListHealthChecksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHealthChecksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListHealthChecksRequest, HealthCheckList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String healthCheck, HealthCheck healthCheckResource) {
        PatchHealthCheckRequest request = PatchHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchHealthCheckRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchHealthCheckRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchHealthCheckRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String healthCheck, HealthCheck healthCheckResource) {
        UpdateHealthCheckRequest request = UpdateHealthCheckRequest.newBuilder().setProject(project).setHealthCheck(healthCheck).setHealthCheckResource(healthCheckResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateHealthCheckRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateHealthCheckRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateHealthCheckRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListHealthChecksRequest, HealthCheckList, HealthCheck, ListPage> {
        private ListPage(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, HealthCheckList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListHealthChecksRequest, HealthCheckList, HealthCheck, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListHealthChecksRequest, HealthCheckList, HealthCheck> context, ApiFuture<HealthCheckList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, HealthChecksAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, HealthChecksAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, ApiFuture<HealthChecksAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListHealthChecksRequest, HealthChecksAggregatedList, Map.Entry<String, HealthChecksScopedList>> context, ApiFuture<HealthChecksAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

