/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddResourcePoliciesDiskRequest;
import com.google.cloud.compute.v1.AggregatedListDisksRequest;
import com.google.cloud.compute.v1.CreateSnapshotDiskRequest;
import com.google.cloud.compute.v1.DeleteDiskRequest;
import com.google.cloud.compute.v1.Disk;
import com.google.cloud.compute.v1.DiskAggregatedList;
import com.google.cloud.compute.v1.DiskList;
import com.google.cloud.compute.v1.DisksAddResourcePoliciesRequest;
import com.google.cloud.compute.v1.DisksRemoveResourcePoliciesRequest;
import com.google.cloud.compute.v1.DisksResizeRequest;
import com.google.cloud.compute.v1.DisksScopedList;
import com.google.cloud.compute.v1.DisksSettings;
import com.google.cloud.compute.v1.GetDiskRequest;
import com.google.cloud.compute.v1.GetIamPolicyDiskRequest;
import com.google.cloud.compute.v1.InsertDiskRequest;
import com.google.cloud.compute.v1.ListDisksRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RemoveResourcePoliciesDiskRequest;
import com.google.cloud.compute.v1.ResizeDiskRequest;
import com.google.cloud.compute.v1.SetIamPolicyDiskRequest;
import com.google.cloud.compute.v1.SetLabelsDiskRequest;
import com.google.cloud.compute.v1.Snapshot;
import com.google.cloud.compute.v1.TestIamPermissionsDiskRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UpdateDiskRequest;
import com.google.cloud.compute.v1.ZoneSetLabelsRequest;
import com.google.cloud.compute.v1.ZoneSetPolicyRequest;
import com.google.cloud.compute.v1.stub.DisksStub;
import com.google.cloud.compute.v1.stub.DisksStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class DisksClient
implements BackgroundResource {
    private final DisksSettings settings;
    private final DisksStub stub;

    public static final DisksClient create() throws IOException {
        return DisksClient.create(DisksSettings.newBuilder().build());
    }

    public static final DisksClient create(DisksSettings settings) throws IOException {
        return new DisksClient(settings);
    }

    public static final DisksClient create(DisksStub stub) {
        return new DisksClient(stub);
    }

    protected DisksClient(DisksSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DisksStubSettings)settings.getStubSettings()).createStub();
    }

    protected DisksClient(DisksStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DisksSettings getSettings() {
        return this.settings;
    }

    public DisksStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> addResourcePoliciesAsync(String project, String zone, String disk, DisksAddResourcePoliciesRequest disksAddResourcePoliciesRequestResource) {
        AddResourcePoliciesDiskRequest request = AddResourcePoliciesDiskRequest.newBuilder().setProject(project).setZone(zone).setDisk(disk).setDisksAddResourcePoliciesRequestResource(disksAddResourcePoliciesRequestResource).build();
        return this.addResourcePoliciesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> addResourcePoliciesAsync(AddResourcePoliciesDiskRequest request) {
        return this.addResourcePoliciesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<AddResourcePoliciesDiskRequest, Operation, Operation> addResourcePoliciesOperationCallable() {
        return this.stub.addResourcePoliciesOperationCallable();
    }

    public final UnaryCallable<AddResourcePoliciesDiskRequest, Operation> addResourcePoliciesCallable() {
        return this.stub.addResourcePoliciesCallable();
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListDisksRequest request = AggregatedListDisksRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListDisksRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListDisksRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListDisksRequest, DiskAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final OperationFuture<Operation, Operation> createSnapshotAsync(String project, String zone, String disk, Snapshot snapshotResource) {
        CreateSnapshotDiskRequest request = CreateSnapshotDiskRequest.newBuilder().setProject(project).setZone(zone).setDisk(disk).setSnapshotResource(snapshotResource).build();
        return this.createSnapshotAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> createSnapshotAsync(CreateSnapshotDiskRequest request) {
        return this.createSnapshotOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSnapshotDiskRequest, Operation, Operation> createSnapshotOperationCallable() {
        return this.stub.createSnapshotOperationCallable();
    }

    public final UnaryCallable<CreateSnapshotDiskRequest, Operation> createSnapshotCallable() {
        return this.stub.createSnapshotCallable();
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String zone, String disk) {
        DeleteDiskRequest request = DeleteDiskRequest.newBuilder().setProject(project).setZone(zone).setDisk(disk).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteDiskRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDiskRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteDiskRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Disk get(String project, String zone, String disk) {
        GetDiskRequest request = GetDiskRequest.newBuilder().setProject(project).setZone(zone).setDisk(disk).build();
        return this.get(request);
    }

    public final Disk get(GetDiskRequest request) {
        return (Disk)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetDiskRequest, Disk> getCallable() {
        return this.stub.getCallable();
    }

    public final Policy getIamPolicy(String project, String zone, String resource) {
        GetIamPolicyDiskRequest request = GetIamPolicyDiskRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyDiskRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyDiskRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String zone, Disk diskResource) {
        InsertDiskRequest request = InsertDiskRequest.newBuilder().setProject(project).setZone(zone).setDiskResource(diskResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertDiskRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertDiskRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertDiskRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListDisksRequest request = ListDisksRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListDisksRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDisksRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListDisksRequest, DiskList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> removeResourcePoliciesAsync(String project, String zone, String disk, DisksRemoveResourcePoliciesRequest disksRemoveResourcePoliciesRequestResource) {
        RemoveResourcePoliciesDiskRequest request = RemoveResourcePoliciesDiskRequest.newBuilder().setProject(project).setZone(zone).setDisk(disk).setDisksRemoveResourcePoliciesRequestResource(disksRemoveResourcePoliciesRequestResource).build();
        return this.removeResourcePoliciesAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> removeResourcePoliciesAsync(RemoveResourcePoliciesDiskRequest request) {
        return this.removeResourcePoliciesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RemoveResourcePoliciesDiskRequest, Operation, Operation> removeResourcePoliciesOperationCallable() {
        return this.stub.removeResourcePoliciesOperationCallable();
    }

    public final UnaryCallable<RemoveResourcePoliciesDiskRequest, Operation> removeResourcePoliciesCallable() {
        return this.stub.removeResourcePoliciesCallable();
    }

    public final OperationFuture<Operation, Operation> resizeAsync(String project, String zone, String disk, DisksResizeRequest disksResizeRequestResource) {
        ResizeDiskRequest request = ResizeDiskRequest.newBuilder().setProject(project).setZone(zone).setDisk(disk).setDisksResizeRequestResource(disksResizeRequestResource).build();
        return this.resizeAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> resizeAsync(ResizeDiskRequest request) {
        return this.resizeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ResizeDiskRequest, Operation, Operation> resizeOperationCallable() {
        return this.stub.resizeOperationCallable();
    }

    public final UnaryCallable<ResizeDiskRequest, Operation> resizeCallable() {
        return this.stub.resizeCallable();
    }

    public final Policy setIamPolicy(String project, String zone, String resource, ZoneSetPolicyRequest zoneSetPolicyRequestResource) {
        SetIamPolicyDiskRequest request = SetIamPolicyDiskRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setZoneSetPolicyRequestResource(zoneSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyDiskRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyDiskRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final OperationFuture<Operation, Operation> setLabelsAsync(String project, String zone, String resource, ZoneSetLabelsRequest zoneSetLabelsRequestResource) {
        SetLabelsDiskRequest request = SetLabelsDiskRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setZoneSetLabelsRequestResource(zoneSetLabelsRequestResource).build();
        return this.setLabelsAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> setLabelsAsync(SetLabelsDiskRequest request) {
        return this.setLabelsOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SetLabelsDiskRequest, Operation, Operation> setLabelsOperationCallable() {
        return this.stub.setLabelsOperationCallable();
    }

    public final UnaryCallable<SetLabelsDiskRequest, Operation> setLabelsCallable() {
        return this.stub.setLabelsCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String zone, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsDiskRequest request = TestIamPermissionsDiskRequest.newBuilder().setProject(project).setZone(zone).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsDiskRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsDiskRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String zone, String disk, Disk diskResource) {
        UpdateDiskRequest request = UpdateDiskRequest.newBuilder().setProject(project).setZone(zone).setDisk(disk).setDiskResource(diskResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateDiskRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDiskRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateDiskRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDisksRequest, DiskList, Disk, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListDisksRequest, DiskList, Disk, ListPage> {
        private ListPage(PageContext<ListDisksRequest, DiskList, Disk> context, DiskList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListDisksRequest, DiskList, Disk> context, DiskList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListDisksRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListDisksRequest, DiskList, Disk, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListDisksRequest, DiskList, Disk> context, ApiFuture<DiskList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>> context, DiskAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>> context, DiskAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>> context, ApiFuture<DiskAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListDisksRequest, DiskAggregatedList, Map.Entry<String, DisksScopedList>> context, ApiFuture<DiskAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new AggregatedListPagedResponse((AggregatedListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

