/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.DeleteRegionAutoscalerRequest;
import com.google.cloud.compute.v1.GetRegionAutoscalerRequest;
import com.google.cloud.compute.v1.InsertRegionAutoscalerRequest;
import com.google.cloud.compute.v1.ListRegionAutoscalersRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchRegionAutoscalerRequest;
import com.google.cloud.compute.v1.RegionAutoscalerList;
import com.google.cloud.compute.v1.RegionAutoscalersSettings;
import com.google.cloud.compute.v1.UpdateRegionAutoscalerRequest;
import com.google.cloud.compute.v1.stub.RegionAutoscalersStub;
import com.google.cloud.compute.v1.stub.RegionAutoscalersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class RegionAutoscalersClient
implements BackgroundResource {
    private final RegionAutoscalersSettings settings;
    private final RegionAutoscalersStub stub;

    public static final RegionAutoscalersClient create() throws IOException {
        return RegionAutoscalersClient.create(RegionAutoscalersSettings.newBuilder().build());
    }

    public static final RegionAutoscalersClient create(RegionAutoscalersSettings settings) throws IOException {
        return new RegionAutoscalersClient(settings);
    }

    public static final RegionAutoscalersClient create(RegionAutoscalersStub stub) {
        return new RegionAutoscalersClient(stub);
    }

    protected RegionAutoscalersClient(RegionAutoscalersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RegionAutoscalersStubSettings)settings.getStubSettings()).createStub();
    }

    protected RegionAutoscalersClient(RegionAutoscalersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final RegionAutoscalersSettings getSettings() {
        return this.settings;
    }

    public RegionAutoscalersStub getStub() {
        return this.stub;
    }

    public final OperationFuture<Operation, Operation> deleteAsync(String project, String region, String autoscaler) {
        DeleteRegionAutoscalerRequest request = DeleteRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscaler(autoscaler).build();
        return this.deleteAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> deleteAsync(DeleteRegionAutoscalerRequest request) {
        return this.deleteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteRegionAutoscalerRequest, Operation, Operation> deleteOperationCallable() {
        return this.stub.deleteOperationCallable();
    }

    public final UnaryCallable<DeleteRegionAutoscalerRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Autoscaler get(String project, String region, String autoscaler) {
        GetRegionAutoscalerRequest request = GetRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscaler(autoscaler).build();
        return this.get(request);
    }

    public final Autoscaler get(GetRegionAutoscalerRequest request) {
        return (Autoscaler)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetRegionAutoscalerRequest, Autoscaler> getCallable() {
        return this.stub.getCallable();
    }

    public final OperationFuture<Operation, Operation> insertAsync(String project, String region, Autoscaler autoscalerResource) {
        InsertRegionAutoscalerRequest request = InsertRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.insertAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> insertAsync(InsertRegionAutoscalerRequest request) {
        return this.insertOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<InsertRegionAutoscalerRequest, Operation, Operation> insertOperationCallable() {
        return this.stub.insertOperationCallable();
    }

    public final UnaryCallable<InsertRegionAutoscalerRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListRegionAutoscalersRequest request = ListRegionAutoscalersRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListRegionAutoscalersRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRegionAutoscalersRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListRegionAutoscalersRequest, RegionAutoscalerList> listCallable() {
        return this.stub.listCallable();
    }

    public final OperationFuture<Operation, Operation> patchAsync(String project, String region, Autoscaler autoscalerResource) {
        PatchRegionAutoscalerRequest request = PatchRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.patchAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> patchAsync(PatchRegionAutoscalerRequest request) {
        return this.patchOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<PatchRegionAutoscalerRequest, Operation, Operation> patchOperationCallable() {
        return this.stub.patchOperationCallable();
    }

    public final UnaryCallable<PatchRegionAutoscalerRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final OperationFuture<Operation, Operation> updateAsync(String project, String region, Autoscaler autoscalerResource) {
        UpdateRegionAutoscalerRequest request = UpdateRegionAutoscalerRequest.newBuilder().setProject(project).setRegion(region).setAutoscalerResource(autoscalerResource).build();
        return this.updateAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Operation, Operation> updateAsync(UpdateRegionAutoscalerRequest request) {
        return this.updateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateRegionAutoscalerRequest, Operation, Operation> updateOperationCallable() {
        return this.stub.updateOperationCallable();
    }

    public final UnaryCallable<UpdateRegionAutoscalerRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler, ListPage> {
        private ListPage(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, RegionAutoscalerList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, RegionAutoscalerList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, ApiFuture<RegionAutoscalerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListRegionAutoscalersRequest, RegionAutoscalerList, Autoscaler> context, ApiFuture<RegionAutoscalerList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPagedResponse((ListPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

