/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AddAssociationFirewallPolicyRequest;
import com.google.cloud.compute.v1.AddRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.CloneRulesFirewallPolicyRequest;
import com.google.cloud.compute.v1.DeleteFirewallPolicyRequest;
import com.google.cloud.compute.v1.FirewallPoliciesListAssociationsResponse;
import com.google.cloud.compute.v1.FirewallPoliciesSettings;
import com.google.cloud.compute.v1.FirewallPolicy;
import com.google.cloud.compute.v1.FirewallPolicyAssociation;
import com.google.cloud.compute.v1.FirewallPolicyList;
import com.google.cloud.compute.v1.FirewallPolicyRule;
import com.google.cloud.compute.v1.GetAssociationFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetIamPolicyFirewallPolicyRequest;
import com.google.cloud.compute.v1.GetRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.GlobalOrganizationSetPolicyRequest;
import com.google.cloud.compute.v1.InsertFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListAssociationsFirewallPolicyRequest;
import com.google.cloud.compute.v1.ListFirewallPoliciesRequest;
import com.google.cloud.compute.v1.MoveFirewallPolicyRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchFirewallPolicyRequest;
import com.google.cloud.compute.v1.PatchRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.RemoveAssociationFirewallPolicyRequest;
import com.google.cloud.compute.v1.RemoveRuleFirewallPolicyRequest;
import com.google.cloud.compute.v1.SetIamPolicyFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestIamPermissionsFirewallPolicyRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.FirewallPoliciesStub;
import com.google.cloud.compute.v1.stub.FirewallPoliciesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class FirewallPoliciesClient
implements BackgroundResource {
    private final FirewallPoliciesSettings settings;
    private final FirewallPoliciesStub stub;

    public static final FirewallPoliciesClient create() throws IOException {
        return FirewallPoliciesClient.create(FirewallPoliciesSettings.newBuilder().build());
    }

    public static final FirewallPoliciesClient create(FirewallPoliciesSettings settings) throws IOException {
        return new FirewallPoliciesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final FirewallPoliciesClient create(FirewallPoliciesStub stub) {
        return new FirewallPoliciesClient(stub);
    }

    protected FirewallPoliciesClient(FirewallPoliciesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FirewallPoliciesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected FirewallPoliciesClient(FirewallPoliciesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FirewallPoliciesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirewallPoliciesStub getStub() {
        return this.stub;
    }

    public final Operation addAssociation(String firewallPolicy, FirewallPolicyAssociation firewallPolicyAssociationResource) {
        AddAssociationFirewallPolicyRequest request = AddAssociationFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).setFirewallPolicyAssociationResource(firewallPolicyAssociationResource).build();
        return this.addAssociation(request);
    }

    public final Operation addAssociation(AddAssociationFirewallPolicyRequest request) {
        return (Operation)this.addAssociationCallable().call((Object)request);
    }

    public final UnaryCallable<AddAssociationFirewallPolicyRequest, Operation> addAssociationCallable() {
        return this.stub.addAssociationCallable();
    }

    public final Operation addRule(String firewallPolicy, FirewallPolicyRule firewallPolicyRuleResource) {
        AddRuleFirewallPolicyRequest request = AddRuleFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).setFirewallPolicyRuleResource(firewallPolicyRuleResource).build();
        return this.addRule(request);
    }

    public final Operation addRule(AddRuleFirewallPolicyRequest request) {
        return (Operation)this.addRuleCallable().call((Object)request);
    }

    public final UnaryCallable<AddRuleFirewallPolicyRequest, Operation> addRuleCallable() {
        return this.stub.addRuleCallable();
    }

    public final Operation cloneRules(String firewallPolicy) {
        CloneRulesFirewallPolicyRequest request = CloneRulesFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.cloneRules(request);
    }

    public final Operation cloneRules(CloneRulesFirewallPolicyRequest request) {
        return (Operation)this.cloneRulesCallable().call((Object)request);
    }

    public final UnaryCallable<CloneRulesFirewallPolicyRequest, Operation> cloneRulesCallable() {
        return this.stub.cloneRulesCallable();
    }

    public final Operation delete(String firewallPolicy) {
        DeleteFirewallPolicyRequest request = DeleteFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteFirewallPolicyRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteFirewallPolicyRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final FirewallPolicy get(String firewallPolicy) {
        GetFirewallPolicyRequest request = GetFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.get(request);
    }

    public final FirewallPolicy get(GetFirewallPolicyRequest request) {
        return (FirewallPolicy)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetFirewallPolicyRequest, FirewallPolicy> getCallable() {
        return this.stub.getCallable();
    }

    public final FirewallPolicyAssociation getAssociation(String firewallPolicy) {
        GetAssociationFirewallPolicyRequest request = GetAssociationFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.getAssociation(request);
    }

    public final FirewallPolicyAssociation getAssociation(GetAssociationFirewallPolicyRequest request) {
        return (FirewallPolicyAssociation)this.getAssociationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAssociationFirewallPolicyRequest, FirewallPolicyAssociation> getAssociationCallable() {
        return this.stub.getAssociationCallable();
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyFirewallPolicyRequest request = GetIamPolicyFirewallPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyFirewallPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyFirewallPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final FirewallPolicyRule getRule(String firewallPolicy) {
        GetRuleFirewallPolicyRequest request = GetRuleFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.getRule(request);
    }

    public final FirewallPolicyRule getRule(GetRuleFirewallPolicyRequest request) {
        return (FirewallPolicyRule)this.getRuleCallable().call((Object)request);
    }

    public final UnaryCallable<GetRuleFirewallPolicyRequest, FirewallPolicyRule> getRuleCallable() {
        return this.stub.getRuleCallable();
    }

    public final Operation insert(FirewallPolicy firewallPolicyResource) {
        InsertFirewallPolicyRequest request = InsertFirewallPolicyRequest.newBuilder().setFirewallPolicyResource(firewallPolicyResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertFirewallPolicyRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertFirewallPolicyRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list() {
        ListFirewallPoliciesRequest request = ListFirewallPoliciesRequest.newBuilder().build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListFirewallPoliciesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFirewallPoliciesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListFirewallPoliciesRequest, FirewallPolicyList> listCallable() {
        return this.stub.listCallable();
    }

    public final FirewallPoliciesListAssociationsResponse listAssociations() {
        ListAssociationsFirewallPolicyRequest request = ListAssociationsFirewallPolicyRequest.newBuilder().build();
        return this.listAssociations(request);
    }

    public final FirewallPoliciesListAssociationsResponse listAssociations(ListAssociationsFirewallPolicyRequest request) {
        return (FirewallPoliciesListAssociationsResponse)this.listAssociationsCallable().call((Object)request);
    }

    public final UnaryCallable<ListAssociationsFirewallPolicyRequest, FirewallPoliciesListAssociationsResponse> listAssociationsCallable() {
        return this.stub.listAssociationsCallable();
    }

    public final Operation move(String firewallPolicy) {
        MoveFirewallPolicyRequest request = MoveFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.move(request);
    }

    public final Operation move(MoveFirewallPolicyRequest request) {
        return (Operation)this.moveCallable().call((Object)request);
    }

    public final UnaryCallable<MoveFirewallPolicyRequest, Operation> moveCallable() {
        return this.stub.moveCallable();
    }

    public final Operation patch(String firewallPolicy, FirewallPolicy firewallPolicyResource) {
        PatchFirewallPolicyRequest request = PatchFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).setFirewallPolicyResource(firewallPolicyResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchFirewallPolicyRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchFirewallPolicyRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation patchRule(String firewallPolicy, FirewallPolicyRule firewallPolicyRuleResource) {
        PatchRuleFirewallPolicyRequest request = PatchRuleFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).setFirewallPolicyRuleResource(firewallPolicyRuleResource).build();
        return this.patchRule(request);
    }

    public final Operation patchRule(PatchRuleFirewallPolicyRequest request) {
        return (Operation)this.patchRuleCallable().call((Object)request);
    }

    public final UnaryCallable<PatchRuleFirewallPolicyRequest, Operation> patchRuleCallable() {
        return this.stub.patchRuleCallable();
    }

    public final Operation removeAssociation(String firewallPolicy) {
        RemoveAssociationFirewallPolicyRequest request = RemoveAssociationFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.removeAssociation(request);
    }

    public final Operation removeAssociation(RemoveAssociationFirewallPolicyRequest request) {
        return (Operation)this.removeAssociationCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveAssociationFirewallPolicyRequest, Operation> removeAssociationCallable() {
        return this.stub.removeAssociationCallable();
    }

    public final Operation removeRule(String firewallPolicy) {
        RemoveRuleFirewallPolicyRequest request = RemoveRuleFirewallPolicyRequest.newBuilder().setFirewallPolicy(firewallPolicy).build();
        return this.removeRule(request);
    }

    public final Operation removeRule(RemoveRuleFirewallPolicyRequest request) {
        return (Operation)this.removeRuleCallable().call((Object)request);
    }

    public final UnaryCallable<RemoveRuleFirewallPolicyRequest, Operation> removeRuleCallable() {
        return this.stub.removeRuleCallable();
    }

    public final Policy setIamPolicy(String resource, GlobalOrganizationSetPolicyRequest globalOrganizationSetPolicyRequestResource) {
        SetIamPolicyFirewallPolicyRequest request = SetIamPolicyFirewallPolicyRequest.newBuilder().setResource(resource).setGlobalOrganizationSetPolicyRequestResource(globalOrganizationSetPolicyRequestResource).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyFirewallPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyFirewallPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsFirewallPolicyRequest request = TestIamPermissionsFirewallPolicyRequest.newBuilder().setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsFirewallPolicyRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsFirewallPolicyRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage> {
        private ListPage(PageContext<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, FirewallPolicyList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, FirewallPolicyList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, ApiFuture<FirewallPolicyList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListFirewallPoliciesRequest, FirewallPolicyList, FirewallPolicy> context, ApiFuture<FirewallPolicyList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

