/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DisableXpnHostProjectRequest;
import com.google.cloud.compute.v1.DisableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.EnableXpnHostProjectRequest;
import com.google.cloud.compute.v1.EnableXpnResourceProjectRequest;
import com.google.cloud.compute.v1.GetProjectRequest;
import com.google.cloud.compute.v1.GetXpnHostProjectRequest;
import com.google.cloud.compute.v1.GetXpnResourcesProjectsRequest;
import com.google.cloud.compute.v1.ListXpnHostsProjectsRequest;
import com.google.cloud.compute.v1.MoveDiskProjectRequest;
import com.google.cloud.compute.v1.MoveInstanceProjectRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Project;
import com.google.cloud.compute.v1.ProjectsClient;
import com.google.cloud.compute.v1.ProjectsGetXpnResources;
import com.google.cloud.compute.v1.SetCommonInstanceMetadataProjectRequest;
import com.google.cloud.compute.v1.SetDefaultNetworkTierProjectRequest;
import com.google.cloud.compute.v1.SetUsageExportBucketProjectRequest;
import com.google.cloud.compute.v1.XpnHostList;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalOperationsStub;
import com.google.cloud.compute.v1.stub.HttpJsonProjectsCallableFactory;
import com.google.cloud.compute.v1.stub.ProjectsStub;
import com.google.cloud.compute.v1.stub.ProjectsStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonProjectsStub
extends ProjectsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Operation.getDescriptor()).build();
    private static final ApiMethodDescriptor<DisableXpnHostProjectRequest, Operation> disableXpnHostMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/DisableXpnHost").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/disableXpnHost", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<DisableXpnResourceProjectRequest, Operation> disableXpnResourceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/DisableXpnResource").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/disableXpnResource", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("projectsDisableXpnResourceRequestResource", (Message)request.getProjectsDisableXpnResourceRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<EnableXpnHostProjectRequest, Operation> enableXpnHostMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/EnableXpnHost").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/enableXpnHost", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<EnableXpnResourceProjectRequest, Operation> enableXpnResourceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/EnableXpnResource").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/enableXpnResource", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("projectsEnableXpnResourceRequestResource", (Message)request.getProjectsEnableXpnResourceRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<GetProjectRequest, Project> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/Get").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Project.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetXpnHostProjectRequest, Project> getXpnHostMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/GetXpnHost").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/getXpnHost", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Project.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources> getXpnResourcesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/GetXpnResources").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/getXpnResources", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ProjectsGetXpnResources.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListXpnHostsProjectsRequest, XpnHostList> listXpnHostsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/ListXpnHosts").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/listXpnHosts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasFilter()) {
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        }
        if (request.hasMaxResults()) {
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
        }
        if (request.hasOrderBy()) {
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        }
        if (request.hasPageToken()) {
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        }
        if (request.hasReturnPartialSuccess()) {
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("projectsListXpnHostsRequestResource", (Message)request.getProjectsListXpnHostsRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)XpnHostList.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<MoveDiskProjectRequest, Operation> moveDiskMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/MoveDisk").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/moveDisk", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("diskMoveRequestResource", (Message)request.getDiskMoveRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<MoveInstanceProjectRequest, Operation> moveInstanceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/MoveInstance").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/moveInstance", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("instanceMoveRequestResource", (Message)request.getInstanceMoveRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/SetCommonInstanceMetadata").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/setCommonInstanceMetadata", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("metadataResource", (Message)request.getMetadataResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/SetDefaultNetworkTier").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/setDefaultNetworkTier", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("projectsSetDefaultNetworkTierRequestResource", (Message)request.getProjectsSetDefaultNetworkTierRequestResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private static final ApiMethodDescriptor<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Projects/SetUsageExportBucket").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/setUsageExportBucket", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "project", (Object)request.getProject());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        if (request.hasRequestId()) {
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        }
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("usageExportLocationResource", (Message)request.getUsageExportLocationResource())).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> {
        StringBuilder opName = new StringBuilder(response.getName());
        opName.append(":").append(request.getProject());
        return HttpJsonOperationSnapshot.newBuilder().setName(opName.toString()).setMetadata(response).setDone(Operation.Status.DONE.equals((Object)response.getStatus())).setResponse(response).setError(response.getHttpErrorStatusCode(), response.getHttpErrorMessage()).build();
    }).build();
    private final UnaryCallable<DisableXpnHostProjectRequest, Operation> disableXpnHostCallable;
    private final OperationCallable<DisableXpnHostProjectRequest, Operation, Operation> disableXpnHostOperationCallable;
    private final UnaryCallable<DisableXpnResourceProjectRequest, Operation> disableXpnResourceCallable;
    private final OperationCallable<DisableXpnResourceProjectRequest, Operation, Operation> disableXpnResourceOperationCallable;
    private final UnaryCallable<EnableXpnHostProjectRequest, Operation> enableXpnHostCallable;
    private final OperationCallable<EnableXpnHostProjectRequest, Operation, Operation> enableXpnHostOperationCallable;
    private final UnaryCallable<EnableXpnResourceProjectRequest, Operation> enableXpnResourceCallable;
    private final OperationCallable<EnableXpnResourceProjectRequest, Operation, Operation> enableXpnResourceOperationCallable;
    private final UnaryCallable<GetProjectRequest, Project> getCallable;
    private final UnaryCallable<GetXpnHostProjectRequest, Project> getXpnHostCallable;
    private final UnaryCallable<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources> getXpnResourcesCallable;
    private final UnaryCallable<GetXpnResourcesProjectsRequest, ProjectsClient.GetXpnResourcesPagedResponse> getXpnResourcesPagedCallable;
    private final UnaryCallable<ListXpnHostsProjectsRequest, XpnHostList> listXpnHostsCallable;
    private final UnaryCallable<ListXpnHostsProjectsRequest, ProjectsClient.ListXpnHostsPagedResponse> listXpnHostsPagedCallable;
    private final UnaryCallable<MoveDiskProjectRequest, Operation> moveDiskCallable;
    private final OperationCallable<MoveDiskProjectRequest, Operation, Operation> moveDiskOperationCallable;
    private final UnaryCallable<MoveInstanceProjectRequest, Operation> moveInstanceCallable;
    private final OperationCallable<MoveInstanceProjectRequest, Operation, Operation> moveInstanceOperationCallable;
    private final UnaryCallable<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataCallable;
    private final OperationCallable<SetCommonInstanceMetadataProjectRequest, Operation, Operation> setCommonInstanceMetadataOperationCallable;
    private final UnaryCallable<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierCallable;
    private final OperationCallable<SetDefaultNetworkTierProjectRequest, Operation, Operation> setDefaultNetworkTierOperationCallable;
    private final UnaryCallable<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketCallable;
    private final OperationCallable<SetUsageExportBucketProjectRequest, Operation, Operation> setUsageExportBucketOperationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonGlobalOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonProjectsStub create(ProjectsStubSettings settings) throws IOException {
        return new HttpJsonProjectsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonProjectsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonProjectsStub(ProjectsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonProjectsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonProjectsStub(ProjectsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonProjectsStub(ProjectsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonProjectsCallableFactory());
    }

    protected HttpJsonProjectsStub(ProjectsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonGlobalOperationsStub.create(clientContext, callableFactory);
        HttpJsonCallSettings disableXpnHostTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(disableXpnHostMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings disableXpnResourceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(disableXpnResourceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings enableXpnHostTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(enableXpnHostMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings enableXpnResourceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(enableXpnResourceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getXpnHostTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getXpnHostMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getXpnResourcesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getXpnResourcesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listXpnHostsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listXpnHostsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings moveDiskTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(moveDiskMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings moveInstanceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(moveInstanceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setCommonInstanceMetadataTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setCommonInstanceMetadataMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setDefaultNetworkTierTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setDefaultNetworkTierMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setUsageExportBucketTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setUsageExportBucketMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.disableXpnHostCallable = callableFactory.createUnaryCallable(disableXpnHostTransportSettings, settings.disableXpnHostSettings(), clientContext);
        this.disableXpnHostOperationCallable = callableFactory.createOperationCallable(disableXpnHostTransportSettings, settings.disableXpnHostOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.disableXpnResourceCallable = callableFactory.createUnaryCallable(disableXpnResourceTransportSettings, settings.disableXpnResourceSettings(), clientContext);
        this.disableXpnResourceOperationCallable = callableFactory.createOperationCallable(disableXpnResourceTransportSettings, settings.disableXpnResourceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.enableXpnHostCallable = callableFactory.createUnaryCallable(enableXpnHostTransportSettings, settings.enableXpnHostSettings(), clientContext);
        this.enableXpnHostOperationCallable = callableFactory.createOperationCallable(enableXpnHostTransportSettings, settings.enableXpnHostOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.enableXpnResourceCallable = callableFactory.createUnaryCallable(enableXpnResourceTransportSettings, settings.enableXpnResourceSettings(), clientContext);
        this.enableXpnResourceOperationCallable = callableFactory.createOperationCallable(enableXpnResourceTransportSettings, settings.enableXpnResourceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getXpnHostCallable = callableFactory.createUnaryCallable(getXpnHostTransportSettings, settings.getXpnHostSettings(), clientContext);
        this.getXpnResourcesCallable = callableFactory.createUnaryCallable(getXpnResourcesTransportSettings, settings.getXpnResourcesSettings(), clientContext);
        this.getXpnResourcesPagedCallable = callableFactory.createPagedCallable(getXpnResourcesTransportSettings, settings.getXpnResourcesSettings(), clientContext);
        this.listXpnHostsCallable = callableFactory.createUnaryCallable(listXpnHostsTransportSettings, settings.listXpnHostsSettings(), clientContext);
        this.listXpnHostsPagedCallable = callableFactory.createPagedCallable(listXpnHostsTransportSettings, settings.listXpnHostsSettings(), clientContext);
        this.moveDiskCallable = callableFactory.createUnaryCallable(moveDiskTransportSettings, settings.moveDiskSettings(), clientContext);
        this.moveDiskOperationCallable = callableFactory.createOperationCallable(moveDiskTransportSettings, settings.moveDiskOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.moveInstanceCallable = callableFactory.createUnaryCallable(moveInstanceTransportSettings, settings.moveInstanceSettings(), clientContext);
        this.moveInstanceOperationCallable = callableFactory.createOperationCallable(moveInstanceTransportSettings, settings.moveInstanceOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setCommonInstanceMetadataCallable = callableFactory.createUnaryCallable(setCommonInstanceMetadataTransportSettings, settings.setCommonInstanceMetadataSettings(), clientContext);
        this.setCommonInstanceMetadataOperationCallable = callableFactory.createOperationCallable(setCommonInstanceMetadataTransportSettings, settings.setCommonInstanceMetadataOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setDefaultNetworkTierCallable = callableFactory.createUnaryCallable(setDefaultNetworkTierTransportSettings, settings.setDefaultNetworkTierSettings(), clientContext);
        this.setDefaultNetworkTierOperationCallable = callableFactory.createOperationCallable(setDefaultNetworkTierTransportSettings, settings.setDefaultNetworkTierOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.setUsageExportBucketCallable = callableFactory.createUnaryCallable(setUsageExportBucketTransportSettings, settings.setUsageExportBucketSettings(), clientContext);
        this.setUsageExportBucketOperationCallable = callableFactory.createOperationCallable(setUsageExportBucketTransportSettings, settings.setUsageExportBucketOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(disableXpnHostMethodDescriptor);
        methodDescriptors.add(disableXpnResourceMethodDescriptor);
        methodDescriptors.add(enableXpnHostMethodDescriptor);
        methodDescriptors.add(enableXpnResourceMethodDescriptor);
        methodDescriptors.add(getMethodDescriptor);
        methodDescriptors.add(getXpnHostMethodDescriptor);
        methodDescriptors.add(getXpnResourcesMethodDescriptor);
        methodDescriptors.add(listXpnHostsMethodDescriptor);
        methodDescriptors.add(moveDiskMethodDescriptor);
        methodDescriptors.add(moveInstanceMethodDescriptor);
        methodDescriptors.add(setCommonInstanceMetadataMethodDescriptor);
        methodDescriptors.add(setDefaultNetworkTierMethodDescriptor);
        methodDescriptors.add(setUsageExportBucketMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<DisableXpnHostProjectRequest, Operation> disableXpnHostCallable() {
        return this.disableXpnHostCallable;
    }

    @Override
    public OperationCallable<DisableXpnHostProjectRequest, Operation, Operation> disableXpnHostOperationCallable() {
        return this.disableXpnHostOperationCallable;
    }

    @Override
    public UnaryCallable<DisableXpnResourceProjectRequest, Operation> disableXpnResourceCallable() {
        return this.disableXpnResourceCallable;
    }

    @Override
    public OperationCallable<DisableXpnResourceProjectRequest, Operation, Operation> disableXpnResourceOperationCallable() {
        return this.disableXpnResourceOperationCallable;
    }

    @Override
    public UnaryCallable<EnableXpnHostProjectRequest, Operation> enableXpnHostCallable() {
        return this.enableXpnHostCallable;
    }

    @Override
    public OperationCallable<EnableXpnHostProjectRequest, Operation, Operation> enableXpnHostOperationCallable() {
        return this.enableXpnHostOperationCallable;
    }

    @Override
    public UnaryCallable<EnableXpnResourceProjectRequest, Operation> enableXpnResourceCallable() {
        return this.enableXpnResourceCallable;
    }

    @Override
    public OperationCallable<EnableXpnResourceProjectRequest, Operation, Operation> enableXpnResourceOperationCallable() {
        return this.enableXpnResourceOperationCallable;
    }

    @Override
    public UnaryCallable<GetProjectRequest, Project> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetXpnHostProjectRequest, Project> getXpnHostCallable() {
        return this.getXpnHostCallable;
    }

    @Override
    public UnaryCallable<GetXpnResourcesProjectsRequest, ProjectsGetXpnResources> getXpnResourcesCallable() {
        return this.getXpnResourcesCallable;
    }

    @Override
    public UnaryCallable<GetXpnResourcesProjectsRequest, ProjectsClient.GetXpnResourcesPagedResponse> getXpnResourcesPagedCallable() {
        return this.getXpnResourcesPagedCallable;
    }

    @Override
    public UnaryCallable<ListXpnHostsProjectsRequest, XpnHostList> listXpnHostsCallable() {
        return this.listXpnHostsCallable;
    }

    @Override
    public UnaryCallable<ListXpnHostsProjectsRequest, ProjectsClient.ListXpnHostsPagedResponse> listXpnHostsPagedCallable() {
        return this.listXpnHostsPagedCallable;
    }

    @Override
    public UnaryCallable<MoveDiskProjectRequest, Operation> moveDiskCallable() {
        return this.moveDiskCallable;
    }

    @Override
    public OperationCallable<MoveDiskProjectRequest, Operation, Operation> moveDiskOperationCallable() {
        return this.moveDiskOperationCallable;
    }

    @Override
    public UnaryCallable<MoveInstanceProjectRequest, Operation> moveInstanceCallable() {
        return this.moveInstanceCallable;
    }

    @Override
    public OperationCallable<MoveInstanceProjectRequest, Operation, Operation> moveInstanceOperationCallable() {
        return this.moveInstanceOperationCallable;
    }

    @Override
    public UnaryCallable<SetCommonInstanceMetadataProjectRequest, Operation> setCommonInstanceMetadataCallable() {
        return this.setCommonInstanceMetadataCallable;
    }

    @Override
    public OperationCallable<SetCommonInstanceMetadataProjectRequest, Operation, Operation> setCommonInstanceMetadataOperationCallable() {
        return this.setCommonInstanceMetadataOperationCallable;
    }

    @Override
    public UnaryCallable<SetDefaultNetworkTierProjectRequest, Operation> setDefaultNetworkTierCallable() {
        return this.setDefaultNetworkTierCallable;
    }

    @Override
    public OperationCallable<SetDefaultNetworkTierProjectRequest, Operation, Operation> setDefaultNetworkTierOperationCallable() {
        return this.setDefaultNetworkTierOperationCallable;
    }

    @Override
    public UnaryCallable<SetUsageExportBucketProjectRequest, Operation> setUsageExportBucketCallable() {
        return this.setUsageExportBucketCallable;
    }

    @Override
    public OperationCallable<SetUsageExportBucketProjectRequest, Operation, Operation> setUsageExportBucketOperationCallable() {
        return this.setUsageExportBucketOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

