/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.DeleteGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.ForwardingRule;
import com.google.cloud.compute.v1.ForwardingRuleList;
import com.google.cloud.compute.v1.GetGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.GlobalForwardingRulesSettings;
import com.google.cloud.compute.v1.InsertGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.ListGlobalForwardingRulesRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.SetTargetGlobalForwardingRuleRequest;
import com.google.cloud.compute.v1.TargetReference;
import com.google.cloud.compute.v1.stub.GlobalForwardingRulesStub;
import com.google.cloud.compute.v1.stub.GlobalForwardingRulesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GlobalForwardingRulesClient
implements BackgroundResource {
    private final GlobalForwardingRulesSettings settings;
    private final GlobalForwardingRulesStub stub;

    public static final GlobalForwardingRulesClient create() throws IOException {
        return GlobalForwardingRulesClient.create(GlobalForwardingRulesSettings.newBuilder().build());
    }

    public static final GlobalForwardingRulesClient create(GlobalForwardingRulesSettings settings) throws IOException {
        return new GlobalForwardingRulesClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GlobalForwardingRulesClient create(GlobalForwardingRulesStub stub) {
        return new GlobalForwardingRulesClient(stub);
    }

    protected GlobalForwardingRulesClient(GlobalForwardingRulesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GlobalForwardingRulesStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GlobalForwardingRulesClient(GlobalForwardingRulesStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final GlobalForwardingRulesSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalForwardingRulesStub getStub() {
        return this.stub;
    }

    public final Operation delete(String project, String forwardingRule) {
        DeleteGlobalForwardingRuleRequest request = DeleteGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteGlobalForwardingRuleRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteGlobalForwardingRuleRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final ForwardingRule get(String project, String forwardingRule) {
        GetGlobalForwardingRuleRequest request = GetGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).build();
        return this.get(request);
    }

    public final ForwardingRule get(GetGlobalForwardingRuleRequest request) {
        return (ForwardingRule)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetGlobalForwardingRuleRequest, ForwardingRule> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, ForwardingRule forwardingRuleResource) {
        InsertGlobalForwardingRuleRequest request = InsertGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRuleResource(forwardingRuleResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertGlobalForwardingRuleRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertGlobalForwardingRuleRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project) {
        ListGlobalForwardingRulesRequest request = ListGlobalForwardingRulesRequest.newBuilder().setProject(project).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListGlobalForwardingRulesRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGlobalForwardingRulesRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListGlobalForwardingRulesRequest, ForwardingRuleList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String forwardingRule, ForwardingRule forwardingRuleResource) {
        PatchGlobalForwardingRuleRequest request = PatchGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).setForwardingRuleResource(forwardingRuleResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchGlobalForwardingRuleRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchGlobalForwardingRuleRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation setTarget(String project, String forwardingRule, TargetReference targetReferenceResource) {
        SetTargetGlobalForwardingRuleRequest request = SetTargetGlobalForwardingRuleRequest.newBuilder().setProject(project).setForwardingRule(forwardingRule).setTargetReferenceResource(targetReferenceResource).build();
        return this.setTarget(request);
    }

    public final Operation setTarget(SetTargetGlobalForwardingRuleRequest request) {
        return (Operation)this.setTargetCallable().call((Object)request);
    }

    public final UnaryCallable<SetTargetGlobalForwardingRuleRequest, Operation> setTargetCallable() {
        return this.stub.setTargetCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage> {
        private ListPage(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ForwardingRuleList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListGlobalForwardingRulesRequest, ForwardingRuleList, ForwardingRule> context, ApiFuture<ForwardingRuleList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }
}

