/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListPacketMirroringsRequest;
import com.google.cloud.compute.v1.DeletePacketMirroringRequest;
import com.google.cloud.compute.v1.GetPacketMirroringRequest;
import com.google.cloud.compute.v1.InsertPacketMirroringRequest;
import com.google.cloud.compute.v1.ListPacketMirroringsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PacketMirroring;
import com.google.cloud.compute.v1.PacketMirroringAggregatedList;
import com.google.cloud.compute.v1.PacketMirroringList;
import com.google.cloud.compute.v1.PacketMirroringsScopedList;
import com.google.cloud.compute.v1.PacketMirroringsSettings;
import com.google.cloud.compute.v1.PatchPacketMirroringRequest;
import com.google.cloud.compute.v1.TestIamPermissionsPacketMirroringRequest;
import com.google.cloud.compute.v1.TestPermissionsRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.PacketMirroringsStub;
import com.google.cloud.compute.v1.stub.PacketMirroringsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class PacketMirroringsClient
implements BackgroundResource {
    private final PacketMirroringsSettings settings;
    private final PacketMirroringsStub stub;

    public static final PacketMirroringsClient create() throws IOException {
        return PacketMirroringsClient.create(PacketMirroringsSettings.newBuilder().build());
    }

    public static final PacketMirroringsClient create(PacketMirroringsSettings settings) throws IOException {
        return new PacketMirroringsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final PacketMirroringsClient create(PacketMirroringsStub stub) {
        return new PacketMirroringsClient(stub);
    }

    protected PacketMirroringsClient(PacketMirroringsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PacketMirroringsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected PacketMirroringsClient(PacketMirroringsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PacketMirroringsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public PacketMirroringsStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListPacketMirroringsRequest request = AggregatedListPacketMirroringsRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListPacketMirroringsRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListPacketMirroringsRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String region, String packetMirroring) {
        DeletePacketMirroringRequest request = DeletePacketMirroringRequest.newBuilder().setProject(project).setRegion(region).setPacketMirroring(packetMirroring).build();
        return this.delete(request);
    }

    public final Operation delete(DeletePacketMirroringRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeletePacketMirroringRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final PacketMirroring get(String project, String region, String packetMirroring) {
        GetPacketMirroringRequest request = GetPacketMirroringRequest.newBuilder().setProject(project).setRegion(region).setPacketMirroring(packetMirroring).build();
        return this.get(request);
    }

    public final PacketMirroring get(GetPacketMirroringRequest request) {
        return (PacketMirroring)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetPacketMirroringRequest, PacketMirroring> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String region, PacketMirroring packetMirroringResource) {
        InsertPacketMirroringRequest request = InsertPacketMirroringRequest.newBuilder().setProject(project).setRegion(region).setPacketMirroringResource(packetMirroringResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertPacketMirroringRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertPacketMirroringRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String region) {
        ListPacketMirroringsRequest request = ListPacketMirroringsRequest.newBuilder().setProject(project).setRegion(region).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListPacketMirroringsRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPacketMirroringsRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListPacketMirroringsRequest, PacketMirroringList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String region, String packetMirroring, PacketMirroring packetMirroringResource) {
        PatchPacketMirroringRequest request = PatchPacketMirroringRequest.newBuilder().setProject(project).setRegion(region).setPacketMirroring(packetMirroring).setPacketMirroringResource(packetMirroringResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchPacketMirroringRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchPacketMirroringRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final TestPermissionsResponse testIamPermissions(String project, String region, String resource, TestPermissionsRequest testPermissionsRequestResource) {
        TestIamPermissionsPacketMirroringRequest request = TestIamPermissionsPacketMirroringRequest.newBuilder().setProject(project).setRegion(region).setResource(resource).setTestPermissionsRequestResource(testPermissionsRequestResource).build();
        return this.testIamPermissions(request);
    }

    public final TestPermissionsResponse testIamPermissions(TestIamPermissionsPacketMirroringRequest request) {
        return (TestPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsPacketMirroringRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring, ListPage> {
        private ListPage(PageContext<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring> context, PacketMirroringList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring> context, PacketMirroringList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring> context, ApiFuture<PacketMirroringList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListPacketMirroringsRequest, PacketMirroringList, PacketMirroring> context, ApiFuture<PacketMirroringList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>> context, PacketMirroringAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>> context, PacketMirroringAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>> context, ApiFuture<PacketMirroringAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListPacketMirroringsRequest, PacketMirroringAggregatedList, Map.Entry<String, PacketMirroringsScopedList>> context, ApiFuture<PacketMirroringAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

