/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListAutoscalersRequest;
import com.google.cloud.compute.v1.Autoscaler;
import com.google.cloud.compute.v1.AutoscalerAggregatedList;
import com.google.cloud.compute.v1.AutoscalerList;
import com.google.cloud.compute.v1.AutoscalersScopedList;
import com.google.cloud.compute.v1.AutoscalersSettings;
import com.google.cloud.compute.v1.DeleteAutoscalerRequest;
import com.google.cloud.compute.v1.GetAutoscalerRequest;
import com.google.cloud.compute.v1.InsertAutoscalerRequest;
import com.google.cloud.compute.v1.ListAutoscalersRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchAutoscalerRequest;
import com.google.cloud.compute.v1.UpdateAutoscalerRequest;
import com.google.cloud.compute.v1.stub.AutoscalersStub;
import com.google.cloud.compute.v1.stub.AutoscalersStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AutoscalersClient
implements BackgroundResource {
    private final AutoscalersSettings settings;
    private final AutoscalersStub stub;

    public static final AutoscalersClient create() throws IOException {
        return AutoscalersClient.create(AutoscalersSettings.newBuilder().build());
    }

    public static final AutoscalersClient create(AutoscalersSettings settings) throws IOException {
        return new AutoscalersClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AutoscalersClient create(AutoscalersStub stub) {
        return new AutoscalersClient(stub);
    }

    protected AutoscalersClient(AutoscalersSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AutoscalersStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AutoscalersClient(AutoscalersStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AutoscalersSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AutoscalersStub getStub() {
        return this.stub;
    }

    public final AggregatedListPagedResponse aggregatedList(String project) {
        AggregatedListAutoscalersRequest request = AggregatedListAutoscalersRequest.newBuilder().setProject(project).build();
        return this.aggregatedList(request);
    }

    public final AggregatedListPagedResponse aggregatedList(AggregatedListAutoscalersRequest request) {
        return (AggregatedListPagedResponse)((Object)this.aggregatedListPagedCallable().call((Object)request));
    }

    public final UnaryCallable<AggregatedListAutoscalersRequest, AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.stub.aggregatedListPagedCallable();
    }

    public final UnaryCallable<AggregatedListAutoscalersRequest, AutoscalerAggregatedList> aggregatedListCallable() {
        return this.stub.aggregatedListCallable();
    }

    public final Operation delete(String project, String zone, String autoscaler) {
        DeleteAutoscalerRequest request = DeleteAutoscalerRequest.newBuilder().setProject(project).setZone(zone).setAutoscaler(autoscaler).build();
        return this.delete(request);
    }

    public final Operation delete(DeleteAutoscalerRequest request) {
        return (Operation)this.deleteCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAutoscalerRequest, Operation> deleteCallable() {
        return this.stub.deleteCallable();
    }

    public final Autoscaler get(String project, String zone, String autoscaler) {
        GetAutoscalerRequest request = GetAutoscalerRequest.newBuilder().setProject(project).setZone(zone).setAutoscaler(autoscaler).build();
        return this.get(request);
    }

    public final Autoscaler get(GetAutoscalerRequest request) {
        return (Autoscaler)this.getCallable().call((Object)request);
    }

    public final UnaryCallable<GetAutoscalerRequest, Autoscaler> getCallable() {
        return this.stub.getCallable();
    }

    public final Operation insert(String project, String zone, Autoscaler autoscalerResource) {
        InsertAutoscalerRequest request = InsertAutoscalerRequest.newBuilder().setProject(project).setZone(zone).setAutoscalerResource(autoscalerResource).build();
        return this.insert(request);
    }

    public final Operation insert(InsertAutoscalerRequest request) {
        return (Operation)this.insertCallable().call((Object)request);
    }

    public final UnaryCallable<InsertAutoscalerRequest, Operation> insertCallable() {
        return this.stub.insertCallable();
    }

    public final ListPagedResponse list(String project, String zone) {
        ListAutoscalersRequest request = ListAutoscalersRequest.newBuilder().setProject(project).setZone(zone).build();
        return this.list(request);
    }

    public final ListPagedResponse list(ListAutoscalersRequest request) {
        return (ListPagedResponse)((Object)this.listPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutoscalersRequest, ListPagedResponse> listPagedCallable() {
        return this.stub.listPagedCallable();
    }

    public final UnaryCallable<ListAutoscalersRequest, AutoscalerList> listCallable() {
        return this.stub.listCallable();
    }

    public final Operation patch(String project, String zone, Autoscaler autoscalerResource) {
        PatchAutoscalerRequest request = PatchAutoscalerRequest.newBuilder().setProject(project).setZone(zone).setAutoscalerResource(autoscalerResource).build();
        return this.patch(request);
    }

    public final Operation patch(PatchAutoscalerRequest request) {
        return (Operation)this.patchCallable().call((Object)request);
    }

    public final UnaryCallable<PatchAutoscalerRequest, Operation> patchCallable() {
        return this.stub.patchCallable();
    }

    public final Operation update(String project, String zone, Autoscaler autoscalerResource) {
        UpdateAutoscalerRequest request = UpdateAutoscalerRequest.newBuilder().setProject(project).setZone(zone).setAutoscalerResource(autoscalerResource).build();
        return this.update(request);
    }

    public final Operation update(UpdateAutoscalerRequest request) {
        return (Operation)this.updateCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAutoscalerRequest, Operation> updateCallable() {
        return this.stub.updateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutoscalersRequest, AutoscalerList, Autoscaler, ListPage, ListFixedSizeCollection> {
        private ListFixedSizeCollection(List<ListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFixedSizeCollection createEmptyCollection() {
            return new ListFixedSizeCollection(null, 0);
        }

        protected ListFixedSizeCollection createCollection(List<ListPage> pages, int collectionSize) {
            return new ListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPage
    extends AbstractPage<ListAutoscalersRequest, AutoscalerList, Autoscaler, ListPage> {
        private ListPage(PageContext<ListAutoscalersRequest, AutoscalerList, Autoscaler> context, AutoscalerList response) {
            super(context, (Object)response);
        }

        private static ListPage createEmptyPage() {
            return new ListPage(null, null);
        }

        protected ListPage createPage(PageContext<ListAutoscalersRequest, AutoscalerList, Autoscaler> context, AutoscalerList response) {
            return new ListPage(context, response);
        }

        public ApiFuture<ListPage> createPageAsync(PageContext<ListAutoscalersRequest, AutoscalerList, Autoscaler> context, ApiFuture<AutoscalerList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPagedResponse
    extends AbstractPagedListResponse<ListAutoscalersRequest, AutoscalerList, Autoscaler, ListPage, ListFixedSizeCollection> {
        public static ApiFuture<ListPagedResponse> createAsync(PageContext<ListAutoscalersRequest, AutoscalerList, Autoscaler> context, ApiFuture<AutoscalerList> futureResponse) {
            ApiFuture<ListPage> futurePage = ListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListPage, ListPagedResponse>(){

                public ListPagedResponse apply(ListPage input) {
                    return new ListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListPagedResponse(ListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class AggregatedListFixedSizeCollection
    extends AbstractFixedSizeCollection<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        private AggregatedListFixedSizeCollection(List<AggregatedListPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static AggregatedListFixedSizeCollection createEmptyCollection() {
            return new AggregatedListFixedSizeCollection(null, 0);
        }

        protected AggregatedListFixedSizeCollection createCollection(List<AggregatedListPage> pages, int collectionSize) {
            return new AggregatedListFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class AggregatedListPage
    extends AbstractPage<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>, AggregatedListPage> {
        private AggregatedListPage(PageContext<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>> context, AutoscalerAggregatedList response) {
            super(context, (Object)response);
        }

        private static AggregatedListPage createEmptyPage() {
            return new AggregatedListPage(null, null);
        }

        protected AggregatedListPage createPage(PageContext<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>> context, AutoscalerAggregatedList response) {
            return new AggregatedListPage(context, response);
        }

        public ApiFuture<AggregatedListPage> createPageAsync(PageContext<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>> context, ApiFuture<AutoscalerAggregatedList> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class AggregatedListPagedResponse
    extends AbstractPagedListResponse<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>, AggregatedListPage, AggregatedListFixedSizeCollection> {
        public static ApiFuture<AggregatedListPagedResponse> createAsync(PageContext<AggregatedListAutoscalersRequest, AutoscalerAggregatedList, Map.Entry<String, AutoscalersScopedList>> context, ApiFuture<AutoscalerAggregatedList> futureResponse) {
            ApiFuture<AggregatedListPage> futurePage = AggregatedListPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<AggregatedListPage, AggregatedListPagedResponse>(){

                public AggregatedListPagedResponse apply(AggregatedListPage input) {
                    return new AggregatedListPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private AggregatedListPagedResponse(AggregatedListPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)AggregatedListFixedSizeCollection.createEmptyCollection());
        }
    }
}

