/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.FieldsExtractor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListReservationsRequest;
import com.google.cloud.compute.v1.DeleteReservationRequest;
import com.google.cloud.compute.v1.GetIamPolicyReservationRequest;
import com.google.cloud.compute.v1.GetReservationRequest;
import com.google.cloud.compute.v1.InsertReservationRequest;
import com.google.cloud.compute.v1.ListReservationsRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.Reservation;
import com.google.cloud.compute.v1.ReservationAggregatedList;
import com.google.cloud.compute.v1.ReservationList;
import com.google.cloud.compute.v1.ReservationsClient;
import com.google.cloud.compute.v1.ResizeReservationRequest;
import com.google.cloud.compute.v1.SetIamPolicyReservationRequest;
import com.google.cloud.compute.v1.TestIamPermissionsReservationRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.stub.HttpJsonReservationsCallableFactory;
import com.google.cloud.compute.v1.stub.ReservationsStub;
import com.google.cloud.compute.v1.stub.ReservationsStubSettings;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonReservationsStub
extends ReservationsStub {
    @InternalApi
    public static final ApiMethodDescriptor<AggregatedListReservationsRequest, ReservationAggregatedList> aggregatedListMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.AggregatedList").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/aggregated/reservations", (FieldsExtractor)new FieldsExtractor<AggregatedListReservationsRequest, Map<String, String>>(){

        public Map<String, String> extract(AggregatedListReservationsRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListReservationsRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(AggregatedListReservationsRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            serializer.putQueryParam(fields, "includeAllScopes", (Object)request.getIncludeAllScopes());
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<AggregatedListReservationsRequest, String>(){

        public String extract(AggregatedListReservationsRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReservationAggregatedList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<DeleteReservationRequest, Operation> deleteMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.Delete").setHttpMethod("DELETE").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations/{reservation}", (FieldsExtractor)new FieldsExtractor<DeleteReservationRequest, Map<String, String>>(){

        public Map<String, String> extract(DeleteReservationRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "reservation", (Object)request.getReservation());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<DeleteReservationRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(DeleteReservationRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<DeleteReservationRequest, String>(){

        public String extract(DeleteReservationRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetReservationRequest, Reservation> getMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.Get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations/{reservation}", (FieldsExtractor)new FieldsExtractor<GetReservationRequest, Map<String, String>>(){

        public Map<String, String> extract(GetReservationRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "reservation", (Object)request.getReservation());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetReservationRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetReservationRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetReservationRequest, String>(){

        public String extract(GetReservationRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Reservation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<GetIamPolicyReservationRequest, Policy> getIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.GetIamPolicy").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations/{resource}/getIamPolicy", (FieldsExtractor)new FieldsExtractor<GetIamPolicyReservationRequest, Map<String, String>>(){

        public Map<String, String> extract(GetIamPolicyReservationRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyReservationRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(GetIamPolicyReservationRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "optionsRequestedPolicyVersion", (Object)request.getOptionsRequestedPolicyVersion());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<GetIamPolicyReservationRequest, String>(){

        public String extract(GetIamPolicyReservationRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<InsertReservationRequest, Operation> insertMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.Insert").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations", (FieldsExtractor)new FieldsExtractor<InsertReservationRequest, Map<String, String>>(){

        public Map<String, String> extract(InsertReservationRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<InsertReservationRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(InsertReservationRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<InsertReservationRequest, String>(){

        public String extract(InsertReservationRequest request) {
            return ProtoRestSerializer.create().toBody("reservationResource", (Message)request.getReservationResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListReservationsRequest, ReservationList> listMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.List").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations", (FieldsExtractor)new FieldsExtractor<ListReservationsRequest, Map<String, String>>(){

        public Map<String, String> extract(ListReservationsRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ListReservationsRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ListReservationsRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
            serializer.putQueryParam(fields, "maxResults", (Object)request.getMaxResults());
            serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
            serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
            serializer.putQueryParam(fields, "returnPartialSuccess", (Object)request.getReturnPartialSuccess());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ListReservationsRequest, String>(){

        public String extract(ListReservationsRequest request) {
            return "";
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ReservationList.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ResizeReservationRequest, Operation> resizeMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.Resize").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations/{reservation}/resize", (FieldsExtractor)new FieldsExtractor<ResizeReservationRequest, Map<String, String>>(){

        public Map<String, String> extract(ResizeReservationRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "reservation", (Object)request.getReservation());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<ResizeReservationRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(ResizeReservationRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<ResizeReservationRequest, String>(){

        public String extract(ResizeReservationRequest request) {
            return ProtoRestSerializer.create().toBody("reservationsResizeRequestResource", (Message)request.getReservationsResizeRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<SetIamPolicyReservationRequest, Policy> setIamPolicyMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.SetIamPolicy").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations/{resource}/setIamPolicy", (FieldsExtractor)new FieldsExtractor<SetIamPolicyReservationRequest, Map<String, String>>(){

        public Map<String, String> extract(SetIamPolicyReservationRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyReservationRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(SetIamPolicyReservationRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<SetIamPolicyReservationRequest, String>(){

        public String extract(SetIamPolicyReservationRequest request) {
            return ProtoRestSerializer.create().toBody("zoneSetPolicyRequestResource", (Message)request.getZoneSetPolicyRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Policy.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<TestIamPermissionsReservationRequest, TestPermissionsResponse> testIamPermissionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.compute.v1.Reservations.TestIamPermissions").setHttpMethod("POST").setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/compute/v1/projects/{project}/zones/{zone}/reservations/{resource}/testIamPermissions", (FieldsExtractor)new FieldsExtractor<TestIamPermissionsReservationRequest, Map<String, String>>(){

        public Map<String, String> extract(TestIamPermissionsReservationRequest request) {
            HashMap<String, String> fields = new HashMap<String, String>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            serializer.putPathParam(fields, "project", (Object)request.getProject());
            serializer.putPathParam(fields, "zone", (Object)request.getZone());
            serializer.putPathParam(fields, "resource", (Object)request.getResource());
            return fields;
        }
    }).setQueryParamsExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsReservationRequest, Map<String, List<String>>>(){

        public Map<String, List<String>> extract(TestIamPermissionsReservationRequest request) {
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            ProtoRestSerializer serializer = ProtoRestSerializer.create();
            return fields;
        }
    }).setRequestBodyExtractor((FieldsExtractor)new FieldsExtractor<TestIamPermissionsReservationRequest, String>(){

        public String extract(TestIamPermissionsReservationRequest request) {
            return ProtoRestSerializer.create().toBody("testPermissionsRequestResource", (Message)request.getTestPermissionsRequestResource());
        }
    }).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TestPermissionsResponse.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<AggregatedListReservationsRequest, ReservationAggregatedList> aggregatedListCallable;
    private final UnaryCallable<AggregatedListReservationsRequest, ReservationsClient.AggregatedListPagedResponse> aggregatedListPagedCallable;
    private final UnaryCallable<DeleteReservationRequest, Operation> deleteCallable;
    private final UnaryCallable<GetReservationRequest, Reservation> getCallable;
    private final UnaryCallable<GetIamPolicyReservationRequest, Policy> getIamPolicyCallable;
    private final UnaryCallable<InsertReservationRequest, Operation> insertCallable;
    private final UnaryCallable<ListReservationsRequest, ReservationList> listCallable;
    private final UnaryCallable<ListReservationsRequest, ReservationsClient.ListPagedResponse> listPagedCallable;
    private final UnaryCallable<ResizeReservationRequest, Operation> resizeCallable;
    private final UnaryCallable<SetIamPolicyReservationRequest, Policy> setIamPolicyCallable;
    private final UnaryCallable<TestIamPermissionsReservationRequest, TestPermissionsResponse> testIamPermissionsCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonReservationsStub create(ReservationsStubSettings settings) throws IOException {
        return new HttpJsonReservationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonReservationsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonReservationsStub(ReservationsStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonReservationsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonReservationsStub(ReservationsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonReservationsStub(ReservationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonReservationsCallableFactory());
    }

    protected HttpJsonReservationsStub(ReservationsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings aggregatedListTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(aggregatedListMethodDescriptor).build();
        HttpJsonCallSettings deleteTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMethodDescriptor).build();
        HttpJsonCallSettings getTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMethodDescriptor).build();
        HttpJsonCallSettings getIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings insertTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(insertMethodDescriptor).build();
        HttpJsonCallSettings listTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMethodDescriptor).build();
        HttpJsonCallSettings resizeTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(resizeMethodDescriptor).build();
        HttpJsonCallSettings setIamPolicyTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setIamPolicyMethodDescriptor).build();
        HttpJsonCallSettings testIamPermissionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(testIamPermissionsMethodDescriptor).build();
        this.aggregatedListCallable = callableFactory.createUnaryCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.aggregatedListPagedCallable = callableFactory.createPagedCallable(aggregatedListTransportSettings, settings.aggregatedListSettings(), clientContext);
        this.deleteCallable = callableFactory.createUnaryCallable(deleteTransportSettings, settings.deleteSettings(), clientContext);
        this.getCallable = callableFactory.createUnaryCallable(getTransportSettings, settings.getSettings(), clientContext);
        this.getIamPolicyCallable = callableFactory.createUnaryCallable(getIamPolicyTransportSettings, settings.getIamPolicySettings(), clientContext);
        this.insertCallable = callableFactory.createUnaryCallable(insertTransportSettings, settings.insertSettings(), clientContext);
        this.listCallable = callableFactory.createUnaryCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.listPagedCallable = callableFactory.createPagedCallable(listTransportSettings, settings.listSettings(), clientContext);
        this.resizeCallable = callableFactory.createUnaryCallable(resizeTransportSettings, settings.resizeSettings(), clientContext);
        this.setIamPolicyCallable = callableFactory.createUnaryCallable(setIamPolicyTransportSettings, settings.setIamPolicySettings(), clientContext);
        this.testIamPermissionsCallable = callableFactory.createUnaryCallable(testIamPermissionsTransportSettings, settings.testIamPermissionsSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    public UnaryCallable<AggregatedListReservationsRequest, ReservationsClient.AggregatedListPagedResponse> aggregatedListPagedCallable() {
        return this.aggregatedListPagedCallable;
    }

    @Override
    public UnaryCallable<AggregatedListReservationsRequest, ReservationAggregatedList> aggregatedListCallable() {
        return this.aggregatedListCallable;
    }

    @Override
    public UnaryCallable<DeleteReservationRequest, Operation> deleteCallable() {
        return this.deleteCallable;
    }

    @Override
    public UnaryCallable<GetReservationRequest, Reservation> getCallable() {
        return this.getCallable;
    }

    @Override
    public UnaryCallable<GetIamPolicyReservationRequest, Policy> getIamPolicyCallable() {
        return this.getIamPolicyCallable;
    }

    @Override
    public UnaryCallable<InsertReservationRequest, Operation> insertCallable() {
        return this.insertCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, ReservationsClient.ListPagedResponse> listPagedCallable() {
        return this.listPagedCallable;
    }

    @Override
    public UnaryCallable<ListReservationsRequest, ReservationList> listCallable() {
        return this.listCallable;
    }

    @Override
    public UnaryCallable<ResizeReservationRequest, Operation> resizeCallable() {
        return this.resizeCallable;
    }

    @Override
    public UnaryCallable<SetIamPolicyReservationRequest, Policy> setIamPolicyCallable() {
        return this.setIamPolicyCallable;
    }

    @Override
    public UnaryCallable<TestIamPermissionsReservationRequest, TestPermissionsResponse> testIamPermissionsCallable() {
        return this.testIamPermissionsCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

