/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.spi;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Address;
import com.google.api.services.compute.model.AttachedDisk;
import com.google.api.services.compute.model.DeprecationStatus;
import com.google.api.services.compute.model.Disk;
import com.google.api.services.compute.model.DiskType;
import com.google.api.services.compute.model.Image;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.License;
import com.google.api.services.compute.model.MachineType;
import com.google.api.services.compute.model.Metadata;
import com.google.api.services.compute.model.Network;
import com.google.api.services.compute.model.Operation;
import com.google.api.services.compute.model.Region;
import com.google.api.services.compute.model.Scheduling;
import com.google.api.services.compute.model.Snapshot;
import com.google.api.services.compute.model.Subnetwork;
import com.google.api.services.compute.model.Tags;
import com.google.api.services.compute.model.Zone;
import java.util.Map;

public interface ComputeRpc {
    public DiskType getDiskType(String var1, String var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<DiskType>> listDiskTypes(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<DiskType>> listDiskTypes(Map<Option, ?> var1);

    public MachineType getMachineType(String var1, String var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<MachineType>> listMachineTypes(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<MachineType>> listMachineTypes(Map<Option, ?> var1);

    public Region getRegion(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Region>> listRegions(Map<Option, ?> var1);

    public Zone getZone(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Zone>> listZones(Map<Option, ?> var1);

    public License getLicense(String var1, String var2, Map<Option, ?> var3);

    public Operation getGlobalOperation(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Operation>> listGlobalOperations(Map<Option, ?> var1);

    public boolean deleteGlobalOperation(String var1);

    public Operation getRegionOperation(String var1, String var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Operation>> listRegionOperations(String var1, Map<Option, ?> var2);

    public boolean deleteRegionOperation(String var1, String var2);

    public Operation getZoneOperation(String var1, String var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Operation>> listZoneOperations(String var1, Map<Option, ?> var2);

    public boolean deleteZoneOperation(String var1, String var2);

    public Address getGlobalAddress(String var1, Map<Option, ?> var2);

    public Operation createGlobalAddress(Address var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Address>> listGlobalAddresses(Map<Option, ?> var1);

    public Operation deleteGlobalAddress(String var1, Map<Option, ?> var2);

    public Address getRegionAddress(String var1, String var2, Map<Option, ?> var3);

    public Operation createRegionAddress(String var1, Address var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Address>> listRegionAddresses(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Address>> listAddresses(Map<Option, ?> var1);

    public Operation deleteRegionAddress(String var1, String var2, Map<Option, ?> var3);

    public Operation createSnapshot(String var1, String var2, String var3, String var4, Map<Option, ?> var5);

    public Snapshot getSnapshot(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Snapshot>> listSnapshots(Map<Option, ?> var1);

    public Operation deleteSnapshot(String var1, Map<Option, ?> var2);

    public Operation createImage(Image var1, Map<Option, ?> var2);

    public Image getImage(String var1, String var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Image>> listImages(String var1, Map<Option, ?> var2);

    public Operation deleteImage(String var1, String var2, Map<Option, ?> var3);

    public Operation deprecateImage(String var1, String var2, DeprecationStatus var3, Map<Option, ?> var4);

    public Disk getDisk(String var1, String var2, Map<Option, ?> var3);

    public Operation createDisk(String var1, Disk var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Disk>> listDisks(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Disk>> listDisks(Map<Option, ?> var1);

    public Operation deleteDisk(String var1, String var2, Map<Option, ?> var3);

    public Operation resizeDisk(String var1, String var2, long var3, Map<Option, ?> var5);

    public Operation createSubnetwork(String var1, Subnetwork var2, Map<Option, ?> var3);

    public Subnetwork getSubnetwork(String var1, String var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Subnetwork>> listSubnetworks(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Subnetwork>> listSubnetworks(Map<Option, ?> var1);

    public Operation deleteSubnetwork(String var1, String var2, Map<Option, ?> var3);

    public Operation createNetwork(Network var1, Map<Option, ?> var2);

    public Network getNetwork(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Network>> listNetworks(Map<Option, ?> var1);

    public Operation deleteNetwork(String var1, Map<Option, ?> var2);

    public Operation createInstance(String var1, Instance var2, Map<Option, ?> var3);

    public Instance getInstance(String var1, String var2, Map<Option, ?> var3);

    public Tuple<String, Iterable<Instance>> listInstances(String var1, Map<Option, ?> var2);

    public Tuple<String, Iterable<Instance>> listInstances(Map<Option, ?> var1);

    public Operation deleteInstance(String var1, String var2, Map<Option, ?> var3);

    public Operation addAccessConfig(String var1, String var2, String var3, AccessConfig var4, Map<Option, ?> var5);

    public Operation attachDisk(String var1, String var2, AttachedDisk var3, Map<Option, ?> var4);

    public Operation deleteAccessConfig(String var1, String var2, String var3, String var4, Map<Option, ?> var5);

    public Operation detachDisk(String var1, String var2, String var3, Map<Option, ?> var4);

    public String getSerialPortOutput(String var1, String var2, Integer var3, Map<Option, ?> var4);

    public Operation reset(String var1, String var2, Map<Option, ?> var3);

    public Operation setDiskAutoDelete(String var1, String var2, String var3, boolean var4, Map<Option, ?> var5);

    public Operation setMachineType(String var1, String var2, String var3, Map<Option, ?> var4);

    public Operation setMetadata(String var1, String var2, Metadata var3, Map<Option, ?> var4);

    public Operation setScheduling(String var1, String var2, Scheduling var3, Map<Option, ?> var4);

    public Operation setTags(String var1, String var2, Tags var3, Map<Option, ?> var4);

    public Operation start(String var1, String var2, Map<Option, ?> var3);

    public Operation stop(String var1, String var2, Map<Option, ?> var3);

    public static class Tuple<X, Y> {
        private final X x;
        private final Y y;

        private Tuple(X x, Y y) {
            this.x = x;
            this.y = y;
        }

        public static <X, Y> Tuple<X, Y> of(X x, Y y) {
            return new Tuple<X, Y>(x, y);
        }

        public X x() {
            return this.x;
        }

        public Y y() {
            return this.y;
        }
    }

    public static enum Option {
        FIELDS("fields"),
        MAX_RESULTS("maxResults"),
        PAGE_TOKEN("pageToken"),
        FILTER("filter");

        private final String value;

        private Option(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        <T> T get(Map<Option, ?> options) {
            return (T)options.get((Object)this);
        }

        String getString(Map<Option, ?> options) {
            return (String)this.get(options);
        }

        Long getLong(Map<Option, ?> options) {
            return (Long)this.get(options);
        }

        Boolean getBoolean(Map<Option, ?> options) {
            return (Boolean)this.get(options);
        }
    }
}

