/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListSubnetworksHttpRequest;
import com.google.cloud.compute.v1.DeleteSubnetworkHttpRequest;
import com.google.cloud.compute.v1.ExpandIpCidrRangeSubnetworkHttpRequest;
import com.google.cloud.compute.v1.GetIamPolicySubnetworkHttpRequest;
import com.google.cloud.compute.v1.GetSubnetworkHttpRequest;
import com.google.cloud.compute.v1.InsertSubnetworkHttpRequest;
import com.google.cloud.compute.v1.ListSubnetworksHttpRequest;
import com.google.cloud.compute.v1.ListUsableSubnetworksHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.PatchSubnetworkHttpRequest;
import com.google.cloud.compute.v1.Policy;
import com.google.cloud.compute.v1.SetIamPolicySubnetworkHttpRequest;
import com.google.cloud.compute.v1.SetPrivateIpGoogleAccessSubnetworkHttpRequest;
import com.google.cloud.compute.v1.Subnetwork;
import com.google.cloud.compute.v1.SubnetworkAggregatedList;
import com.google.cloud.compute.v1.SubnetworkClient;
import com.google.cloud.compute.v1.SubnetworkList;
import com.google.cloud.compute.v1.SubnetworksScopedList;
import com.google.cloud.compute.v1.TestIamPermissionsSubnetworkHttpRequest;
import com.google.cloud.compute.v1.TestPermissionsResponse;
import com.google.cloud.compute.v1.UsableSubnetwork;
import com.google.cloud.compute.v1.UsableSubnetworksAggregatedList;
import com.google.cloud.compute.v1.stub.HttpJsonSubnetworkStub;
import com.google.cloud.compute.v1.stub.SubnetworkStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SubnetworkStubSettings
extends StubSettings<SubnetworkStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworkClient.AggregatedListSubnetworksPagedResponse> aggregatedListSubnetworksSettings;
    private final UnaryCallSettings<DeleteSubnetworkHttpRequest, Operation> deleteSubnetworkSettings;
    private final UnaryCallSettings<ExpandIpCidrRangeSubnetworkHttpRequest, Operation> expandIpCidrRangeSubnetworkSettings;
    private final UnaryCallSettings<GetSubnetworkHttpRequest, Subnetwork> getSubnetworkSettings;
    private final UnaryCallSettings<GetIamPolicySubnetworkHttpRequest, Policy> getIamPolicySubnetworkSettings;
    private final UnaryCallSettings<InsertSubnetworkHttpRequest, Operation> insertSubnetworkSettings;
    private final PagedCallSettings<ListSubnetworksHttpRequest, SubnetworkList, SubnetworkClient.ListSubnetworksPagedResponse> listSubnetworksSettings;
    private final PagedCallSettings<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, SubnetworkClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings;
    private final UnaryCallSettings<PatchSubnetworkHttpRequest, Operation> patchSubnetworkSettings;
    private final UnaryCallSettings<SetIamPolicySubnetworkHttpRequest, Policy> setIamPolicySubnetworkSettings;
    private final UnaryCallSettings<SetPrivateIpGoogleAccessSubnetworkHttpRequest, Operation> setPrivateIpGoogleAccessSubnetworkSettings;
    private final UnaryCallSettings<TestIamPermissionsSubnetworkHttpRequest, TestPermissionsResponse> testIamPermissionsSubnetworkSettings;
    private static final PagedListDescriptor<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList> AGGREGATED_LIST_SUBNETWORKS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListSubnetworksHttpRequest injectToken(AggregatedListSubnetworksHttpRequest payload, String token) {
            return AggregatedListSubnetworksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListSubnetworksHttpRequest injectPageSize(AggregatedListSubnetworksHttpRequest payload, int pageSize) {
            return AggregatedListSubnetworksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListSubnetworksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SubnetworkAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SubnetworksScopedList> extractResources(SubnetworkAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork> LIST_SUBNETWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork>(){

        public String emptyToken() {
            return "";
        }

        public ListSubnetworksHttpRequest injectToken(ListSubnetworksHttpRequest payload, String token) {
            return ListSubnetworksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListSubnetworksHttpRequest injectPageSize(ListSubnetworksHttpRequest payload, int pageSize) {
            return ListSubnetworksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListSubnetworksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(SubnetworkList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subnetwork> extractResources(SubnetworkList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork> LIST_USABLE_SUBNETWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork>(){

        public String emptyToken() {
            return "";
        }

        public ListUsableSubnetworksHttpRequest injectToken(ListUsableSubnetworksHttpRequest payload, String token) {
            return ListUsableSubnetworksHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListUsableSubnetworksHttpRequest injectPageSize(ListUsableSubnetworksHttpRequest payload, int pageSize) {
            return ListUsableSubnetworksHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListUsableSubnetworksHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(UsableSubnetworksAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<UsableSubnetwork> extractResources(UsableSubnetworksAggregatedList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworkClient.AggregatedListSubnetworksPagedResponse> AGGREGATED_LIST_SUBNETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworkClient.AggregatedListSubnetworksPagedResponse>(){

        public ApiFuture<SubnetworkClient.AggregatedListSubnetworksPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList> callable, AggregatedListSubnetworksHttpRequest request, ApiCallContext context, ApiFuture<SubnetworkAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_SUBNETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubnetworkClient.AggregatedListSubnetworksPagedResponse.createAsync((PageContext<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworksScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSubnetworksHttpRequest, SubnetworkList, SubnetworkClient.ListSubnetworksPagedResponse> LIST_SUBNETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubnetworksHttpRequest, SubnetworkList, SubnetworkClient.ListSubnetworksPagedResponse>(){

        public ApiFuture<SubnetworkClient.ListSubnetworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubnetworksHttpRequest, SubnetworkList> callable, ListSubnetworksHttpRequest request, ApiCallContext context, ApiFuture<SubnetworkList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBNETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubnetworkClient.ListSubnetworksPagedResponse.createAsync((PageContext<ListSubnetworksHttpRequest, SubnetworkList, Subnetwork>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, SubnetworkClient.ListUsableSubnetworksPagedResponse> LIST_USABLE_SUBNETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, SubnetworkClient.ListUsableSubnetworksPagedResponse>(){

        public ApiFuture<SubnetworkClient.ListUsableSubnetworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList> callable, ListUsableSubnetworksHttpRequest request, ApiCallContext context, ApiFuture<UsableSubnetworksAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_USABLE_SUBNETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SubnetworkClient.ListUsableSubnetworksPagedResponse.createAsync((PageContext<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, UsableSubnetwork>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworkClient.AggregatedListSubnetworksPagedResponse> aggregatedListSubnetworksSettings() {
        return this.aggregatedListSubnetworksSettings;
    }

    public UnaryCallSettings<DeleteSubnetworkHttpRequest, Operation> deleteSubnetworkSettings() {
        return this.deleteSubnetworkSettings;
    }

    public UnaryCallSettings<ExpandIpCidrRangeSubnetworkHttpRequest, Operation> expandIpCidrRangeSubnetworkSettings() {
        return this.expandIpCidrRangeSubnetworkSettings;
    }

    public UnaryCallSettings<GetSubnetworkHttpRequest, Subnetwork> getSubnetworkSettings() {
        return this.getSubnetworkSettings;
    }

    public UnaryCallSettings<GetIamPolicySubnetworkHttpRequest, Policy> getIamPolicySubnetworkSettings() {
        return this.getIamPolicySubnetworkSettings;
    }

    public UnaryCallSettings<InsertSubnetworkHttpRequest, Operation> insertSubnetworkSettings() {
        return this.insertSubnetworkSettings;
    }

    public PagedCallSettings<ListSubnetworksHttpRequest, SubnetworkList, SubnetworkClient.ListSubnetworksPagedResponse> listSubnetworksSettings() {
        return this.listSubnetworksSettings;
    }

    public PagedCallSettings<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, SubnetworkClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings() {
        return this.listUsableSubnetworksSettings;
    }

    public UnaryCallSettings<PatchSubnetworkHttpRequest, Operation> patchSubnetworkSettings() {
        return this.patchSubnetworkSettings;
    }

    public UnaryCallSettings<SetIamPolicySubnetworkHttpRequest, Policy> setIamPolicySubnetworkSettings() {
        return this.setIamPolicySubnetworkSettings;
    }

    public UnaryCallSettings<SetPrivateIpGoogleAccessSubnetworkHttpRequest, Operation> setPrivateIpGoogleAccessSubnetworkSettings() {
        return this.setPrivateIpGoogleAccessSubnetworkSettings;
    }

    public UnaryCallSettings<TestIamPermissionsSubnetworkHttpRequest, TestPermissionsResponse> testIamPermissionsSubnetworkSettings() {
        return this.testIamPermissionsSubnetworkSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public SubnetworkStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSubnetworkStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SubnetworkStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SubnetworkStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SubnetworkStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListSubnetworksSettings = settingsBuilder.aggregatedListSubnetworksSettings().build();
        this.deleteSubnetworkSettings = settingsBuilder.deleteSubnetworkSettings().build();
        this.expandIpCidrRangeSubnetworkSettings = settingsBuilder.expandIpCidrRangeSubnetworkSettings().build();
        this.getSubnetworkSettings = settingsBuilder.getSubnetworkSettings().build();
        this.getIamPolicySubnetworkSettings = settingsBuilder.getIamPolicySubnetworkSettings().build();
        this.insertSubnetworkSettings = settingsBuilder.insertSubnetworkSettings().build();
        this.listSubnetworksSettings = settingsBuilder.listSubnetworksSettings().build();
        this.listUsableSubnetworksSettings = settingsBuilder.listUsableSubnetworksSettings().build();
        this.patchSubnetworkSettings = settingsBuilder.patchSubnetworkSettings().build();
        this.setIamPolicySubnetworkSettings = settingsBuilder.setIamPolicySubnetworkSettings().build();
        this.setPrivateIpGoogleAccessSubnetworkSettings = settingsBuilder.setPrivateIpGoogleAccessSubnetworkSettings().build();
        this.testIamPermissionsSubnetworkSettings = settingsBuilder.testIamPermissionsSubnetworkSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SubnetworkStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworkClient.AggregatedListSubnetworksPagedResponse> aggregatedListSubnetworksSettings;
        private final UnaryCallSettings.Builder<DeleteSubnetworkHttpRequest, Operation> deleteSubnetworkSettings;
        private final UnaryCallSettings.Builder<ExpandIpCidrRangeSubnetworkHttpRequest, Operation> expandIpCidrRangeSubnetworkSettings;
        private final UnaryCallSettings.Builder<GetSubnetworkHttpRequest, Subnetwork> getSubnetworkSettings;
        private final UnaryCallSettings.Builder<GetIamPolicySubnetworkHttpRequest, Policy> getIamPolicySubnetworkSettings;
        private final UnaryCallSettings.Builder<InsertSubnetworkHttpRequest, Operation> insertSubnetworkSettings;
        private final PagedCallSettings.Builder<ListSubnetworksHttpRequest, SubnetworkList, SubnetworkClient.ListSubnetworksPagedResponse> listSubnetworksSettings;
        private final PagedCallSettings.Builder<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, SubnetworkClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings;
        private final UnaryCallSettings.Builder<PatchSubnetworkHttpRequest, Operation> patchSubnetworkSettings;
        private final UnaryCallSettings.Builder<SetIamPolicySubnetworkHttpRequest, Policy> setIamPolicySubnetworkSettings;
        private final UnaryCallSettings.Builder<SetPrivateIpGoogleAccessSubnetworkHttpRequest, Operation> setPrivateIpGoogleAccessSubnetworkSettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsSubnetworkHttpRequest, TestPermissionsResponse> testIamPermissionsSubnetworkSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListSubnetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_SUBNETWORKS_PAGE_STR_FACT);
            this.deleteSubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.expandIpCidrRangeSubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getSubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.insertSubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSubnetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUBNETWORKS_PAGE_STR_FACT);
            this.listUsableSubnetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_USABLE_SUBNETWORKS_PAGE_STR_FACT);
            this.patchSubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setPrivateIpGoogleAccessSubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSubnetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSubnetworksSettings, this.deleteSubnetworkSettings, this.expandIpCidrRangeSubnetworkSettings, this.getSubnetworkSettings, this.getIamPolicySubnetworkSettings, this.insertSubnetworkSettings, this.listSubnetworksSettings, this.listUsableSubnetworksSettings, this.patchSubnetworkSettings, this.setIamPolicySubnetworkSettings, this.setPrivateIpGoogleAccessSubnetworkSettings, this.testIamPermissionsSubnetworkSettings, (Object[])new UnaryCallSettings.Builder[0]);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SubnetworkStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SubnetworkStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SubnetworkStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(SubnetworkStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListSubnetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteSubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.expandIpCidrRangeSubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getSubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIamPolicySubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.insertSubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listSubnetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listUsableSubnetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.patchSubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setIamPolicySubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.setPrivateIpGoogleAccessSubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.testIamPermissionsSubnetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(SubnetworkStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListSubnetworksSettings = settings.aggregatedListSubnetworksSettings.toBuilder();
            this.deleteSubnetworkSettings = settings.deleteSubnetworkSettings.toBuilder();
            this.expandIpCidrRangeSubnetworkSettings = settings.expandIpCidrRangeSubnetworkSettings.toBuilder();
            this.getSubnetworkSettings = settings.getSubnetworkSettings.toBuilder();
            this.getIamPolicySubnetworkSettings = settings.getIamPolicySubnetworkSettings.toBuilder();
            this.insertSubnetworkSettings = settings.insertSubnetworkSettings.toBuilder();
            this.listSubnetworksSettings = settings.listSubnetworksSettings.toBuilder();
            this.listUsableSubnetworksSettings = settings.listUsableSubnetworksSettings.toBuilder();
            this.patchSubnetworkSettings = settings.patchSubnetworkSettings.toBuilder();
            this.setIamPolicySubnetworkSettings = settings.setIamPolicySubnetworkSettings.toBuilder();
            this.setPrivateIpGoogleAccessSubnetworkSettings = settings.setPrivateIpGoogleAccessSubnetworkSettings.toBuilder();
            this.testIamPermissionsSubnetworkSettings = settings.testIamPermissionsSubnetworkSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListSubnetworksSettings, this.deleteSubnetworkSettings, this.expandIpCidrRangeSubnetworkSettings, this.getSubnetworkSettings, this.getIamPolicySubnetworkSettings, this.insertSubnetworkSettings, this.listSubnetworksSettings, this.listUsableSubnetworksSettings, this.patchSubnetworkSettings, this.setIamPolicySubnetworkSettings, this.setPrivateIpGoogleAccessSubnetworkSettings, this.testIamPermissionsSubnetworkSettings, (Object[])new UnaryCallSettings.Builder[0]);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListSubnetworksHttpRequest, SubnetworkAggregatedList, SubnetworkClient.AggregatedListSubnetworksPagedResponse> aggregatedListSubnetworksSettings() {
            return this.aggregatedListSubnetworksSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubnetworkHttpRequest, Operation> deleteSubnetworkSettings() {
            return this.deleteSubnetworkSettings;
        }

        public UnaryCallSettings.Builder<ExpandIpCidrRangeSubnetworkHttpRequest, Operation> expandIpCidrRangeSubnetworkSettings() {
            return this.expandIpCidrRangeSubnetworkSettings;
        }

        public UnaryCallSettings.Builder<GetSubnetworkHttpRequest, Subnetwork> getSubnetworkSettings() {
            return this.getSubnetworkSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicySubnetworkHttpRequest, Policy> getIamPolicySubnetworkSettings() {
            return this.getIamPolicySubnetworkSettings;
        }

        public UnaryCallSettings.Builder<InsertSubnetworkHttpRequest, Operation> insertSubnetworkSettings() {
            return this.insertSubnetworkSettings;
        }

        public PagedCallSettings.Builder<ListSubnetworksHttpRequest, SubnetworkList, SubnetworkClient.ListSubnetworksPagedResponse> listSubnetworksSettings() {
            return this.listSubnetworksSettings;
        }

        public PagedCallSettings.Builder<ListUsableSubnetworksHttpRequest, UsableSubnetworksAggregatedList, SubnetworkClient.ListUsableSubnetworksPagedResponse> listUsableSubnetworksSettings() {
            return this.listUsableSubnetworksSettings;
        }

        public UnaryCallSettings.Builder<PatchSubnetworkHttpRequest, Operation> patchSubnetworkSettings() {
            return this.patchSubnetworkSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicySubnetworkHttpRequest, Policy> setIamPolicySubnetworkSettings() {
            return this.setIamPolicySubnetworkSettings;
        }

        public UnaryCallSettings.Builder<SetPrivateIpGoogleAccessSubnetworkHttpRequest, Operation> setPrivateIpGoogleAccessSubnetworkSettings() {
            return this.setPrivateIpGoogleAccessSubnetworkSettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsSubnetworkHttpRequest, TestPermissionsResponse> testIamPermissionsSubnetworkSettings() {
            return this.testIamPermissionsSubnetworkSettings;
        }

        public SubnetworkStubSettings build() throws IOException {
            return new SubnetworkStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

